/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant.pe.res.util;

import com.orangevolt.tools.ant.pe.res.util.BinaryInputStream;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class IcoCodec {
    public static BufferedImage[] loadImages(File f) throws IOException {
        FileInputStream istream = new FileInputStream(f);
        BufferedInputStream buffin = new BufferedInputStream(istream);
        BinaryInputStream in = new BinaryInputStream(buffin);
        try {
            in.mark(32000);
            IconDir dir = new IconDir(in);
            IconEntry[] entries = new IconEntry[dir.idCount];
            BufferedImage[] images = new BufferedImage[dir.idCount];
            for (int i = 0; i < dir.idCount; ++i) {
                entries[i] = new IconEntry(in);
            }
            IconEntry entry = entries[0];
            for (int i = 0; i < dir.idCount; ++i) {
                in.reset();
                in.skip(entries[i].dwImageOffset);
                IconHeader header = new IconHeader(in);
                long toskip = header.Size - 40L;
                if (toskip > 0L) {
                    in.skip((int)toskip);
                }
                BufferedImage image = new BufferedImage((int)header.Width, (int)header.Height / 2, 2);
                switch (header.BitsPerPixel) {
                    case 4: 
                    case 8: {
                        IcoCodec.loadPalettedImage(in, entries[i], header, image);
                        break;
                    }
                    default: {
                        throw new Exception("Unsupported ICO color depth: " + header.BitsPerPixel);
                    }
                }
                images[i] = image;
            }
            return images;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static void loadPalettedImage(BinaryInputStream in, IconEntry entry, IconHeader header, BufferedImage image) throws Exception {
        int cols = (int)header.ColorsUsed;
        if (cols == 0) {
            cols = entry.bColorCount != 0 ? (int)entry.bColorCount : 1 << header.BitsPerPixel;
        }
        int[] redp = new int[cols];
        int[] greenp = new int[cols];
        int[] bluep = new int[cols];
        for (int i = 0; i < cols; ++i) {
            bluep[i] = in.readUByte();
            greenp[i] = in.readUByte();
            redp[i] = in.readUByte();
            in.readUByte();
        }
        int xorbytes = (int)header.Height / 2 * (int)header.Width;
        int readbytes = 0;
        for (int y = (int)(header.Height / 2L) - 1; y >= 0; --y) {
            int x = 0;
            while ((long)x < header.Width) {
                switch (header.BitsPerPixel) {
                    case 4: {
                        short pix = in.readUByte();
                        ++readbytes;
                        int col1 = pix >> 4 & 0xF;
                        int col2 = pix & 0xF;
                        image.setRGB(x, y, 0xFF000000 | redp[col1] << 16 | greenp[col1] << 8 | bluep[col1]);
                        image.setRGB(++x, y, 0xFF000000 | redp[col2] << 16 | greenp[col2] << 8 | bluep[col2]);
                        break;
                    }
                    case 8: {
                        short col1 = in.readUByte();
                        ++readbytes;
                        image.setRGB(x, y, 0xFF000000 | redp[col1] << 16 | greenp[col1] << 8 | bluep[col1]);
                    }
                }
                ++x;
            }
        }
        int height = (int)(header.Height / 2L);
        int rowsize = (int)header.Width / 8;
        if (rowsize % 4 > 0) {
            rowsize += 4 - rowsize % 4;
        }
        int[] andbytes = new int[rowsize * height];
        for (int i = 0; i < andbytes.length; ++i) {
            andbytes[i] = in.readUByte();
        }
        for (int y = height - 1; y >= 0; --y) {
            int x = 0;
            while ((long)x < header.Width) {
                int offset = (height - (y + 1)) * rowsize + x / 8;
                if ((andbytes[offset] & 1 << 7 - x % 8) != 0) {
                    image.setRGB(x, y, 0);
                }
                ++x;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        BufferedImage img = IcoCodec.loadImages(f)[0];
        JFrame jf = new JFrame("Test");
        JButton button = new JButton(new ImageIcon(img));
        jf.getContentPane().add(button);
        jf.pack();
        jf.setVisible(true);
    }

    public static class IconHeader {
        public long Size;
        public long Width;
        public long Height;
        public int Planes;
        public int BitsPerPixel;
        public long Compression;
        public long SizeOfBitmap;
        public long HorzResolution;
        public long VertResolution;
        public long ColorsUsed;
        public long ColorsImportant;

        public IconHeader(BinaryInputStream in) throws IOException {
            this.Size = in.readUIntLE();
            this.Width = in.readUIntLE();
            this.Height = in.readUIntLE();
            this.Planes = in.readUShortLE();
            this.BitsPerPixel = in.readUShortLE();
            this.Compression = in.readUIntLE();
            this.SizeOfBitmap = in.readUIntLE();
            this.HorzResolution = in.readUIntLE();
            this.VertResolution = in.readUIntLE();
            this.ColorsUsed = in.readUIntLE();
            this.ColorsImportant = in.readUIntLE();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Size=");
            buffer.append(this.Size);
            buffer.append("\nWidth=");
            buffer.append(this.Width);
            buffer.append("\nHeight=");
            buffer.append(this.Height);
            buffer.append("\nPlanes=");
            buffer.append(this.Planes);
            buffer.append("\nBitsPerPixel=");
            buffer.append(this.BitsPerPixel);
            buffer.append("\nCompression=");
            buffer.append(this.Compression);
            buffer.append("\nSizeOfBitmap=");
            buffer.append(this.SizeOfBitmap);
            buffer.append("\nHorzResolution=");
            buffer.append(this.HorzResolution);
            buffer.append("\nVertResolution=");
            buffer.append(this.VertResolution);
            buffer.append("\nColorsUsed=");
            buffer.append(this.ColorsUsed);
            buffer.append("\nColorsImportant=");
            buffer.append(this.ColorsImportant);
            return buffer.toString();
        }
    }

    public static class IconEntry {
        short bWidth;
        short bHeight;
        short bColorCount;
        short bReserved;
        int wPlanes;
        int wBitCount;
        long dwBytesInRes;
        long dwImageOffset;

        public IconEntry(BinaryInputStream in) throws IOException {
            this.bWidth = in.readUByte();
            this.bHeight = in.readUByte();
            this.bColorCount = in.readUByte();
            this.bReserved = in.readUByte();
            this.wPlanes = in.readUShortLE();
            this.wBitCount = in.readUShortLE();
            this.dwBytesInRes = in.readUIntLE();
            this.dwImageOffset = in.readUIntLE();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{ bWidth=" + this.bWidth + "\n");
            buffer.append("  bHeight=" + this.bHeight + "\n");
            buffer.append("  bColorCount=" + this.bColorCount + "\n");
            buffer.append("  wPlanes=" + this.wPlanes + "\n");
            buffer.append("  wBitCount=" + this.wBitCount + "\n");
            buffer.append("  dwBytesInRes=" + this.dwBytesInRes + "\n");
            buffer.append("  dwImageOffset=" + this.dwImageOffset + "\n");
            buffer.append("}");
            return buffer.toString();
        }
    }

    public static class IconDir {
        int idType;
        int idCount;

        public IconDir(BinaryInputStream in) throws IOException {
            in.readUShortLE();
            this.idType = in.readUShortLE();
            this.idCount = in.readUShortLE();
        }

        public String toString() {
            return "{ idType=" + this.idType + ", " + this.idCount + " }";
        }
    }
}

