/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant.pe;

import com.orangevolt.tools.ant.pe.PEFile;
import com.orangevolt.tools.ant.pe.PESection;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Vector;

public class PEResourceDirectory {
    PESection m_master;
    PEFile m_file;
    long m_offsetBase;
    ImageResourceDirectory m_root;

    public PEResourceDirectory(PEFile file, PESection sect) throws IOException {
        this.m_master = sect;
        this.m_file = file;
        this.m_offsetBase = sect.PointerToRawData;
        this.init();
    }

    public void init() throws IOException {
        ImageResourceDirectory dir;
        FileChannel chan = this.m_file.getChannel();
        chan.position(this.m_master.PointerToRawData);
        this.m_root = dir = new ImageResourceDirectory(chan);
    }

    public void dump(PrintStream out) {
        this.m_root.dump(out, 0);
    }

    public int size() {
        return this.m_root.diskSize();
    }

    public ByteBuffer buildResource(long virtualBaseOffset) {
        int resourceSize = this.m_root.diskSize();
        ByteBuffer resbuf = ByteBuffer.allocate(resourceSize);
        resbuf.order(ByteOrder.LITTLE_ENDIAN);
        resbuf.position(0);
        this.m_root.buildBuffer(resbuf, virtualBaseOffset);
        return resbuf;
    }

    public ImageResourceDirectory getRoot() {
        return this.m_root;
    }

    public boolean replaceResource(String catId, int resourceId, int langId, ByteBuffer data) {
        ResourceEntry langEntry;
        ResourceEntry identEntry;
        ResourceEntry catEntry = this.m_root.getResourceEntry(catId);
        if (catEntry != null && catEntry.Directory != null && (identEntry = catEntry.Directory.getResourceEntry(resourceId)) != null && identEntry.Directory != null && (langEntry = identEntry.Directory.getResourceEntry(langId)) != null && langEntry.Data != null) {
            DataEntry dataslot = langEntry.Data;
            dataslot.setData(data);
            return true;
        }
        return false;
    }

    public void addNewResource(String catId, String resourceId, String languageId, ByteBuffer data) {
        DataEntry dataEntry = new DataEntry(data);
        ResourceEntry languageEntry = this.buildResourceEntry(languageId, dataEntry);
        ImageResourceDirectory languageDir = new ImageResourceDirectory();
        languageDir.TimeDateStamp = 1059901284L;
        languageDir.addEntry(languageEntry);
        ResourceEntry identEntry = this.buildResourceEntry(resourceId, languageDir);
        ImageResourceDirectory identDir = new ImageResourceDirectory();
        identDir.TimeDateStamp = 1059901284L;
        identDir.addEntry(identEntry);
        ResourceEntry catEntry = this.buildResourceEntry(catId, identDir);
        this.m_root.addEntry(catEntry);
    }

    public DataEntry getData(String catId, String resourceId, String langId) {
        ResourceEntry langEntry;
        ResourceEntry identEntry;
        ResourceEntry catEntry = this.m_root.getResourceEntry(catId);
        if (catEntry != null && catEntry.Directory != null && (identEntry = catEntry.Directory.getResourceEntry(resourceId)) != null && identEntry.Directory != null && (langEntry = identEntry.Directory.getResourceEntry(langId)) != null && langEntry.Data != null) {
            DataEntry dataslot = langEntry.Data;
            return dataslot;
        }
        return null;
    }

    public ResourceEntry buildResourceEntry(String id, DataEntry data) {
        if (id.length() > 1 && id.charAt(0) == '#') {
            int intid = Integer.parseInt(id.substring(1));
            return new ResourceEntry(intid, data);
        }
        return new ResourceEntry(id, data);
    }

    public ResourceEntry buildResourceEntry(String id, ImageResourceDirectory dir) {
        if (id.length() > 1 && id.charAt(0) == '#') {
            int intid = Integer.parseInt(id.substring(1));
            return new ResourceEntry(intid, dir);
        }
        return new ResourceEntry(id, dir);
    }

    public class ImageResourceDirectory {
        long Characteristics;
        long TimeDateStamp;
        int MajorVersion;
        int MinorVersion;
        int NumberOfNamedEntries;
        int NumberOfIdEntries;
        Vector NamedEntries = new Vector();
        Vector IdEntries = new Vector();

        public ImageResourceDirectory() {
        }

        public ImageResourceDirectory(FileChannel chan) throws IOException {
            ResourceEntry re;
            int i;
            ByteBuffer header = ByteBuffer.allocate(16);
            header.order(ByteOrder.LITTLE_ENDIAN);
            chan.read(header);
            header.position(0);
            this.Characteristics = header.getInt();
            this.TimeDateStamp = header.getInt();
            this.MajorVersion = header.getShort();
            this.MinorVersion = header.getShort();
            this.NumberOfNamedEntries = header.getShort();
            this.NumberOfIdEntries = header.getShort();
            for (i = 0; i < this.NumberOfNamedEntries; ++i) {
                re = new ResourceEntry(chan);
                this.NamedEntries.add(re);
            }
            for (i = 0; i < this.NumberOfIdEntries; ++i) {
                re = new ResourceEntry(chan);
                this.IdEntries.add(re);
            }
        }

        public void addNamedEntry(ResourceEntry entry) {
            this.NamedEntries.add(entry);
        }

        public void addIdEntry(ResourceEntry entry) {
            this.IdEntries.add(entry);
        }

        public void addEntry(ResourceEntry entry) {
            if (entry.Name != null) {
                this.addNamedEntry(entry);
            } else {
                this.addIdEntry(entry);
            }
        }

        public void dump(PrintStream out, int level) {
            ResourceEntry re;
            int i;
            this.indent(level, out);
            out.println("Directory: ");
            this.indent(level, out);
            out.println("Characteristics=" + this.Characteristics);
            this.indent(level, out);
            out.println("TimeDateStamp=" + this.TimeDateStamp);
            this.indent(level, out);
            out.println("MajorVersion=" + this.MajorVersion);
            this.indent(level, out);
            out.println("MinorVersion=" + this.MinorVersion);
            this.indent(level, out);
            out.println("NumberOfNamedEntries=" + this.NumberOfNamedEntries);
            this.indent(level, out);
            out.println("NumberOfIdEntries=" + this.NumberOfIdEntries);
            this.indent(level, out);
            out.println("Named Entries:");
            for (i = 0; i < this.NumberOfNamedEntries; ++i) {
                re = (ResourceEntry)this.NamedEntries.get(i);
                re.dump(out, level + 1);
            }
            this.indent(level, out);
            out.println("Id Entries:");
            for (i = 0; i < this.NumberOfIdEntries; ++i) {
                re = (ResourceEntry)this.IdEntries.get(i);
                re.dump(out, level + 1);
            }
        }

        private void indent(int level, PrintStream out) {
            for (int i = 0; i < level; ++i) {
                out.print("    ");
            }
        }

        public int diskSize() {
            ResourceEntry re;
            int i;
            int size = 16;
            for (i = 0; i < this.NamedEntries.size(); ++i) {
                re = (ResourceEntry)this.NamedEntries.get(i);
                size += re.diskSize();
            }
            for (i = 0; i < this.IdEntries.size(); ++i) {
                re = (ResourceEntry)this.IdEntries.get(i);
                size += re.diskSize();
            }
            if (size % 4 > 0) {
                size += 4 - size % 4;
            }
            return size;
        }

        public int buildBuffer(ByteBuffer buffer, long virtualBaseOffset) {
            ResourceEntry re;
            int i;
            buffer.putInt((int)this.Characteristics);
            buffer.putInt((int)this.TimeDateStamp);
            buffer.putShort((short)this.MajorVersion);
            buffer.putShort((short)this.MinorVersion);
            buffer.putShort((short)this.NamedEntries.size());
            buffer.putShort((short)this.IdEntries.size());
            int dataOffset = buffer.position() + this.NamedEntries.size() * 8 + this.IdEntries.size() * 8;
            for (i = 0; i < this.NamedEntries.size(); ++i) {
                re = (ResourceEntry)this.NamedEntries.get(i);
                dataOffset = re.buildBuffer(buffer, virtualBaseOffset, dataOffset);
            }
            for (i = 0; i < this.IdEntries.size(); ++i) {
                re = (ResourceEntry)this.IdEntries.get(i);
                dataOffset = re.buildBuffer(buffer, virtualBaseOffset, dataOffset);
            }
            buffer.position(dataOffset);
            return dataOffset;
        }

        public ResourceEntry getResourceEntry(String name) {
            if (name == null) {
                if (this.NamedEntries.size() > 0) {
                    return (ResourceEntry)this.NamedEntries.get(0);
                }
                if (this.IdEntries.size() > 0) {
                    return (ResourceEntry)this.IdEntries.get(0);
                }
                return null;
            }
            if (name.length() > 0 && name.charAt(0) == '#') {
                try {
                    String nb = name.substring(1);
                    int i = Integer.parseInt(nb);
                    return this.getResourceEntry(i);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            Iterator i = this.NamedEntries.iterator();
            while (i.hasNext()) {
                ResourceEntry re = (ResourceEntry)i.next();
                if (!name.equals(re.Name)) continue;
                return re;
            }
            return null;
        }

        public ResourceEntry getResourceEntry(int id) {
            Iterator i = this.IdEntries.iterator();
            while (i.hasNext()) {
                ResourceEntry re = (ResourceEntry)i.next();
                if (id != re.Id) continue;
                return re;
            }
            return null;
        }
    }

    public class ResourceEntry {
        int Id;
        String Name;
        ImageResourceDirectory Directory;
        DataEntry Data;

        public ResourceEntry(int id, DataEntry data) {
            this.Id = id;
            this.Data = data;
        }

        public ResourceEntry(String name, DataEntry data) {
            this.Name = name;
            this.Data = data;
        }

        public ResourceEntry(int id, ImageResourceDirectory dir) {
            this.Id = id;
            this.Directory = dir;
        }

        public ResourceEntry(String name, ImageResourceDirectory dir) {
            this.Name = name;
            this.Directory = dir;
        }

        public ResourceEntry(FileChannel chan) throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            chan.read(buf);
            buf.position(0);
            long orgchanpos = chan.position();
            int val = buf.getInt();
            long offsetToData = buf.getInt();
            if (val < 0) {
                this.Name = this.extractStringAt(chan, val &= Integer.MAX_VALUE);
                this.Id = -1;
            } else {
                this.Id = val;
            }
            if (offsetToData < 0L) {
                long orgpos = chan.position();
                chan.position(PEResourceDirectory.this.m_offsetBase + (offsetToData &= Integer.MAX_VALUE));
                this.Directory = new ImageResourceDirectory(chan);
                chan.position(orgpos);
            } else {
                this.Data = new DataEntry(chan, offsetToData);
            }
        }

        public String extractStringAt(FileChannel chan, int offset) throws IOException {
            long orgchanpos = chan.position();
            chan.position(PEResourceDirectory.this.m_offsetBase + (long)offset);
            ByteBuffer sizebuf = ByteBuffer.allocate(2);
            sizebuf.order(ByteOrder.LITTLE_ENDIAN);
            chan.read(sizebuf);
            sizebuf.position(0);
            int size = sizebuf.getShort();
            ByteBuffer buffer = ByteBuffer.allocate(size * 2);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            chan.read(buffer);
            buffer.position(0);
            StringBuffer buf = new StringBuffer(size);
            for (int i = 0; i < size; ++i) {
                short c = buffer.getShort();
                buf.append((char)c);
            }
            chan.position(orgchanpos);
            return buf.toString();
        }

        public int diskSize() {
            int size = 8;
            if (this.Name != null) {
                size += this.Name.length() * 2 + 2;
            }
            if (this.Directory != null) {
                size += this.Directory.diskSize();
            } else if (this.Data != null) {
                size += this.Data.diskSize();
            }
            if (size % 4 > 0) {
                size += 4 - size % 4;
            }
            return size;
        }

        public void dump(PrintStream out, int level) {
            this.indent(level, out);
            if (this.Name != null) {
                out.println("Name=" + this.Name);
            } else {
                out.println("Id=#" + this.Id);
            }
            this.indent(level, out);
            if (this.Directory != null) {
                out.println("ENTRY: DIRECTORY POINTER");
                this.Directory.dump(out, level + 1);
            } else {
                out.println("ENTRY: DATA ENTRY");
                this.Data.dump(out, level + 1);
            }
        }

        private void indent(int level, PrintStream out) {
            for (int i = 0; i < level; ++i) {
                out.print("    ");
            }
        }

        public int buildBuffer(ByteBuffer buffer, long virtualBaseOffset, int dataOffset) {
            int oldpos;
            if (this.Name != null) {
                buffer.putInt(dataOffset | Integer.MIN_VALUE);
                int stringoffset = dataOffset;
                ByteBuffer strbuf = ByteBuffer.allocate(this.Name.length() * 2 + 2);
                strbuf.order(ByteOrder.LITTLE_ENDIAN);
                strbuf.putShort((short)this.Name.length());
                for (int i = 0; i < this.Name.length(); ++i) {
                    strbuf.putShort((short)this.Name.charAt(i));
                }
                strbuf.position(0);
                long oldpos2 = buffer.position();
                buffer.position(dataOffset);
                buffer.put(strbuf);
                if ((dataOffset += this.Name.length() * 2 + 2) % 4 != 0) {
                    dataOffset += 4 - dataOffset % 4;
                }
                buffer.position((int)oldpos2);
            } else {
                buffer.putInt(this.Id);
            }
            if (this.Directory != null) {
                int dirsize;
                buffer.putInt(dataOffset | Integer.MIN_VALUE);
                oldpos = buffer.position();
                buffer.position(dataOffset);
                dataOffset = dirsize = this.Directory.buildBuffer(buffer, virtualBaseOffset);
                buffer.position(oldpos);
            } else if (this.Data != null) {
                buffer.putInt(dataOffset);
                oldpos = buffer.position();
                buffer.position(dataOffset);
                dataOffset = this.Data.buildBuffer(buffer, virtualBaseOffset, dataOffset);
                buffer.position(oldpos);
            } else {
                throw new RuntimeException("Directory and Data are both null!");
            }
            return dataOffset;
        }
    }

    public class DataEntry {
        long OffsetToData;
        long Size;
        long CodePage;
        long Reserved;
        ByteBuffer Data;

        public DataEntry(ByteBuffer data) {
            this.Data = data;
            this.Size = data.capacity();
        }

        public DataEntry(FileChannel chan, long offset) throws IOException {
            long orgpos = chan.position();
            chan.position(PEResourceDirectory.this.m_offsetBase + offset);
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            chan.read(buf);
            buf.position(0);
            this.OffsetToData = buf.getInt();
            this.Size = buf.getInt();
            this.CodePage = buf.getInt();
            this.Reserved = buf.getInt();
            long datapos = PEResourceDirectory.this.m_master.PointerToRawData + (this.OffsetToData - PEResourceDirectory.this.m_master.VirtualAddress);
            this.Data = ByteBuffer.allocate((int)this.Size);
            this.Data.order(ByteOrder.LITTLE_ENDIAN);
            chan.position(datapos);
            chan.read(this.Data);
            this.Data.position(0);
            chan.position(orgpos);
        }

        public int diskSize() {
            int size = 16 + (int)this.Size;
            if (size % 4 > 0) {
                size += 4 - size % 4;
            }
            return size;
        }

        public void dump(PrintStream out, int level) {
            this.indent(level, out);
            out.println("OffsetToData=" + this.OffsetToData);
            this.indent(level, out);
            out.println("Size=" + this.Size);
            this.indent(level, out);
            out.println("CodePage=" + this.CodePage);
            this.indent(level, out);
            out.println("Reserved=" + this.Reserved);
            this.indent(level, out);
            out.print("Data={ ");
            for (int i = 0; i < this.Data.capacity(); ++i) {
                out.print("" + Integer.toHexString(this.Data.get()) + ",");
            }
            out.println(" }");
        }

        private void indent(int level, PrintStream out) {
            for (int i = 0; i < level; ++i) {
                out.print("    ");
            }
        }

        public int buildBuffer(ByteBuffer buffer, long virtualBaseOffset, int dataOffset) {
            dataOffset = buffer.position() + 16;
            buffer.putInt((int)((long)dataOffset + virtualBaseOffset));
            buffer.putInt((int)this.Size);
            buffer.putInt((int)this.CodePage);
            buffer.putInt((int)this.Reserved);
            this.Data.position(0);
            buffer.put(this.Data);
            dataOffset = (int)((long)dataOffset + this.Size);
            if (dataOffset % 4 > 0) {
                dataOffset += 4 - dataOffset % 4;
            }
            return dataOffset;
        }

        public void setData(ByteBuffer data) {
            this.Data = data;
            this.Size = data.capacity();
        }
    }
}

