/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant.http;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.JavaEnvUtils;
import sun.net.www.http.HttpClient;

public class SetProxy
extends Task {
    protected String proxyHost = null;
    protected int proxyPort = 80;
    private String socksProxyHost = null;
    private int socksProxyPort = 1080;

    public void setProxyHost(String hostname) {
        this.proxyHost = hostname;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setSocksProxyHost(String host) {
        this.socksProxyHost = host;
    }

    public void setSocksProxyPort(int port) {
        this.socksProxyPort = port;
    }

    public void applyWebProxySettings() {
        boolean settingsChanged = false;
        Properties prop = System.getProperties();
        if (this.getProxyHost() != null) {
            this.log("Setting proxy to " + this.getProxyHost() + ":" + this.getProxyPort(), 3);
            prop.put("http.proxyHost", this.getProxyHost());
            prop.put("http.proxyPort", String.valueOf(this.getProxyPort()));
            prop.put("https.proxyHost", this.getProxyHost());
            prop.put("https.proxyPort", String.valueOf(this.getProxyPort()));
            prop.put("ftp.proxyHost", this.getProxyHost());
            prop.put("ftp.proxyPort", String.valueOf(this.getProxyPort()));
            settingsChanged = true;
        }
        if (this.socksProxyHost != null) {
            this.log("Setting proxy to " + this.getProxyHost() + ":" + this.getProxyPort(), 3);
            prop.put("socksProxyHost", this.socksProxyHost);
            prop.put("socksProxyPort", Integer.toString(this.socksProxyPort));
            settingsChanged = true;
        }
        if (settingsChanged && JavaEnvUtils.getJavaVersion() == "1.1") {
            prop.put("http.proxySet", "true");
            HttpClient.resetProperties();
        }
        this.legacyResetProxySettingsCall();
    }

    protected boolean legacyResetProxySettingsCall() {
        try {
            Class<?> c = Class.forName("sun.net.www.http.HttpClient");
            Method reset = c.getMethod("resetProperties", null);
            reset.invoke(null, null);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public void execute() throws BuildException {
        this.applyWebProxySettings();
    }
}

