/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteFileTask
extends Task {
    File file = null;
    String text = null;
    boolean append = false;

    public void setSrc(File file) {
        try {
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileInputStream in = new FileInputStream(file);
            while ((i = ((InputStream)in).read()) != -1) {
                out.write(i);
            }
            this.text = out.toString();
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            throw new BuildException("Reading src " + file.getAbsolutePath() + " failed : " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void addText(String s) {
        if (this.text != null) {
            throw new BuildException("text content already defined by attribute \"src\".");
        }
        if (s.trim().length() > 0) {
            this.text = s.trim();
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean b) {
        this.append = true;
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("attribute \"file\" is required.");
        }
        if (this.text == null) {
            throw new BuildException("Either attribute \"src\" or inner text content is required.");
        }
        if (this.append && this.file.exists()) {
            try {
                int i;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FileInputStream in = new FileInputStream(this.file);
                while ((i = ((InputStream)in).read()) != -1) {
                    out.write(i);
                }
                this.text = out.toString();
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                throw new BuildException("Reading file contents to append to from " + this.file.getAbsolutePath() + " failed : " + ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.file));
            pw.print(this.getProject().replaceProperties(this.text));
            pw.close();
        }
        catch (IOException ex) {
            throw new BuildException("Write file " + this.file.getAbsolutePath() + " failed : " + ex.getMessage(), (Throwable)ex);
        }
    }
}

