/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import com.roxes.win32.Registry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Win32RegistryTask
extends Task {
    protected static final DocumentBuilder builder;
    int root = -1;
    String key = null;
    Registry reg = null;
    ArrayList subTasks = new ArrayList();

    public Exists createExists() {
        Exists exists = new Exists();
        this.subTasks.add(exists);
        return exists;
    }

    public Delete createDelete() {
        Delete delete = new Delete();
        this.subTasks.add(delete);
        return delete;
    }

    public Get createGet() {
        Get get = new Get();
        this.subTasks.add(get);
        return get;
    }

    public Set createSet() {
        Set set = new Set();
        this.subTasks.add(set);
        return set;
    }

    public Import createImport() {
        Import _import = new Import();
        this.subTasks.add(_import);
        return _import;
    }

    public Export createExport() {
        Export export = new Export();
        this.subTasks.add(export);
        return export;
    }

    public void execute() throws BuildException {
        if (this.root == -1) {
            throw new BuildException("attribute \"root\" is required.");
        }
        if (this.key == null) {
            this.key = "";
        }
        this.reg = new Registry(this.root, this.key);
        Iterator iter = this.subTasks.iterator();
        while (iter.hasNext()) {
            ((Runnable)iter.next()).run();
        }
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setRoot(String string) {
        if ((string = string.toUpperCase()).equals("HKEY_CLASSES_ROOT")) {
            this.root = Integer.MIN_VALUE;
        } else if (string.equals("HKEY_CURRENT_USER")) {
            this.root = -2147483647;
        } else if (string.equals("HKEY_LOCAL_MACHINE")) {
            this.root = -2147483646;
        } else if (string.equals("HKEY_USERS")) {
            this.root = -2147483645;
        } else {
            throw new BuildException(string + " is not a valid registry root (valid are HKEY_CLASSES_ROOT, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE and HKEY_USERS).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DocumentBuilder tempBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            try {
                tempBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                tempBuilder = null;
            }
        }
        finally {
            builder = tempBuilder;
        }
    }

    public class Import
    implements Runnable {
        File file = null;
        String subKey = null;
        String text = null;

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void setFile(File f) {
            this.file = f;
        }

        public void addText(String s) {
            this.text = Win32RegistryTask.this.getProject().replaceProperties(s.trim());
        }

        public void run() {
            if (this.file == this.text) {
                throw new BuildException("<export> requires either attribute \"file\" or the import as body content to be set.");
            }
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (!reg.exists()) {
                reg.create();
            }
            try {
                Document doc = this.file != null ? builder.parse(this.file) : builder.parse(new InputSource(new StringReader(this.text)));
                Element element = doc.getDocumentElement();
                this.importSubKey(element, reg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Import into " + reg + " failed.", (Throwable)ex);
            }
        }

        void importSubKey(Element element, Registry reg) {
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element e = (Element)nl.item(i);
                if (e.getTagName().equals("subkey")) {
                    Registry r = new Registry(reg, e.getAttribute("name"));
                    if (!r.exists()) {
                        r.create();
                    }
                    this.importSubKey(e, r);
                    continue;
                }
                reg.setValue(e.getAttribute("name"), (Object)e.getAttribute("value"));
            }
        }
    }

    public class Export
    implements Runnable {
        File file = null;
        String subKey = null;

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void setFile(File f) {
            this.file = f;
        }

        public void run() {
            if (this.file == null) {
                throw new BuildException("<export> requires attribute \"file\".");
            }
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (!reg.exists()) {
                throw new BuildException("Cannot export " + reg.toString() + " : key does not exist");
            }
            Document doc = builder.newDocument();
            Element root = doc.createElement("registry");
            doc.appendChild(root);
            root.setAttribute("root", Registry.getHKeyName((int)reg.getHKey()));
            root.setAttribute("key", reg.getSubKey());
            this.addSubKey(doc, root, reg);
            try {
                DOMSource source = new DOMSource(doc);
                FileOutputStream out = new FileOutputStream(this.file);
                StreamResult result = new StreamResult(out);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("indent", "yes");
                xformer.transform(source, result);
                out.close();
            }
            catch (Exception ex) {
                throw new BuildException("Export " + reg + " to file " + this.file + " failed.", (Throwable)ex);
            }
        }

        protected void addSubKey(Document doc, Element elm, Registry reg) {
            String name;
            Iterator iter = reg.valueNames();
            while (iter.hasNext()) {
                name = (String)iter.next();
                Element entry = doc.createElement("entry");
                entry.setAttribute("name", name);
                entry.setAttribute("type", Registry.getValueTypeName((int)reg.getValueType(name)));
                entry.setAttribute("value", reg.getValue(name).toString());
                elm.appendChild(entry);
            }
            iter = reg.subKeyNames();
            while (iter.hasNext()) {
                name = (String)iter.next();
                Element subKey = doc.createElement("subkey");
                elm.appendChild(subKey);
                subKey.setAttribute("name", name);
                this.addSubKey(doc, subKey, new Registry(reg, name));
            }
        }
    }

    public class Set
    implements Runnable {
        String entry = null;
        String value = null;
        String subKey = null;

        public void setEntry(String s) {
            this.entry = s;
        }

        public void setValue(String s) {
            this.value = s;
        }

        public void addText(String s) {
            if (this.value != null) {
                Win32RegistryTask.this.log("Cannot set <Put> value : <Put> value already set by attribute \"value\"", 1);
                return;
            }
            this.value = Win32RegistryTask.this.getProject().replaceProperties(s.trim());
        }

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void run() {
            if (this.entry == null) {
                throw new BuildException("<set> requires attribute \"entry\".");
            }
            if (this.value == null) {
                throw new BuildException("<set> requires attribute \"value\".");
            }
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (!reg.exists()) {
                reg.create();
            }
            reg.setValue(this.entry, (Object)this.value);
        }
    }

    public class Get
    implements Runnable {
        String property = null;
        String entry = null;
        String subKey = null;

        public void setProperty(String s) {
            this.property = s;
        }

        public void setEntry(String s) {
            this.entry = s;
        }

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void run() {
            if (this.property == null) {
                throw new BuildException("<get> requires attribute \"property\".");
            }
            if (this.entry == null) {
                throw new BuildException("<get> requires attribute \"entry\".");
            }
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (!reg.exists()) {
                Win32RegistryTask.this.log("Cannot get entry " + this.entry + " : " + reg.toString() + " does not exist", 1);
            }
            if (!reg.hasValue(this.entry)) {
                throw new BuildException("Cannot get entry " + this.entry + " : " + reg.toString() + " has no entry with this name");
            }
            Win32RegistryTask.this.getProject().setProperty(this.property, reg.getValue(this.entry).toString());
        }
    }

    public class Delete
    implements Runnable {
        String entry = null;
        String subKey = null;

        public void setEntry(String s) {
            this.entry = s;
        }

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void run() {
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (this.entry != null) {
                if (reg.exists() && reg.hasValue(this.entry)) {
                    System.out.println("Delete value " + this.entry + " in" + reg);
                    reg.deleteValue(this.entry);
                } else {
                    Win32RegistryTask.this.log("Cannot delete entry " + this.entry + " in " + reg + " : it does not exist", 1);
                }
            } else if (reg.exists()) {
                reg.delete();
            } else {
                Win32RegistryTask.this.log("Cannot delete " + reg + " : it does not exist", 1);
            }
        }
    }

    public class Exists
    implements Runnable {
        String property = null;
        String entry = null;
        String subKey = null;

        public void setProperty(String s) {
            this.property = s;
        }

        public void setEntry(String s) {
            this.entry = s;
        }

        public void setSubKey(String s) {
            this.subKey = s;
        }

        public void run() {
            if (this.property == null) {
                throw new BuildException("<exists> requires attribute \"property\".");
            }
            Registry reg = null;
            reg = this.subKey != null ? new Registry(Win32RegistryTask.this.reg, this.subKey) : Win32RegistryTask.this.reg;
            if (this.entry != null) {
                if (reg.exists() && reg.hasValue(this.entry)) {
                    Win32RegistryTask.this.getProject().setProperty(this.property, "true");
                }
            } else if (reg.exists()) {
                Win32RegistryTask.this.getProject().setProperty(this.property, "true");
            }
        }
    }
}

