/*
 * Decompiled with CFR 0.152.
 */
package com.orangevolt.tools.ant;

import com.orangevolt.tools.ant.JNLPTaskMember;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JNLPTask
extends Task
implements JNLPTaskMember {
    public static final String JNLP_DOWNLOAD_SERVLET = "JnlpDownloadServlet";
    private static final String NEW_LINE = "\r\n";
    private String codebase = null;
    private String encoding = "UTF-8";
    private String href = null;
    private List informations = new ArrayList();
    private String jnlpType = null;
    private List resources = new ArrayList();
    private Security security = null;
    private String spec = "1.0+";
    private File toFile = null;
    private String version = null;
    private XDesc xDesc = null;

    private static String correctHRefPath(String filePath) {
        return filePath.replace('\\', '/').replace(' ', '+');
    }

    private void appendTabs(StringBuffer sb, int depth) {
        while (depth-- > 0) {
            sb.append('\t');
        }
    }

    public AppletDesc createApplet_Desc() {
        if (this.xDesc != null) {
            throw new RuntimeException("<jnlp> : Only one of application-desc | applet-desc | component-desc | installer-desc expected");
        }
        this.xDesc = new AppletDesc();
        return (AppletDesc)this.xDesc;
    }

    public ApplicationDesc createApplication_Desc() {
        if (this.xDesc != null) {
            throw new RuntimeException("<jnlp> : Only one of application-desc | applet-desc | component-desc | installer-desc expected");
        }
        this.xDesc = new ApplicationDesc();
        return (ApplicationDesc)this.xDesc;
    }

    public ComponentDesc createComponent_Desc() {
        if (this.xDesc != null) {
            throw new RuntimeException("<jnlp> : Only one of application-desc | applet-desc | component-desc | installer-desc expected");
        }
        this.xDesc = new ComponentDesc();
        return (ComponentDesc)this.xDesc;
    }

    public Information createInformation() {
        Information information = new Information();
        this.informations.add(information);
        return information;
    }

    public InstallerDesc createInstaller_Desc() {
        if (this.xDesc != null) {
            throw new RuntimeException("<jnlp> : Only one of application-desc | applet-desc | component-desc | installer-desc expected");
        }
        this.xDesc = new InstallerDesc();
        return (InstallerDesc)this.xDesc;
    }

    public Resources createResources() {
        Resources _resources = new Resources();
        this.resources.add(_resources);
        return _resources;
    }

    public Security createSecurity() {
        this.security = new Security();
        return this.security;
    }

    public void execute() throws BuildException {
        try {
            if (this.toFile == null) {
                throw new BuildException("Attribute toFile undefined");
            }
            String s = this.toString();
            this.log(s, 2);
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(this.toFile));
                pw.print(s);
                pw.close();
            }
            catch (IOException ex) {
                throw new BuildException("Error writing created jnlp signature to " + this.toFile.getAbsolutePath(), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException((Throwable)ex);
        }
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setJnlpType(String jnlpType) {
        this.jnlpType = jnlpType;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setSpec(String string) {
        this.spec = string;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0);
        return sb.toString();
    }

    public void toString(StringBuffer sb, int depth) {
        int i;
        sb.append("<?xml version=\"1.0\" encoding=\"").append(this.encoding).append("\"?>").append(NEW_LINE);
        sb.append("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Discriptor 1.1//EN\" \"http://java.sun.com/dtd/JNLP-1.5.dtd\">").append(NEW_LINE);
        sb.append("<jnlp");
        if (this.spec != null) {
            sb.append(" spec=\"").append(this.spec).append("\"");
        }
        if (this.version != null) {
            sb.append(" version=\"").append(this.version).append("\"");
        }
        if (this.codebase != null) {
            sb.append(" codebase=\"").append(this.codebase).append("\"");
        }
        if (this.href != null) {
            sb.append(" href=\"").append(this.href).append("\"");
        }
        sb.append('>').append(NEW_LINE);
        if (this.informations.size() < 1) {
            throw new RuntimeException("<jnlp> : At least one information expected");
        }
        for (i = 0; i < this.informations.size(); ++i) {
            Information information = (Information)this.informations.get(i);
            information.toString(sb, 1);
        }
        if (this.security != null) {
            this.security.toString(sb, depth + 1);
        }
        for (i = 0; i < this.resources.size(); ++i) {
            Resources resources = (Resources)this.resources.get(i);
            resources.toString(sb, 1);
        }
        if (this.xDesc == null) {
            throw new RuntimeException("<jnlp> : Sub element missing ( application-desc | applet-desc | component-desc | installer-desc)");
        }
        this.xDesc.toString(sb, depth + 1);
        sb.append("</jnlp>").append(NEW_LINE);
    }

    public abstract class XDesc
    implements JNLPTaskMember {
    }

    public class Security
    implements JNLPTaskMember {
        private Permission permission = null;

        public Permission createAll_Permissions() {
            this.permission = new Permission("all-permissions");
            return this.permission;
        }

        public Permission createJ2ee_Application_Client_Permissions() {
            this.permission = new Permission("j2ee-application-client-permissions");
            return this.permission;
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<security>").append(JNLPTask.NEW_LINE);
            if (this.permission == null) {
                throw new RuntimeException("<security> requires either <all_permissions/> or <j2ee_application_client_permissions/> as child element.");
            }
            this.permission.toString(sb, depth + 1);
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</security>").append(JNLPTask.NEW_LINE);
        }

        public class Permission
        implements JNLPTaskMember {
            private String name = null;

            public Permission(String s) {
                this.name = s;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append('<').append(this.name).append("/>").append(JNLPTask.NEW_LINE);
            }
        }
    }

    public class Resources
    implements JNLPTaskMember {
        private String arch = null;
        private List extensions = new ArrayList();
        private List filesets = new ArrayList();
        private List j2ses = new ArrayList();
        private List jars = new ArrayList();
        private String locale = null;
        private List nativeLibs = new ArrayList();
        private String os = null;
        private List packages = new ArrayList();
        private List properties = new ArrayList();

        public void addFileset(FileSet fileset) {
            this.filesets.add(fileset);
        }

        public Extension createExtension() {
            Extension extension = new Extension();
            this.extensions.add(extension);
            return extension;
        }

        public J2SE createJ2SE() {
            J2SE j2se = new J2SE();
            this.j2ses.add(j2se);
            return j2se;
        }

        public Jar createJar() {
            Jar jar = new Jar();
            this.jars.add(jar);
            return jar;
        }

        public NativeLib createNativeLib() {
            NativeLib nativeLib = new NativeLib();
            this.nativeLibs.add(nativeLib);
            return nativeLib;
        }

        public Package createPackage() {
            Package _package = new Package();
            this.packages.add(_package);
            return _package;
        }

        public Property createProperty() {
            Property property = new Property();
            this.properties.add(property);
            return property;
        }

        private void expandFileset() {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.get(i);
                DirectoryScanner directoryscanner = fileSet.getDirectoryScanner(JNLPTask.this.getProject());
                String[] files = directoryscanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String string = files[j];
                    if (string.endsWith(".jar")) {
                        Jar jar = this.createJar();
                        jar.setFilename(string);
                        continue;
                    }
                    NativeLib nativeLib = this.createNativeLib();
                    nativeLib.setFilename(string);
                }
            }
        }

        public void setArch(String string) {
            this.arch = string;
        }

        public void setLocale(String string) {
            this.locale = string;
        }

        public void setOs(String string) {
            this.os = string;
        }

        public void toString(StringBuffer sb, int depth) {
            int i;
            this.expandFileset();
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<resources");
            if (this.os != null) {
                sb.append(" os=\"").append(this.os).append('\"');
            }
            if (this.arch != null) {
                sb.append(" arch=\"").append(this.arch).append('\"');
            }
            if (this.locale != null) {
                sb.append(" locale=\"").append(this.locale).append('\"');
            }
            sb.append('>').append(JNLPTask.NEW_LINE);
            for (i = 0; i < this.j2ses.size(); ++i) {
                J2SE j2se = (J2SE)this.j2ses.get(i);
                j2se.toString(sb, depth + 1);
            }
            for (i = 0; i < this.jars.size(); ++i) {
                Jar jar = (Jar)this.jars.get(i);
                jar.toString(sb, depth + 1);
            }
            for (i = 0; i < this.nativeLibs.size(); ++i) {
                NativeLib nativeLib = (NativeLib)this.nativeLibs.get(i);
                nativeLib.toString(sb, depth + 1);
            }
            for (i = 0; i < this.extensions.size(); ++i) {
                Extension extension = (Extension)this.extensions.get(i);
                extension.toString(sb, depth + 1);
            }
            for (i = 0; i < this.properties.size(); ++i) {
                Property property = (Property)this.properties.get(i);
                property.toString(sb, depth + 1);
            }
            for (i = 0; i < this.packages.size(); ++i) {
                Package _package = (Package)this.packages.get(i);
                _package.toString(sb, depth + 1);
            }
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</resources>").append(JNLPTask.NEW_LINE);
        }

        public class Property
        implements JNLPTaskMember {
            private String name = null;
            private String value = null;

            public void setName(String string) {
                this.name = string;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<property");
                if (this.name == null) {
                    throw new RuntimeException("<property> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.value == null) {
                    throw new RuntimeException("<property> requires attribute value");
                }
                sb.append(" value=\"").append(this.value).append('\"');
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }

        public class Package
        implements JNLPTaskMember {
            private String name = null;
            private String part = null;
            private String recursive = null;

            public void setName(String string) {
                this.name = string;
            }

            public void setPart(String string) {
                this.part = string;
            }

            public void setRecursive(String string) {
                this.recursive = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<package");
                if (this.name == null) {
                    throw new RuntimeException("<package> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.part == null) {
                    throw new RuntimeException("<package> requires attribute part");
                }
                sb.append(" part=\"").append(this.part).append('\"');
                if (this.recursive != null) {
                    sb.append(" recursive=\"").append(this.recursive).append('\"');
                }
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }

        public class NativeLib
        extends FileResource
        implements JNLPTaskMember {
            public void toString(StringBuffer sb, int depth) {
                this.validate();
                if (this.href != null) {
                    this.writeNativeLib(sb, depth);
                }
                Iterator iterator = this.filesets.iterator();
                while (iterator.hasNext()) {
                    FileSet fileSet = (FileSet)iterator.next();
                    DirectoryScanner directoryscanner = fileSet.getDirectoryScanner(JNLPTask.this.getProject());
                    String[] files = directoryscanner.getIncludedFiles();
                    for (int j = 0; j < files.length; ++j) {
                        NativeLib tempNativeLib = new NativeLib();
                        if (this.arch != null) {
                            tempNativeLib.setArch(this.arch);
                        }
                        if (this.download != null) {
                            tempNativeLib.setDownload(this.download);
                        }
                        if (this.locale != null) {
                            tempNativeLib.setLocale(this.locale);
                        }
                        if (this.os != null) {
                            tempNativeLib.setOs(this.os);
                        }
                        if (this.part != null) {
                            tempNativeLib.setPart(this.part);
                        }
                        if (this.size != null) {
                            tempNativeLib.setSize(this.size);
                        }
                        if (this.version != null) {
                            tempNativeLib.setVersion(this.version);
                        }
                        if (this.href != null) {
                            tempNativeLib.setHref(this.href);
                        }
                        tempNativeLib.setFilename(files[j]);
                        tempNativeLib.toString(sb, depth);
                    }
                }
            }

            public void writeNativeLib(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<nativelib");
                if (this.href == null) {
                    throw new RuntimeException("<nativelib> requires attribute href");
                }
                sb.append(" href=\"").append(JNLPTask.correctHRefPath(this.href)).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.os != null) {
                    sb.append(" os=\"").append(this.os).append('\"');
                }
                if (this.arch != null) {
                    sb.append(" arch=\"").append(this.arch).append('\"');
                }
                if (this.locale != null) {
                    sb.append(" locale=\"").append(this.locale).append('\"');
                }
                if (this.download != null) {
                    sb.append(" download=\"").append(this.download).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                if (this.part != null) {
                    sb.append(" part=\"").append(this.part).append('\"');
                }
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }

        public class Jar
        extends FileResource
        implements JNLPTaskMember {
            private Boolean main;

            public Jar() {
                this.main = null;
            }

            private boolean isMain() {
                return this.main == null ? false : this.main.equals(Boolean.TRUE.toString());
            }

            public void setMain(Boolean main) {
                this.main = main;
            }

            public void toString(StringBuffer sb, int depth) {
                this.validate();
                if (this.href != null) {
                    this.writeJar(sb, depth);
                }
                Iterator iterator = this.filesets.iterator();
                while (iterator.hasNext()) {
                    FileSet fileSet = (FileSet)iterator.next();
                    DirectoryScanner directoryscanner = fileSet.getDirectoryScanner(JNLPTask.this.getProject());
                    String[] files = directoryscanner.getIncludedFiles();
                    for (int j = 0; j < files.length; ++j) {
                        Jar tempJar = new Jar();
                        if (this.arch != null) {
                            tempJar.setArch(this.arch);
                        }
                        if (this.download != null) {
                            tempJar.setDownload(this.download);
                        }
                        if (this.locale != null) {
                            tempJar.setLocale(this.locale);
                        }
                        if (this.main != null) {
                            tempJar.setMain(this.main);
                        }
                        if (this.os != null) {
                            tempJar.setOs(this.os);
                        }
                        if (this.part != null) {
                            tempJar.setPart(this.part);
                        }
                        if (this.size != null) {
                            tempJar.setSize(this.size);
                        }
                        if (this.version != null) {
                            tempJar.setVersion(this.version);
                        }
                        if (this.href != null) {
                            tempJar.setHref(this.href);
                        }
                        tempJar.setFilename(files[j]);
                        tempJar.toString(sb, depth);
                    }
                }
            }

            protected void validate() {
                try {
                    super.validate();
                }
                catch (BuildException ex) {
                    throw new BuildException("<jar>" + ex.getMessage());
                }
                if (this.getFilesCount() > 1 && this.isMain()) {
                    throw new BuildException("<jar> with more than one jar-archive and main=\"true\" make no sense");
                }
            }

            private void writeJar(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<jar");
                if (this.href == null) {
                    throw new RuntimeException("<jar> requires attribute href");
                }
                sb.append(" href=\"").append(JNLPTask.correctHRefPath(this.href)).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.os != null) {
                    sb.append(" os=\"").append(this.os).append('\"');
                }
                if (this.arch != null) {
                    sb.append(" arch=\"").append(this.arch).append('\"');
                }
                if (this.locale != null) {
                    sb.append(" locale=\"").append(this.locale).append('\"');
                }
                if (this.main != null) {
                    sb.append(" main=\"").append(this.main.toString()).append('\"');
                }
                if (this.download != null) {
                    sb.append(" download=\"").append(this.download).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                if (this.part != null) {
                    sb.append(" part=\"").append(this.part).append('\"');
                }
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }

        public class J2SE
        implements JNLPTaskMember {
            private String href = null;
            private String initialHeapSize = null;
            private String maxHeapSize = null;
            private List resources = new ArrayList();
            private String version = null;

            public Resources createResources() {
                Resources _resources = new Resources();
                this.resources.add(_resources);
                return _resources;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setInitial_Heap_Size(String string) {
                this.initialHeapSize = string;
            }

            public void setMax_Heap_Size(String string) {
                this.maxHeapSize = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<j2se");
                if (this.version == null) {
                    throw new RuntimeException("<j2se> requires attribute version");
                }
                sb.append(" version=\"").append(this.version).append('\"');
                if (this.href != null) {
                    sb.append(" href=\"").append(this.href).append('\"');
                }
                if (this.initialHeapSize != null) {
                    sb.append(" initial-heap-size=\"").append(this.initialHeapSize).append('\"');
                }
                if (this.maxHeapSize != null) {
                    sb.append(" max-heap-size=\"").append(this.maxHeapSize).append('\"');
                }
                if (this.resources.size() == 0) {
                    sb.append("/>").append(JNLPTask.NEW_LINE);
                } else {
                    sb.append('>').append(JNLPTask.NEW_LINE);
                }
                for (int i = 0; i < this.resources.size(); ++i) {
                    Resources resources = (Resources)this.resources.get(i);
                    resources.toString(sb, depth + 1);
                }
                if (this.resources.size() > 0) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("</j2se>").append(JNLPTask.NEW_LINE);
                }
            }
        }

        public class FileResource {
            protected String arch = null;
            protected String download = null;
            protected final String[] FILE_EXTENTIONS = new String[]{".jar", ".so", ".dll"};
            protected List filesets = new ArrayList();
            protected String href = null;
            protected String locale = null;
            protected String os = null;
            protected String part = null;
            protected String size = null;
            protected String version = null;

            public void addFileset(FileSet fileset) {
                this.filesets.add(fileset);
            }

            public int getFilesCount() {
                int result = this.href != null ? 1 : 0;
                for (int i = 0; i < this.filesets.size(); ++i) {
                    FileSet fileset = (FileSet)this.filesets.get(i);
                    result += fileset.getDirectoryScanner(JNLPTask.this.getProject()).getIncludedFilesCount();
                }
                return result;
            }

            public void setArch(String arch) {
                if (this.arch != null) {
                    throw new BuildException("arch was previously set, aborting!");
                }
                this.arch = arch;
            }

            public void setDownload(String string) {
                this.download = string;
            }

            public void setFilename(String filename) {
                if (JNLPTask.this.jnlpType != null && JNLPTask.this.jnlpType.equals(JNLPTask.JNLP_DOWNLOAD_SERVLET)) {
                    String[] nameparts = filename.split("__");
                    String lHref = nameparts[0];
                    String lLocale = null;
                    String lArch = null;
                    String lOs = null;
                    block6: for (int i = 1; i < nameparts.length; ++i) {
                        if (i == nameparts.length - 1) {
                            for (int j = 0; j < this.FILE_EXTENTIONS.length; ++j) {
                                String fileExtention = this.FILE_EXTENTIONS[j];
                                if (!nameparts[i].endsWith(fileExtention)) continue;
                                lHref = lHref + fileExtention;
                                nameparts[i] = nameparts[i].substring(0, nameparts[i].length() - fileExtention.length());
                            }
                        }
                        switch (nameparts[i].charAt(0)) {
                            case 'V': {
                                this.setVersion(nameparts[i].substring(1));
                                continue block6;
                            }
                            case 'A': {
                                lArch = (lArch != null ? lArch + "," : "") + nameparts[i].substring(1);
                                continue block6;
                            }
                            case 'O': {
                                lOs = (lOs != null ? lOs + "," : "") + nameparts[i].substring(1);
                                continue block6;
                            }
                            case 'L': {
                                lLocale = (lLocale != null ? lLocale + "," : "") + nameparts[i].substring(1);
                            }
                        }
                    }
                    if (lArch != null) {
                        this.setArch(lArch);
                    }
                    if (lLocale != null) {
                        this.setLocale(lLocale);
                    }
                    if (lOs != null) {
                        this.setOs(lOs);
                    }
                    this.setHref(lHref);
                } else {
                    this.setHref(filename);
                }
            }

            public void setHref(String href) {
                if (this.href != null) {
                    throw new BuildException("href was previously set, aborting!");
                }
                this.href = href;
            }

            public void setLocale(String locale) {
                if (this.locale != null) {
                    throw new BuildException("locale  was previously set, aborting!");
                }
                this.locale = locale;
            }

            public void setOs(String os) {
                if (this.os != null) {
                    throw new BuildException("os was previously set, aborting!");
                }
                this.os = os;
            }

            public void setPart(String string) {
                this.part = string;
            }

            public void setSize(String string) {
                this.size = string;
            }

            public void setVersion(String string) {
                if (this.version != null) {
                    throw new BuildException("version was previously set, aborting!");
                }
                this.version = string;
            }

            protected void validate() {
                if (this.getFilesCount() == 0) {
                    throw new BuildException("requires href or filename if no fileset is specified");
                }
            }
        }

        public class Extension
        implements JNLPTaskMember {
            private List extDownloads = new ArrayList();
            private String href = null;
            private String name = null;
            private String version = null;

            public ExtDownload createExtDownload() {
                ExtDownload extDownload = new ExtDownload();
                this.extDownloads.add(this.extDownloads);
                return extDownload;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setName(String string) {
                this.name = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<extension");
                if (this.href == null) {
                    throw new RuntimeException("<extension> requires attribute href");
                }
                sb.append(" href=\"").append(this.href).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.name != null) {
                    sb.append(" name=\"").append(this.name).append('\"');
                }
                if (this.extDownloads.size() > 0) {
                    sb.append('>').append(JNLPTask.NEW_LINE);
                } else {
                    sb.append("/>").append(JNLPTask.NEW_LINE);
                }
                for (int i = 0; i < this.extDownloads.size(); ++i) {
                    ExtDownload extDownload = (ExtDownload)this.extDownloads.get(i);
                    extDownload.toString(sb, depth + 1);
                }
                if (this.extDownloads.size() > 0) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("</extension>").append(JNLPTask.NEW_LINE);
                }
            }

            public class ExtDownload
            implements JNLPTaskMember {
                String extPart = null;
                String download = null;
                String part = null;

                public void setDownload(String string) {
                    this.download = string;
                }

                public void setExt_Part(String string) {
                    this.extPart = string;
                }

                public void setPart(String string) {
                    this.part = string;
                }

                public void toString(StringBuffer sb, int depth) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<ext-download");
                    if (this.extPart == null) {
                        throw new RuntimeException("<ext-download> requires attribute ext-part");
                    }
                    sb.append(" ext-part=\"").append(this.extPart).append('\"');
                    if (this.download != null) {
                        sb.append(" download=\"").append(this.download).append('\"');
                    }
                    if (this.part != null) {
                        sb.append(" part=\"").append(this.part).append('\"');
                    }
                    sb.append("/>").append(JNLPTask.NEW_LINE);
                }
            }
        }
    }

    public static class InstallScript {
        private File name = null;

        public boolean isUnixShell() {
            return this.name.getName().endsWith(".sh");
        }

        public boolean isWinShell() {
            return this.name.getName().endsWith(".bat") || this.name.getName().endsWith(".cmd");
        }

        public void setName(File name) {
            this.name = name;
        }
    }

    public class InstallerDesc
    extends XDesc {
        private String mainClass = null;

        public void setMain_Class(String string) {
            this.mainClass = string;
        }

        public void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<installer-desc");
            if (this.mainClass == null) {
                throw new RuntimeException("<installer_desc> requires attribute main_class");
            }
            sb.append(" main-class=\"").append(this.mainClass).append('\"');
            sb.append("</installer-desc>").append(JNLPTask.NEW_LINE);
        }
    }

    public class Information
    implements JNLPTaskMember {
        private List descriptions = new ArrayList();
        private Homepage homepage = new Homepage();
        private List icons = new ArrayList();
        private String locale = null;
        private Boolean offlineAllowed = null;
        private Shortcut shortcut = null;
        private Title title = new Title();
        private Vendor vendor = new Vendor();

        public Description createDescription() {
            Description description = new Description();
            this.descriptions.add(description);
            return description;
        }

        public Homepage createHomepage() {
            return this.homepage;
        }

        public Icon createIcon() {
            Icon icon = new Icon();
            this.icons.add(icon);
            return icon;
        }

        public Boolean createOffline_Allowed() {
            this.offlineAllowed = Boolean.TRUE;
            return this.offlineAllowed;
        }

        public Shortcut createShortcut() {
            this.shortcut = new Shortcut();
            return this.shortcut;
        }

        public Title createTitle() {
            return this.title;
        }

        public Vendor createVendor() {
            return this.vendor;
        }

        public void setHomepage(Homepage homepage) {
            this.homepage = homepage;
        }

        public void setLocale(String string) {
            this.locale = string;
        }

        public void setOfflineAllowed(Boolean offlineAllowed) {
            this.offlineAllowed = offlineAllowed;
        }

        public void setShortcut(Shortcut shortcut) {
            this.shortcut = shortcut;
        }

        public void setTitle(Title title) {
            this.title = title;
        }

        public void setVendor(Vendor vendor) {
            this.vendor = vendor;
        }

        public void toString(StringBuffer sb, int depth) {
            int i;
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<information");
            if (this.locale != null) {
                sb.append(" locale=\"").append(this.locale).append('\"');
            }
            sb.append('>').append(JNLPTask.NEW_LINE);
            this.title.toString(sb, depth + 1);
            this.vendor.toString(sb, depth + 1);
            this.homepage.toString(sb, depth + 1);
            for (i = 0; i < this.descriptions.size(); ++i) {
                Description description = (Description)this.descriptions.get(i);
                description.toString(sb, depth + 1);
            }
            for (i = 0; i < this.icons.size(); ++i) {
                Icon icon = (Icon)this.icons.get(i);
                icon.toString(sb, depth + 1);
            }
            if (this.offlineAllowed != null && this.offlineAllowed.booleanValue()) {
                JNLPTask.this.appendTabs(sb, depth + 1);
                sb.append("<offline-allowed/>").append(JNLPTask.NEW_LINE);
            }
            if (this.shortcut != null) {
                this.shortcut.toString(sb, depth + 1);
            }
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</information>").append(JNLPTask.NEW_LINE);
        }

        public class Vendor {
            private String vendor = null;

            public void addText(String s) {
                this.vendor = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.vendor != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<vendor>").append(this.vendor).append("</vendor>").append(JNLPTask.NEW_LINE);
                }
            }
        }

        public class Title
        implements JNLPTaskMember {
            private String title = null;

            public void addText(String s) {
                this.title = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.title != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<title>").append(this.title).append("</title>").append(JNLPTask.NEW_LINE);
                }
            }
        }

        public class Shortcut
        implements JNLPTaskMember {
            private Desktop desktop = null;
            private Menu menu = null;
            private String online = "true";

            public Desktop createDesktop() {
                this.desktop = new Desktop();
                return this.desktop;
            }

            public Menu createMenu() {
                this.menu = new Menu();
                return this.menu;
            }

            public void setOnline(String online) {
                if (online == null) {
                    online = "true";
                }
                this.online = online;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<shortcut");
                sb.append(" online=\"").append(this.online).append("\">").append(JNLPTask.NEW_LINE);
                if (this.desktop != null) {
                    this.desktop.toString(sb, depth + 1);
                }
                if (this.menu != null) {
                    this.menu.toString(sb, depth + 1);
                }
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("</shortcut>").append(JNLPTask.NEW_LINE);
            }

            public class Menu
            implements JNLPTaskMember {
                private String submenu = null;

                public void setSubmenu(String submenu) {
                    this.submenu = submenu;
                }

                public void toString(StringBuffer sb, int depth) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<menu submenu=\"").append(this.submenu).append("\"/>").append(JNLPTask.NEW_LINE);
                }
            }

            public class Desktop
            implements JNLPTaskMember {
                public void toString(StringBuffer sb, int depth) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<desktop/>").append(JNLPTask.NEW_LINE);
                }
            }
        }

        public class Icon
        implements JNLPTaskMember {
            private String depth = null;
            private String height = null;
            private String href = null;
            private String kind = null;
            private String size = null;
            private String version = null;
            private String width = null;

            public void setDepth(String depth) {
                this.depth = depth;
            }

            public void setHeight(String string) {
                this.height = string;
            }

            public void setHref(String s) {
                this.href = s;
            }

            public void setKind(String s) {
                this.kind = s;
            }

            public void setSize(String string) {
                this.size = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }

            public void setWidth(String string) {
                this.width = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<icon");
                if (this.href != null) {
                    sb.append(" href=\"").append(this.href).append('\"');
                }
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.width != null) {
                    sb.append(" width=\"").append(this.width).append('\"');
                }
                if (this.height != null) {
                    sb.append(" height=\"").append(this.height).append('\"');
                }
                if (this.kind != null) {
                    sb.append(" kind=\"").append(this.kind).append('\"');
                }
                if (this.depth != null) {
                    sb.append(" depth=\"").append(this.depth).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }

        public class Homepage
        implements JNLPTaskMember {
            private String href = null;

            public void setHref(String string) {
                this.href = string;
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.href != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<homepage href=\"").append(this.href).append("\"/>").append(JNLPTask.NEW_LINE);
                }
            }
        }

        public class Description
        implements JNLPTaskMember {
            private String kind = null;
            private String text = "";

            public void addText(String s) {
                this.text = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void setKind(String string) {
                this.kind = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<description");
                if (this.kind != null) {
                    sb.append(" kind=\"").append(this.kind).append('\"');
                }
                sb.append('>');
                sb.append(this.text);
                sb.append("</description>").append(JNLPTask.NEW_LINE);
            }
        }
    }

    public class ComponentDesc
    extends XDesc {
        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<component-desc/>").append(JNLPTask.NEW_LINE);
        }
    }

    public class ApplicationDesc
    extends XDesc {
        private List arguments = new ArrayList();
        private String mainClass = null;

        public Argument createArgument() {
            Argument argument = new Argument();
            this.arguments.add(argument);
            return argument;
        }

        public void setMain_Class(String string) {
            this.mainClass = string;
        }

        public void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<application-desc");
            if (this.mainClass != null) {
                sb.append(" main-class=\"").append(this.mainClass).append('\"');
            }
            if (this.arguments.size() == 0) {
                sb.append("/>").append(JNLPTask.NEW_LINE);
            } else {
                sb.append('>').append(JNLPTask.NEW_LINE);
            }
            for (int i = 0; i < this.arguments.size(); ++i) {
                Argument arg = (Argument)this.arguments.get(i);
                arg.toString(sb, depth + 1);
            }
            if (this.arguments.size() > 0) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("</application-desc>").append(JNLPTask.NEW_LINE);
            }
        }

        public class Argument
        implements JNLPTaskMember {
            private String text = null;

            public void addText(String s) {
                this.text = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<argument>");
                if (this.text == null) {
                    throw new RuntimeException("<argument> requires #pcdata content");
                }
                sb.append(this.text);
                sb.append("</argument>").append(JNLPTask.NEW_LINE);
            }
        }
    }

    public class AppletDesc
    extends XDesc {
        String documentBase = null;
        String mainClass = null;
        String name = null;
        String width = null;
        String height = null;
        ArrayList params = new ArrayList();

        public Param createArgument() {
            Param param = new Param();
            this.params.add(param);
            return param;
        }

        public void setDocumentBase(String string) {
            this.documentBase = string;
        }

        public void setHeight(String string) {
            this.height = string;
        }

        public void setMainClass(String string) {
            this.mainClass = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setWidth(String string) {
            this.width = string;
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<applet-desc");
            if (this.name == null) {
                throw new RuntimeException("<applet_desc> requires attribute name");
            }
            sb.append(" name=\"").append(this.name).append('\"');
            if (this.mainClass == null) {
                throw new RuntimeException("<applet_desc> requires attribute main_class");
            }
            sb.append(" mainClass=\"").append(this.mainClass).append('\"');
            if (this.width == null) {
                throw new RuntimeException("<applet_desc> requires attribute width");
            }
            sb.append(" width=\"").append(this.width).append('\"');
            if (this.height == null) {
                throw new RuntimeException("<applet_desc> requires attribute height");
            }
            sb.append(" height=\"").append(this.height).append('\"');
            if (this.documentBase != null) {
                sb.append(" documentbase=\"").append(this.documentBase).append('\"');
            }
            if (this.params.size() == 0) {
                sb.append("\">").append(JNLPTask.NEW_LINE);
            } else {
                sb.append('>').append(JNLPTask.NEW_LINE);
            }
            for (int i = 0; i < this.params.size(); ++i) {
                Param param = (Param)this.params.get(i);
                param.toString(sb, depth + 1);
            }
            if (this.params.size() > 0) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("</applet-desc>").append(JNLPTask.NEW_LINE);
            }
        }

        public class Param
        implements JNLPTaskMember {
            private String name = null;
            private String value = null;

            public void setName(String string) {
                this.name = string;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<param");
                if (this.name == null) {
                    throw new RuntimeException("<param> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.value == null) {
                    throw new RuntimeException("<param> requires attribute value");
                }
                sb.append(" value=\"").append(this.value).append('\"');
                sb.append("/>").append(JNLPTask.NEW_LINE);
            }
        }
    }
}

