/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesSupport;
import org.fife.ui.rsyntaxtextarea.ParserManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.RtfTransferable;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextArea
extends RTextArea
implements SyntaxConstants {
    public static final String ANIMATE_BRACKET_MATCHING_PROPERTY = "RSTA.animateBracketMatching";
    public static final String ANTIALIAS_PROPERTY = "RSTA.antiAlias";
    public static final String AUTO_INDENT_PROPERTY = "RSTA.autoIndent";
    public static final String BRACKET_MATCHING_PROPERTY = "RSTA.bracketMatching";
    public static final String CLEAR_WHITESPACE_LINES_PROPERTY = "RSTA.clearWhitespaceLines";
    public static final String CLOSE_CURLY_BRACES_PROPERTY = "RSTA.closeCurlyBraces";
    public static final String CLOSE_MARKUP_TAGS_PROPERTY = "RSTA.closeMarkupTags";
    public static final String EOL_VISIBLE_PROPERTY = "RSTA.eolMarkersVisible";
    public static final String FOCUSABLE_TIPS_PROPERTY = "RSTA.focusableTips";
    public static final String FRACTIONAL_FONTMETRICS_PROPERTY = "RSTA.fractionalFontMetrics";
    public static final String HYPERLINKS_ENABLED_PROPERTY = "RSTA.hyperlinksEnabled";
    public static final String MARK_OCCURRENCES_PROPERTY = "RSTA.markOccurrences";
    public static final String MARKED_OCCURRENCES_CHANGED_PROPERTY = "RSTA.markedOccurrencesChanged";
    public static final String PARSER_NOTICES_PROPERTY = "RSTA.parserNotices";
    public static final String SYNTAX_SCHEME_PROPERTY = "RSTA.syntaxScheme";
    public static final String SYNTAX_STYLE_PROPERTY = "RSTA.syntaxStyle";
    public static final String VISIBLE_WHITESPACE_PROPERTY = "RSTA.visibleWhitespace";
    private static final Color DEFAULT_BRACKET_MATCH_BG_COLOR = new Color(234, 234, 255);
    private static final Color DEFAULT_BRACKET_MATCH_BORDER_COLOR = new Color(0, 0, 128);
    private static final Color DEFAULT_SELECTION_COLOR = new Color(200, 200, 255);
    private String syntaxStyleKey;
    private SyntaxScheme syntaxScheme;
    private static CodeTemplateManager codeTemplateManager;
    private static boolean templatesEnabled;
    Rectangle match;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private int lastBracketMatchPos;
    private boolean bracketMatchingEnabled;
    private boolean animateBracketMatching;
    private BracketMatchingTimer bracketRepaintTimer;
    private boolean autoIndentEnabled;
    private boolean closeCurlyBraces;
    private boolean closeMarkupTags;
    private boolean clearWhitespaceLines;
    private boolean whitespaceVisible;
    private boolean eolMarkersVisible;
    private boolean hyperlinksEnabled;
    private Color hyperlinkFG;
    private int linkScanningMask;
    private RtfGenerator rtfGenerator;
    private MarkOccurrencesSupport markOccurrencesSupport;
    private Color markOccurrencesColor;
    private FontMetrics defaultFontMetrics;
    private ParserManager parserManager;
    private boolean isScanningForLinks;
    private int hoveredOverLinkOffset;
    private boolean useFocusableTips;
    private FocusableTip focusableTip;
    private int lineHeight;
    private int maxAscent;
    private String aaHintFieldName;
    private Object aaHint;
    private boolean fractionalFontMetricsEnabled;

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public RSyntaxTextArea() {
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument) {
        super(rSyntaxDocument);
        this.init();
    }

    public RSyntaxTextArea(String string) {
        super(string);
        this.init();
    }

    public RSyntaxTextArea(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public RSyntaxTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument, String string, int n, int n2) {
        super(rSyntaxDocument, string, n, n2);
        this.init();
    }

    public RSyntaxTextArea(int n) {
        super(n);
        this.init();
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(HyperlinkListener.class, hyperlinkListener);
    }

    public void addNotify() {
        super.addNotify();
        this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        if (this.parserManager != null) {
            this.parserManager.restartParsing();
        }
    }

    public void addParser(Parser parser) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.parserManager.addParser(parser);
    }

    private void calculateLineHeight() {
        int n;
        Object object;
        this.maxAscent = 0;
        this.lineHeight = 0;
        for (int i = 0; i < this.syntaxScheme.styles.length; ++i) {
            int n2;
            object = this.syntaxScheme.styles[i];
            if (object == null || ((Style)object).font == null) continue;
            FontMetrics fontMetrics = this.getFontMetrics(((Style)object).font);
            n = fontMetrics.getHeight();
            if (n > this.lineHeight) {
                this.lineHeight = n;
            }
            if ((n2 = fontMetrics.getMaxAscent()) <= this.maxAscent) continue;
            this.maxAscent = n2;
        }
        Font font = this.getFont();
        object = this.getFontMetrics(font);
        int n3 = ((FontMetrics)object).getHeight();
        if (n3 > this.lineHeight) {
            this.lineHeight = n3;
        }
        if ((n = ((FontMetrics)object).getMaxAscent()) > this.maxAscent) {
            this.maxAscent = n;
        }
    }

    public void clearParsers() {
        if (this.parserManager != null) {
            this.parserManager.clearParsers();
        }
    }

    private Token cloneTokenList(Token token) {
        if (token == null) {
            return null;
        }
        DefaultToken defaultToken = new DefaultToken();
        defaultToken.copyFrom(token);
        DefaultToken defaultToken2 = defaultToken;
        while ((token = token.getNextToken()) != null) {
            DefaultToken defaultToken3 = new DefaultToken();
            defaultToken3.copyFrom(token);
            defaultToken2.setNextToken(defaultToken3);
            defaultToken2 = defaultToken3;
        }
        return defaultToken;
    }

    public void copyAsRtf() {
        Object object;
        int n;
        int n2 = this.getSelectionStart();
        if (n2 == (n = this.getSelectionEnd())) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        RtfGenerator rtfGenerator = this.getRTFGenerator();
        Token token = this.getTokenListFor(n2, n);
        for (object = token; object != null; object = ((Token)object).getNextToken()) {
            if (!((Token)object).isPaintable()) continue;
            if (((Token)object).textCount == 1 && ((Token)object).text[((Token)object).textOffset] == '\n') {
                rtfGenerator.appendNewline();
                continue;
            }
            Font font = this.getFontForTokenType(((Token)object).type);
            Color color = this.getBackgroundForTokenType(((Token)object).type);
            boolean bl = this.getUnderlineForToken((Token)object);
            if (((Token)object).isWhitespace()) {
                rtfGenerator.appendToDocNoFG(((Token)object).getLexeme(), font, color, bl);
                continue;
            }
            Color color2 = this.getForegroundForToken((Token)object);
            rtfGenerator.appendToDoc(((Token)object).getLexeme(), font, color2, color, bl);
        }
        object = new RtfTransferable(rtfGenerator.getRtf().getBytes());
        try {
            clipboard.setContents((Transferable)object, null);
        }
        catch (IllegalStateException illegalStateException) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
    }

    protected Document createDefaultModel() {
        return new RSyntaxDocument("text/plain");
    }

    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RSyntaxTextAreaMutableCaretEvent((RTextArea)this);
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this);
    }

    protected final void doBracketMatching() {
        int n;
        if (this.match != null) {
            this.repaint(this.match);
        }
        if ((n = RSyntaxUtilities.getMatchingBracketPosition(this)) > -1 && n != this.lastBracketMatchPos) {
            try {
                this.match = this.modelToView(n);
                if (this.match != null) {
                    if (this.getAnimateBracketMatching()) {
                        this.bracketRepaintTimer.restart();
                    }
                    this.repaint(this.match);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else if (n == -1) {
            this.match = null;
            this.bracketRepaintTimer.stop();
        }
        this.lastBracketMatchPos = n;
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        super.fireCaretUpdate(caretEvent);
        if (this.isBracketMatchingEnabled()) {
            this.doBracketMatching();
        }
    }

    private void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$HyperlinkListener == null ? RSyntaxTextArea.class$("javax.swing.event.HyperlinkListener") : class$javax$swing$event$HyperlinkListener)) continue;
            ((HyperlinkListener)objectArray[i + 1]).hyperlinkUpdate(hyperlinkEvent);
        }
    }

    void fireMarkedOccurrencesChanged() {
        this.firePropertyChange(MARKED_OCCURRENCES_CHANGED_PROPERTY, null, null);
    }

    void fireParserNoticesChange() {
        this.firePropertyChange(PARSER_NOTICES_PROPERTY, null, null);
    }

    public void forceReparsing(int n) {
        this.parserManager.forceReparsing(n);
    }

    public boolean forceReparsing(Parser parser) {
        for (int i = 0; i < this.getParserCount(); ++i) {
            if (this.getParser(i) != parser) continue;
            this.forceReparsing(i);
            return true;
        }
        return false;
    }

    public boolean getAnimateBracketMatching() {
        return this.animateBracketMatching;
    }

    public Color getBackgroundForTokenType(int n) {
        return this.syntaxScheme.styles[n].background;
    }

    public boolean getCloseCurlyBraces() {
        return this.closeCurlyBraces;
    }

    public boolean getCloseMarkupTags() {
        return this.closeMarkupTags;
    }

    public static synchronized CodeTemplateManager getCodeTemplateManager() {
        if (codeTemplateManager == null) {
            codeTemplateManager = new CodeTemplateManager();
        }
        return codeTemplateManager;
    }

    public static final Color getDefaultBracketMatchBGColor() {
        return DEFAULT_BRACKET_MATCH_BG_COLOR;
    }

    public static final Color getDefaultBracketMatchBorderColor() {
        return DEFAULT_BRACKET_MATCH_BORDER_COLOR;
    }

    public static Color getDefaultSelectionColor() {
        return DEFAULT_SELECTION_COLOR;
    }

    public SyntaxScheme getDefaultSyntaxScheme() {
        return new SyntaxScheme(this.getFont());
    }

    public boolean getEOLMarkersVisible() {
        return this.eolMarkersVisible;
    }

    public Font getFontForTokenType(int n) {
        Font font = this.syntaxScheme.styles[n].font;
        return font != null ? font : this.getFont();
    }

    public FontMetrics getFontMetricsForTokenType(int n) {
        FontMetrics fontMetrics = this.syntaxScheme.styles[n].fontMetrics;
        return fontMetrics != null ? fontMetrics : this.defaultFontMetrics;
    }

    public Color getForegroundForToken(Token token) {
        if (this.getHyperlinksEnabled() && token.isHyperlink() && this.hoveredOverLinkOffset == token.offset) {
            return this.hyperlinkFG;
        }
        return this.getForegroundForTokenType(token.type);
    }

    public Color getForegroundForTokenType(int n) {
        Color color = this.syntaxScheme.styles[n].foreground;
        return color != null ? color : this.getForeground();
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    private final Graphics2D getGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.aaHint != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.aaHint);
        }
        if (this.fractionalFontMetricsEnabled) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return graphics2D;
    }

    public Color getHyperlinkForeground() {
        return this.hyperlinkFG;
    }

    public boolean getHyperlinksEnabled() {
        return this.hyperlinksEnabled;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public List getMarkedOccurrences() {
        return ((RSyntaxTextAreaHighlighter)this.getHighlighter()).getMarkedOccurrences();
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrencesSupport != null;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    boolean getMarkOccurrencesOfTokenType(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        return rSyntaxDocument.getMarkOccurrencesOfTokenType(n);
    }

    public Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    public final Rectangle getMatchRectangle() {
        return this.match;
    }

    public Parser getParser(int n) {
        return this.parserManager.getParser(n);
    }

    public int getParserCount() {
        return this.parserManager == null ? 0 : this.parserManager.getParserCount();
    }

    public List getParserNotices() {
        return this.parserManager == null ? new ArrayList(0) : this.parserManager.getParserNotices();
    }

    private RtfGenerator getRTFGenerator() {
        if (this.rtfGenerator == null) {
            this.rtfGenerator = new RtfGenerator();
        } else {
            this.rtfGenerator.reset();
        }
        return this.rtfGenerator;
    }

    public boolean getShouldIndentNextLine(int n) {
        if (this.isAutoIndentEnabled()) {
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            return rSyntaxDocument.getShouldIndentNextLine(n);
        }
        return false;
    }

    public String getSyntaxEditingStyle() {
        return this.syntaxStyleKey;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.syntaxScheme;
    }

    public static synchronized boolean getTemplatesEnabled() {
        return templatesEnabled;
    }

    public String getTextAntiAliasHint() {
        return this.aaHintFieldName;
    }

    private Token getTokenListFor(int n, int n2) {
        Token token;
        Token token2 = null;
        Token token3 = null;
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        for (int i = n3; i <= n4; ++i) {
            Token token4 = this.getTokenListForLine(i);
            token4 = this.cloneTokenList(token4);
            if (token2 == null) {
                token3 = token2 = token4;
            } else {
                token3.setNextToken(token4);
            }
            while (token3.getNextToken() != null && token3.getNextToken().isPaintable()) {
                token3 = token3.getNextToken();
            }
            if (i >= n4) continue;
            int n5 = element.getElement(i).getEndOffset() - 1;
            token4 = new DefaultToken(new char[]{'\n'}, 0, 0, n5, 16);
            token3.setNextToken(token4);
            token3 = token4;
        }
        if (n >= token2.offset) {
            while (!token2.containsPosition(n)) {
                token2 = token2.getNextToken();
            }
            token2.makeStartAt(n);
        }
        for (token = token2; token != null && !token.containsPosition(n2); token = token.getNextToken()) {
        }
        if (token != null) {
            token.textCount = n2 - token.offset;
            token.setNextToken(null);
        }
        return token2;
    }

    public Token getTokenListForLine(int n) {
        return ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        ToolTipInfo toolTipInfo;
        String string = null;
        URL uRL = null;
        if (this.parserManager != null && (toolTipInfo = this.parserManager.getToolTipText(mouseEvent)) != null) {
            string = toolTipInfo.getToolTipText();
            uRL = toolTipInfo.getImageBase();
        }
        if (string == null) {
            string = super.getToolTipText(mouseEvent);
        }
        if (this.getUseFocusableTips()) {
            if (string != null) {
                if (this.focusableTip == null) {
                    this.focusableTip = new FocusableTip(this, this.parserManager);
                }
                this.focusableTip.setImageBase(uRL);
                this.focusableTip.toolTipRequested(mouseEvent, string);
            } else if (this.focusableTip != null) {
                this.focusableTip.possiblyDisposeOfTipWindow();
            }
            return null;
        }
        return string;
    }

    public boolean getUnderlineForToken(Token token) {
        return token.isHyperlink() && this.getHyperlinksEnabled() || this.syntaxScheme.styles[token.type].underline;
    }

    public boolean getUseFocusableTips() {
        return this.useFocusableTips;
    }

    protected void init() {
        this.syntaxStyleKey = "text/plain";
        this.setMatchedBracketBGColor(RSyntaxTextArea.getDefaultBracketMatchBGColor());
        this.setMatchedBracketBorderColor(RSyntaxTextArea.getDefaultBracketMatchBorderColor());
        this.setBracketMatchingEnabled(true);
        this.setAnimateBracketMatching(true);
        this.lastBracketMatchPos = -1;
        this.setSelectionColor(RSyntaxTextArea.getDefaultSelectionColor());
        this.setAutoIndentEnabled(true);
        this.setCloseCurlyBraces(true);
        this.setCloseMarkupTags(true);
        this.setClearWhitespaceLinesEnabled(true);
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        this.setHyperlinkForeground(Color.BLUE);
        this.isScanningForLinks = false;
        this.setUseFocusableTips(true);
        this.restoreDefaultSyntaxScheme();
    }

    public boolean isAutoIndentEnabled() {
        return this.autoIndentEnabled;
    }

    public final boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isClearWhitespaceLinesEnabled() {
        return this.clearWhitespaceLines;
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    private Token modelToToken(int n) {
        if (n >= 0) {
            try {
                int n2 = this.getLineOfOffset(n);
                for (Token token = this.getTokenListForLine(n2); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (!token.containsPosition(n)) continue;
                    return token;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(this.getGraphics2D(graphics));
    }

    private void refreshFontMetrics(Graphics2D graphics2D) {
        this.defaultFontMetrics = graphics2D.getFontMetrics(this.getFont());
        this.syntaxScheme.refreshFontMetrics(graphics2D);
        if (!this.getLineWrap()) {
            SyntaxView syntaxView = (SyntaxView)this.getUI().getRootView(this).getView(0);
            syntaxView.calculateLongestLine();
        }
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(HyperlinkListener.class, hyperlinkListener);
    }

    public void removeNotify() {
        if (this.parserManager != null) {
            this.parserManager.stopParsing();
        }
        super.removeNotify();
    }

    public boolean removeParser(Parser parser) {
        boolean bl = false;
        if (this.parserManager != null) {
            bl = this.parserManager.removeParser(parser);
        }
        return bl;
    }

    public void restoreDefaultSyntaxScheme() {
        this.setSyntaxScheme(this.getDefaultSyntaxScheme());
    }

    public static synchronized boolean saveTemplates() {
        if (!RSyntaxTextArea.getTemplatesEnabled()) {
            return false;
        }
        return RSyntaxTextArea.getCodeTemplateManager().saveTemplates();
    }

    public void setAnimateBracketMatching(boolean bl) {
        if (bl != this.animateBracketMatching) {
            this.animateBracketMatching = bl;
            if (bl && this.bracketRepaintTimer == null) {
                this.bracketRepaintTimer = new BracketMatchingTimer();
            }
            this.firePropertyChange(ANIMATE_BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setAutoIndentEnabled(boolean bl) {
        if (this.autoIndentEnabled != bl) {
            this.autoIndentEnabled = bl;
            this.firePropertyChange(AUTO_INDENT_PROPERTY, !bl, bl);
        }
    }

    public void setBracketMatchingEnabled(boolean bl) {
        if (bl != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = bl;
            this.repaint();
            this.firePropertyChange(BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setClearWhitespaceLinesEnabled(boolean bl) {
        if (bl != this.clearWhitespaceLines) {
            this.clearWhitespaceLines = bl;
            this.firePropertyChange(CLEAR_WHITESPACE_LINES_PROPERTY, !bl, bl);
        }
    }

    public void setCloseCurlyBraces(boolean bl) {
        if (bl != this.closeCurlyBraces) {
            this.closeCurlyBraces = bl;
            this.firePropertyChange(CLOSE_CURLY_BRACES_PROPERTY, !bl, bl);
        }
    }

    public void setCloseMarkupTags(boolean bl) {
        if (bl != this.closeMarkupTags) {
            this.closeMarkupTags = bl;
            this.firePropertyChange(CLOSE_MARKUP_TAGS_PROPERTY, !bl, bl);
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof RSyntaxDocument)) {
            throw new IllegalArgumentException("Documents for RSyntaxTextArea must be instances of RSyntaxDocument!");
        }
        super.setDocument(document);
    }

    public void setEOLMarkersVisible(boolean bl) {
        if (bl != this.eolMarkersVisible) {
            this.eolMarkersVisible = bl;
            this.repaint();
            this.firePropertyChange(EOL_VISIBLE_PROPERTY, !bl, bl);
        }
    }

    public void setFont(Font font) {
        Font font2 = super.getFont();
        super.setFont(font);
        SyntaxScheme syntaxScheme = this.getSyntaxScheme();
        if (syntaxScheme != null && font2 != null) {
            syntaxScheme.changeBaseFont(font2, font);
            this.calculateLineHeight();
        }
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.updateMarginLineX();
            this.forceCurrentLineHighlightRepaint();
            this.firePropertyChange("font", font2, font);
            this.revalidate();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        if (this.fractionalFontMetricsEnabled != bl) {
            this.fractionalFontMetricsEnabled = bl;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(FRACTIONAL_FONTMETRICS_PROPERTY, !bl, bl);
        }
    }

    public void setHighlighter(Highlighter highlighter) {
        if (!(highlighter instanceof RSyntaxTextAreaHighlighter)) {
            throw new IllegalArgumentException("RSyntaxTextArea requires an RSyntaxTextAreaHighlighter for its Highlighter");
        }
        super.setHighlighter(highlighter);
    }

    public void setHyperlinkForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("fg cannot be null");
        }
        this.hyperlinkFG = color;
    }

    public void setHyperlinksEnabled(boolean bl) {
        if (this.hyperlinksEnabled != bl) {
            this.hyperlinksEnabled = bl;
            this.repaint();
            this.firePropertyChange(HYPERLINKS_ENABLED_PROPERTY, !bl, bl);
        }
    }

    public void setLinkScanningMask(int n) {
        if (n == 128 || n == 256 || n == 512 || n == 64) {
            this.linkScanningMask = n;
        }
    }

    public void setMarkOccurrences(boolean bl) {
        if (bl) {
            if (this.markOccurrencesSupport == null) {
                this.markOccurrencesSupport = new MarkOccurrencesSupport();
                this.markOccurrencesSupport.install(this);
                this.firePropertyChange(MARK_OCCURRENCES_PROPERTY, false, true);
            }
        } else if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.uninstall();
            this.markOccurrencesSupport = null;
            this.firePropertyChange(MARK_OCCURRENCES_PROPERTY, true, false);
        }
    }

    public void setMarkOccurrencesColor(Color color) {
        this.markOccurrencesColor = color;
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.setColor(color);
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        this.matchedBracketBGColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        this.matchedBracketBorderColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setSyntaxEditingStyle(String string) {
        if (string == null) {
            string = "text/plain";
        }
        if (!string.equals(this.syntaxStyleKey)) {
            String string2 = this.syntaxStyleKey;
            this.syntaxStyleKey = string;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(string);
            this.firePropertyChange(SYNTAX_STYLE_PROPERTY, string2, string);
        }
    }

    public void setSyntaxScheme(SyntaxScheme syntaxScheme) {
        SyntaxScheme syntaxScheme2 = this.syntaxScheme;
        this.syntaxScheme = syntaxScheme;
        this.calculateLineHeight();
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.updateMarginLineX();
        this.forceCurrentLineHighlightRepaint();
        this.revalidate();
        this.firePropertyChange(SYNTAX_SCHEME_PROPERTY, syntaxScheme2, this.syntaxScheme);
    }

    public static synchronized boolean setTemplateDirectory(String string) {
        if (RSyntaxTextArea.getTemplatesEnabled() && string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
            boolean bl = file.mkdir();
            if (bl) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
        }
        return false;
    }

    public static synchronized void setTemplatesEnabled(boolean bl) {
        templatesEnabled = bl;
    }

    public void setTextAntiAliasHint(String string) {
        if (string == null && this.aaHintFieldName != null) {
            String string2 = this.aaHintFieldName;
            this.aaHint = null;
            this.aaHintFieldName = null;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string2, null);
            this.repaint();
        } else if (string != null && !string.equals(this.aaHintFieldName)) {
            String string3 = this.aaHintFieldName;
            try {
                Field field = RenderingHints.class.getField(string);
                this.aaHint = field.get(null);
                this.aaHintFieldName = string;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception exception) {
                this.aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                this.aaHintFieldName = "VALUE_TEXT_ANTIALIAS_OFF";
            }
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string3, this.aaHintFieldName);
            this.repaint();
        }
    }

    public void setUseFocusableTips(boolean bl) {
        if (bl != this.useFocusableTips) {
            this.useFocusableTips = bl;
            this.firePropertyChange(FOCUSABLE_TIPS_PROPERTY, !bl, bl);
        }
    }

    public void setWhitespaceVisible(boolean bl) {
        if (this.whitespaceVisible != bl) {
            this.whitespaceVisible = bl;
            ((RSyntaxDocument)this.getDocument()).setWhitespaceVisible(bl, this);
            this.repaint();
            this.firePropertyChange(VISIBLE_WHITESPACE_PROPERTY, !bl, bl);
        }
    }

    private Token viewToToken(Point point) {
        return this.modelToToken(this.viewToModel(point));
    }

    private class RSyntaxTextAreaMutableCaretEvent
    extends RTextArea.RTextAreaMutableCaretEvent {
        protected RSyntaxTextAreaMutableCaretEvent(RTextArea rTextArea) {
            super(RSyntaxTextArea.this, rTextArea);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (RSyntaxTextArea.this.getHyperlinksEnabled() && RSyntaxTextArea.this.isScanningForLinks && RSyntaxTextArea.this.hoveredOverLinkOffset > -1) {
                Object object;
                Token token = RSyntaxTextArea.this.modelToToken(RSyntaxTextArea.this.hoveredOverLinkOffset);
                URL uRL = null;
                String string = null;
                try {
                    object = token.getLexeme();
                    if (((String)object).startsWith("www.")) {
                        object = "http://" + (String)object;
                    }
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    string = malformedURLException.getMessage();
                }
                object = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
                RSyntaxTextArea.this.fireHyperlinkUpdate((HyperlinkEvent)object);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (RSyntaxTextArea.this.getHyperlinksEnabled()) {
                if ((mouseEvent.getModifiersEx() & RSyntaxTextArea.this.linkScanningMask) != 0) {
                    RSyntaxTextArea.this.isScanningForLinks = true;
                    Token token = RSyntaxTextArea.this.viewToToken(mouseEvent.getPoint());
                    Cursor cursor = null;
                    if (token != null && token.isHyperlink()) {
                        RSyntaxTextArea.this.hoveredOverLinkOffset = token.offset;
                        cursor = Cursor.getPredefinedCursor(12);
                    } else {
                        cursor = Cursor.getPredefinedCursor(2);
                        RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    }
                    if (RSyntaxTextArea.this.getCursor() != cursor) {
                        RSyntaxTextArea.this.setCursor(cursor);
                        RSyntaxTextArea.this.repaint();
                    }
                } else if (RSyntaxTextArea.this.isScanningForLinks) {
                    Cursor cursor = RSyntaxTextArea.this.getCursor();
                    RSyntaxTextArea.this.isScanningForLinks = false;
                    RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    if (cursor != null && cursor.getType() == 12) {
                        RSyntaxTextArea.this.setCursor(Cursor.getPredefinedCursor(2));
                        RSyntaxTextArea.this.repaint();
                    }
                }
            }
        }
    }

    private class BracketMatchingTimer
    extends Timer
    implements ActionListener {
        private int pulseCount;

        public BracketMatchingTimer() {
            super(20, null);
            this.addActionListener(this);
            this.setCoalesce(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RSyntaxTextArea.this.isBracketMatchingEnabled() && RSyntaxTextArea.this.match != null) {
                if (this.pulseCount < 5) {
                    ++this.pulseCount;
                    --RSyntaxTextArea.this.match.x;
                    --RSyntaxTextArea.this.match.y;
                    RSyntaxTextArea.this.match.width += 2;
                    RSyntaxTextArea.this.match.height += 2;
                    RSyntaxTextArea.this.repaint(RSyntaxTextArea.this.match.x, RSyntaxTextArea.this.match.y, RSyntaxTextArea.this.match.width, RSyntaxTextArea.this.match.height);
                } else if (this.pulseCount < 7) {
                    ++this.pulseCount;
                    ++RSyntaxTextArea.this.match.x;
                    ++RSyntaxTextArea.this.match.y;
                    RSyntaxTextArea.this.match.width -= 2;
                    RSyntaxTextArea.this.match.height -= 2;
                    RSyntaxTextArea.this.repaint(RSyntaxTextArea.this.match.x - 2, RSyntaxTextArea.this.match.y - 2, RSyntaxTextArea.this.match.width + 5, RSyntaxTextArea.this.match.height + 5);
                } else {
                    this.stop();
                    this.pulseCount = 0;
                }
            }
        }

        public void start() {
            RSyntaxTextArea.this.match.x += 3;
            RSyntaxTextArea.this.match.y += 3;
            RSyntaxTextArea.this.match.width -= 6;
            RSyntaxTextArea.this.match.height -= 6;
            this.pulseCount = 0;
            super.start();
        }
    }
}

