/*
 * Decompiled with CFR 0.152.
 */
package com.sun.phobos.script.javascript;

import com.sun.phobos.script.javascript.RhinoScriptEngine;
import com.sun.phobos.script.util.ScriptEngineFactoryBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;

public class RhinoScriptEngineFactory
extends ScriptEngineFactoryBase {
    public static final String USE_INTERPRETER_SYSTEM_PROPERTY = "com.sun.phobos.javascript.useInterpreter";
    private Properties properties;
    private boolean initialized;
    private ContextFactory.Listener listener;
    private static List<String> names = new ArrayList<String>(7);
    private static List<String> mimeTypes;
    private static List<String> extensions;

    static {
        names.add("rhino-nonjdk");
        names.add("js");
        names.add("rhino");
        names.add("JavaScript");
        names.add("javascript");
        names.add("ECMAScript");
        names.add("ecmascript");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(4);
        mimeTypes.add("application/javascript");
        mimeTypes.add("application/ecmascript");
        mimeTypes.add("text/javascript");
        mimeTypes.add("text/ecmascript");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        extensions = new ArrayList<String>(1);
        extensions.add("js");
        extensions = Collections.unmodifiableList(extensions);
    }

    public RhinoScriptEngineFactory() {
    }

    public RhinoScriptEngineFactory(ContextFactory.Listener listener) {
        this.listener = listener;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return "javascript";
        }
        if (key.equals("javax.script.engine")) {
            return "Mozilla Rhino";
        }
        if (key.equals("javax.script.engine_version")) {
            return "1.6R7";
        }
        if (key.equals("javax.script.language")) {
            return "ECMAScript";
        }
        if (key.equals("javax.script.language_version")) {
            return "1.6";
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        RhinoScriptEngine ret = new RhinoScriptEngine();
        ret.setEngineFactory(this);
        return ret;
    }

    public void initialize() {
        if (!this.initialized) {
            if ("true".equals(this.getProperty(USE_INTERPRETER_SYSTEM_PROPERTY)) && !ContextFactory.hasExplicitGlobal()) {
                ContextFactory.initGlobal(new ContextFactory(){

                    @Override
                    protected Context makeContext() {
                        Context cx = super.makeContext();
                        cx.setOptimizationLevel(-1);
                        return cx;
                    }
                });
            }
            if (this.listener != null) {
                ContextFactory.getGlobal().addListener(this.listener);
            }
            this.initialized = true;
        }
    }

    public void destroy() {
        if (this.initialized) {
            if (this.listener != null) {
                ContextFactory.getGlobal().removeListener(this.listener);
            }
            this.initialized = false;
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private String getProperty(String key) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    private String getProperty(String name, String defaultValue) {
        String s = this.getProperty(name);
        return s == null ? defaultValue : s;
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = String.valueOf(obj) + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = String.valueOf(ret) + ")";
            return ret;
        }
        int i = 0;
        while (i < len) {
            ret = String.valueOf(ret) + args[i];
            ret = i != len - 1 ? String.valueOf(ret) + "," : String.valueOf(ret) + ")";
            ++i;
        }
        return ret;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        int len = statements.length;
        String ret = "";
        int i = 0;
        while (i < len) {
            ret = String.valueOf(ret) + statements[i] + ";";
            ++i;
        }
        return ret;
    }

    public static void main(String[] args) {
        RhinoScriptEngineFactory fact = new RhinoScriptEngineFactory();
        System.out.println(fact.getParameter("javax.script.engine_version"));
    }
}

