/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.TokenInfo;
import lu.luxtrust.cryptoti.CryptoTI_User;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_NotSupportedException;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_User
implements CryptoTI_User {
    private static final String SECURITY_OFFICER = "SO";
    private static final String USER = "User";
    private Log logger = Logger.getLogger(GTO_CTI_User.class);
    private TokenInfo tokenInfo = null;
    private boolean userType;

    public GTO_CTI_User(TokenInfo tokenInfo, boolean userType) throws CryptoTI_Exception {
        if (tokenInfo == null) {
            this.logger.error("TokenInfo cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "TokenInfo cannot be null.");
        }
        this.tokenInfo = tokenInfo;
        this.userType = userType;
    }

    public String getPassword() throws CryptoTI_Exception {
        this.logger.debug("GET PASSWORD /");
        this.logger.error("Get Password is not supported", 135168);
        throw new CryptoTI_NotSupportedException(135168, "Get Password is not supported");
    }

    public String getUserName() throws CryptoTI_Exception {
        this.logger.debug("GET USERNAME /");
        return this.getUserType(this.userType);
    }

    public boolean isLowPasswordCount() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD COUNT LOW /");
        this.logger.debug("User Type: " + this.getUserType(this.userType));
        if (!this.userType) {
            return this.tokenInfo.isSoPinCountLow();
        }
        if (this.userType) {
            return this.tokenInfo.isUserPinCountLow();
        }
        this.logger.error("Is Password Count is not available", 131082);
        throw new CryptoTI_Exception(131082, "Is Password Count is not available");
    }

    public boolean isPasswordChangeRequired() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD CHANGE REQUIRED /");
        this.logger.debug("User Type: " + this.getUserType(this.userType));
        if (!this.userType) {
            return this.tokenInfo.isSoPinToBeChanged();
        }
        if (this.userType) {
            return this.tokenInfo.isUserPinToBeChanged();
        }
        this.logger.error("Is Password Change Required is not available", 131082);
        throw new CryptoTI_Exception(131082, "Is Password Change Required is not available");
    }

    public boolean isPasswordFinalTry() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD FINAL TRY /");
        this.logger.debug("User Type: " + this.getUserType(this.userType));
        if (!this.userType) {
            return this.tokenInfo.isSoPinFinalTry();
        }
        if (this.userType) {
            return this.tokenInfo.isUserPinFinalTry();
        }
        this.logger.error("Is Password Final Try is not available", 131082);
        throw new CryptoTI_Exception(131082, "Is Password Final Try is not available");
    }

    public boolean isPasswordLocked() throws CryptoTI_Exception {
        this.logger.debug("IS PASSWORD LOCKED /");
        this.logger.debug("User Type: " + this.getUserType(this.userType));
        if (!this.userType) {
            return this.tokenInfo.isSoPinLocked();
        }
        if (this.userType) {
            return this.tokenInfo.isUserPinLocked();
        }
        this.logger.error("Is Password Locked is not available", 131082);
        throw new CryptoTI_Exception(131082, "Is Password Locked is not available");
    }

    public boolean isUserPasswordInitialised() throws CryptoTI_Exception {
        this.logger.debug("IS USER PASSWORD INITIALISED /");
        this.logger.debug("User Type: " + this.getUserType(this.userType));
        return this.tokenInfo.isUserPinInitialized();
    }

    private String getUserType(boolean userType) {
        if (!userType) {
            return SECURITY_OFFICER;
        }
        if (userType) {
            return USER;
        }
        return null;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokenInfo == null ? 0 : this.tokenInfo.hashCode());
        result = 31 * result + (this.userType ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_User other = (GTO_CTI_User)obj;
        if (this.tokenInfo == null ? other.tokenInfo != null : !this.tokenInfo.equals(other.tokenInfo)) {
            return false;
        }
        return this.userType == other.userType;
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        return "User: " + this.userType;
    }
}

