/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.TokenInfo;
import lu.luxtrust.cryptoti.CryptoTI_TokenInfo;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_TokenInfo
implements CryptoTI_TokenInfo {
    private Log logger = Logger.getLogger(GTO_CTI_TokenInfo.class);
    private TokenInfo tokenInfo = null;
    private long minPINLength = -1L;
    private long maxPINLength = -1L;
    private String sessionPINFormat = null;

    public GTO_CTI_TokenInfo(TokenInfo info, long minPINLength, long maxPINLength, String sessionPINFormat) throws CryptoTI_Exception {
        if (info == null) {
            this.logger.error("TokenInfo cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "TokenInfo cannot be null.");
        }
        if (sessionPINFormat == null) {
            this.logger.error("PIN Format cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "PIN Format cannot be null");
        }
        this.tokenInfo = info;
        this.minPINLength = minPINLength;
        this.maxPINLength = maxPINLength;
        this.sessionPINFormat = sessionPINFormat;
    }

    public String getFirmwareVersion() throws CryptoTI_Exception {
        this.logger.debug("GET FIRMWARE VERSION /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getFirmwareVersion().toString();
        }
        return null;
    }

    public String getHardwareVersion() throws CryptoTI_Exception {
        this.logger.debug("GET HARDWARE VERSION /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getHardwareVersion().toString();
        }
        return null;
    }

    public String getLabel() throws CryptoTI_Exception {
        this.logger.debug("GET LABEL /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getLabel();
        }
        return null;
    }

    public String getManufacturerID() throws CryptoTI_Exception {
        this.logger.debug("GET MANUFACTURER ID /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getManufacturerID();
        }
        return null;
    }

    public long getMaximumPinLength() {
        this.logger.debug("GET MAXIMUM PIN LENGTH /");
        return this.maxPINLength;
    }

    public long getMinimumPinLength() {
        this.logger.debug("GET MINIMUM PIN LENGTH /");
        return this.minPINLength;
    }

    public String getModel() {
        this.logger.debug("GET MODEL /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getModel();
        }
        return null;
    }

    public String getSerialNumber() throws CryptoTI_Exception {
        this.logger.debug("GET SERIAL NUMBER /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.getSerialNumber();
        }
        return null;
    }

    public boolean hasProtectedAuthentication() throws CryptoTI_Exception {
        this.logger.debug("HAS PROTECTED AUTHENTICATION /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.isProtectedAuthenticationPath();
        }
        return false;
    }

    public boolean isLoginRequired() throws CryptoTI_Exception {
        this.logger.debug("IS LOGIN REQUIRED /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.isLoginRequired();
        }
        return false;
    }

    public boolean isTokenInitialised() throws CryptoTI_Exception {
        this.logger.debug("IS TOKEN INITIALIZED /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.isTokenInitialized();
        }
        return false;
    }

    public boolean isWriteProtected() throws CryptoTI_Exception {
        this.logger.debug("IS WRITE PROTECTED /");
        if (this.tokenInfo != null) {
            return this.tokenInfo.isWriteProtected();
        }
        return false;
    }

    public String getPINFormat() throws CryptoTI_Exception {
        return this.sessionPINFormat;
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        try {
            return "\nFirmWare Version: " + (this.getFirmwareVersion() == null ? "" : this.getFirmwareVersion().trim()) + "\nHardWare Version: " + (this.getHardwareVersion() == null ? "" : this.getHardwareVersion().trim()) + "\nLabel: " + (this.getLabel() == null ? "" : this.getLabel().trim()) + "\nManufacturer Identifier: " + (this.getManufacturerID() == null ? "" : this.getManufacturerID()) + "\nMaximum PIN Length: " + this.getMaximumPinLength() + "\nMinimum PIN Length: " + this.getMinimumPinLength() + "\nModel: " + (this.getModel() == null ? "" : this.getModel().trim()) + "\nPIN Format: " + (this.getPINFormat() == null ? "" : this.getPINFormat().trim()) + "\nSerial Number: " + (this.getSerialNumber() == null ? "" : this.getSerialNumber().trim()) + "\nHas Protected Authentication: " + this.hasProtectedAuthentication() + "\nIs Login Required? " + this.isLoginRequired() + "\nIs Token Initialised? " + this.isTokenInitialised() + "\nIs Write Protected? " + this.isWriteProtected();
        }
        catch (CryptoTI_Exception e) {
            return "NOT AVAILABLE";
        }
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokenInfo == null ? 0 : this.tokenInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_TokenInfo other = (GTO_CTI_TokenInfo)obj;
        return !(this.tokenInfo == null ? other.tokenInfo != null : !this.tokenInfo.equals(other.tokenInfo));
    }
}

