/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.InputStream;
import java.util.ArrayList;
import lu.luxtrust.cryptoti.CryptoTI_Certificate;
import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.CryptoTI_PrivateKey;
import lu.luxtrust.cryptoti.CryptoTI_PublicKey;
import lu.luxtrust.cryptoti.CryptoTI_Session;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.CryptoTI_TokenInfo;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Certificate;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Mechanism;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_PrivateKey;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_PublicKey;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Session;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_TokenInfo;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_X509;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.utils.BinaryUtils;

public class GTO_CTI_Token
implements CryptoTI_Token {
    private Log logger = Logger.getLogger(GTO_CTI_Token.class);
    private Token token = null;
    private GTO_CTI_TokenInfo _info = null;
    private boolean multipleLogin = false;
    private int signUpdateCounter = 0;
    private boolean checkPWDFormat = false;
    private long minPINLength = -1L;
    private long maxPINLength = -1L;
    private String sessionPINFormat = null;

    public GTO_CTI_Token(Token token, boolean multipleLogin, boolean checkPWDFormat, long minPINLength, long maxPINLength, String sessionPINFormat) throws CryptoTI_Exception {
        if (token == null) {
            this.logger.warn("Token cannot be null. The token will not be displayed.", 131075);
            return;
        }
        TokenInfo tokenInfo = null;
        try {
            tokenInfo = token.getTokenInfo();
        }
        catch (TokenException e) {
            try {
                if (e.getMessage().startsWith("CKR_TOKEN_NOT_PRESENT") && token.getSlot().getSlotInfo().isTokenPresent()) {
                    this.logger.warn("An uncompatible token has been detected. The token will not be displayed!", 131076);
                } else if (e.getMessage().startsWith("CKR_TOKEN_NOT_PRESENT")) {
                    this.logger.warn("No token present in the slot!", 131078);
                } else {
                    this.logger.error("An unexpected error occured.", (Throwable)e, 131072);
                    throw new CryptoTI_SessionException(131072, "An unexpected error occured.");
                }
                token.closeAllSessions();
            }
            catch (TokenException e1) {
                this.logger.warn("Not able to close the token session!", 143363);
            }
            token = null;
        }
        if (tokenInfo != null) {
            if (this.logger.isDebuggingEnabled()) {
                this.logger.debug("Token ID: " + token.getTokenID());
                this.logger.debug("Token Label: " + tokenInfo.getLabel());
                this.logger.debug("Serial number: " + tokenInfo.getSerialNumber());
                this.logger.debug("Firmware version: " + tokenInfo.getFirmwareVersion());
                this.logger.debug("Hardware version: " + tokenInfo.getHardwareVersion());
                this.logger.debug("Model: " + tokenInfo.getModel());
                this.logger.debug("Manufacturer ID: " + tokenInfo.getManufacturerID());
                this.logger.debug("Free Public Memory: " + tokenInfo.getFreePublicMemory());
                this.logger.debug("Total Public Memory: " + tokenInfo.getTotalPublicMemory());
                this.logger.debug("Free Private Memory: " + tokenInfo.getFreePrivateMemory());
                this.logger.debug("Total Private Memory: " + tokenInfo.getTotalPrivateMemory());
                this.logger.debug("Minimum PW length: " + tokenInfo.getMinPinLen());
                this.logger.debug("Maximum PW length: " + tokenInfo.getMaxPinLen());
                this.logger.debug("Session count: " + tokenInfo.getSessionCount());
                this.logger.debug("Maximum RW Session count: " + tokenInfo.getMaxRwSessionCount());
                this.logger.debug("Maximum session count: " + tokenInfo.getMaxSessionCount());
                this.logger.debug("User PIN Count Low? " + tokenInfo.isUserPinCountLow());
                this.logger.debug("User PIN Final Try? " + tokenInfo.isUserPinFinalTry());
                this.logger.debug("User PIN initialized? " + tokenInfo.isUserPinInitialized());
                this.logger.debug("User PIN locked? " + tokenInfo.isUserPinLocked());
                this.logger.debug("User PIN to be changed? " + tokenInfo.isUserPinToBeChanged());
                this.logger.debug("SO PIN Count Low? " + tokenInfo.isSoPinCountLow());
                this.logger.debug("SO PIN Final Try? " + tokenInfo.isSoPinFinalTry());
                this.logger.debug("SO PIN locked? " + tokenInfo.isSoPinLocked());
                this.logger.debug("SO PIN to be changed? " + tokenInfo.isSoPinToBeChanged());
            }
        } else {
            this.logger.debug("TOKEN INFO not available!");
            return;
        }
        this.token = token;
        this._info = new GTO_CTI_TokenInfo(tokenInfo, minPINLength, maxPINLength, sessionPINFormat);
        this.multipleLogin = multipleLogin;
        this.checkPWDFormat = checkPWDFormat;
        this.minPINLength = minPINLength;
        this.maxPINLength = maxPINLength;
        this.sessionPINFormat = sessionPINFormat;
    }

    public void closeSession(CryptoTI_Session session) throws CryptoTI_Exception {
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        try {
            GTO_CTI_Session _session = (GTO_CTI_Session)session;
            _session.getSession().closeSession();
            session = null;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public CryptoTI_TokenInfo getInfo() throws CryptoTI_Exception {
        this.logger.debug("GET INFO /");
        return this._info;
    }

    public CryptoTI_PrivateKey getPrivateKey(CryptoTI_PublicKey key, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("GET PRIVATE KEY /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (key == null) {
            this.logger.error("Public Key cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Public Key cannot be null");
        }
        try {
            iaik.pkcs.pkcs11.objects.Object[] privateSignatureKeys;
            GTO_CTI_PublicKey _ccPublicKey = (GTO_CTI_PublicKey)key;
            GTO_CTI_Session _ccSession = (GTO_CTI_Session)session;
            RSAPrivateKey privateSignatureKeyTemplate = new RSAPrivateKey();
            privateSignatureKeyTemplate.getSign().setBooleanValue(new Boolean(true));
            _ccSession.getSession().findObjectsInit(privateSignatureKeyTemplate);
            String publicKeyIdentifier = BinaryUtils.byte2Hex(_ccPublicKey.getKeyIdentifier());
            while ((privateSignatureKeys = _ccSession.getSession().findObjects(1)).length > 0) {
                String privateKeyIdentifier;
                RSAPrivateKey _privateKey = (RSAPrivateKey)privateSignatureKeys[0];
                GTO_CTI_PrivateKey _ccPrivateKey = new GTO_CTI_PrivateKey(_privateKey);
                if (_ccPrivateKey.getKeyIdentifier() != null ? (privateKeyIdentifier = BinaryUtils.byte2Hex(_ccPrivateKey.getKeyIdentifier())).trim().equals(publicKeyIdentifier.trim()) : _ccPrivateKey.getAlias().getAlias().equals(_ccPublicKey.getAlias().getAlias())) {
                    return _ccPrivateKey;
                }
                _privateKey = null;
                _ccPrivateKey = null;
            }
            return null;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public CryptoTI_PrivateKey getPrivateKey(CryptoTI_Certificate certificate, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("GET PRIVATE KEY /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (certificate == null) {
            this.logger.error("Certificate cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Certificate cannot be null");
        }
        try {
            iaik.pkcs.pkcs11.objects.Object[] privateSignatureKeys;
            GTO_CTI_Certificate _ccCertificate = (GTO_CTI_Certificate)certificate;
            GTO_CTI_Session _ccSession = (GTO_CTI_Session)session;
            RSAPrivateKey privateSignatureKeyTemplate = new RSAPrivateKey();
            privateSignatureKeyTemplate.getSign().setBooleanValue(new Boolean(true));
            _ccSession.getSession().findObjectsInit(privateSignatureKeyTemplate);
            while ((privateSignatureKeys = _ccSession.getSession().findObjects(1)).length > 0) {
                RSAPrivateKey _privateKey = (RSAPrivateKey)privateSignatureKeys[0];
                GTO_CTI_PrivateKey _ccPrivateKey = new GTO_CTI_PrivateKey(_privateKey);
                if (_ccPrivateKey.getAlias().getAlias().equals(_ccCertificate.getAlias().getAlias())) {
                    return _ccPrivateKey;
                }
                _privateKey = null;
                _ccPrivateKey = null;
            }
            return null;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public void initialise() throws CryptoTI_Exception {
        this.logger.debug("INIT /");
    }

    public void initialise(InputStream configurationFile) throws CryptoTI_Exception {
        this.logger.debug("INIT / Configuration Inputstream");
    }

    public void initialise(String pathToConfigurationFile) throws CryptoTI_Exception {
        this.logger.debug("INIT / Configuration Inputstream");
    }

    public CryptoTI_Certificate[] listCertificates(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("LIST CERTIFICATES /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        try {
            iaik.pkcs.pkcs11.objects.Object[] certificates;
            GTO_CTI_Session _ccsession = (GTO_CTI_Session)session;
            Certificate certificateTemplate = new Certificate();
            _ccsession.getSession().findObjectsInit(certificateTemplate);
            ArrayList<GTO_CTI_X509> _certificates = new ArrayList<GTO_CTI_X509>();
            while ((certificates = _ccsession.getSession().findObjects(1)).length > 0) {
                X509PublicKeyCertificate _certificate = (X509PublicKeyCertificate)certificates[0];
                _certificates.add(new GTO_CTI_X509(new GTO_CTI_Certificate(_certificate)));
            }
            if (this.logger.isDebuggingEnabled()) {
                if (_certificates.size() > 0) {
                    this.logger.debug("Number of certificates found: " + _certificates.size());
                } else {
                    this.logger.debug("No certificates have been found.");
                }
            }
            return _certificates.toArray(new GTO_CTI_X509[_certificates.size()]);
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public CryptoTI_Mechanism[] listMechanisms() throws CryptoTI_Exception {
        this.logger.debug("LIST MECHANISMS /");
        try {
            Mechanism[] mechanisms = this.token.getMechanismList();
            CryptoTI_Mechanism[] _mechanisms = new GTO_CTI_Mechanism[2];
            if (mechanisms != null) {
                Mechanism _mechanism;
                this.logger.debug("Number of mechanisms: " + mechanisms.length);
                int mechaIndex = 0;
                while (mechaIndex < mechanisms.length) {
                    _mechanism = mechanisms[mechaIndex];
                    if (_mechanism.equals(Mechanism.SHA256_RSA_PKCS)) {
                        _mechanisms = new GTO_CTI_Mechanism[3];
                    }
                    ++mechaIndex;
                }
                mechaIndex = 0;
                while (mechaIndex < mechanisms.length) {
                    _mechanism = mechanisms[mechaIndex];
                    GTO_CTI_Mechanism _ccmechanism = new GTO_CTI_Mechanism(_mechanism);
                    if (this.logger.isDebuggingEnabled()) {
                        this.logger.debug("Mechanism: " + _ccmechanism.getName());
                    }
                    if (_mechanism.equals(Mechanism.SHA1_RSA_PKCS)) {
                        _mechanisms[0] = _ccmechanism;
                    } else if (_mechanism.equals(Mechanism.RSA_PKCS)) {
                        _mechanisms[1] = _ccmechanism;
                    } else if (_mechanism.equals(Mechanism.SHA256_RSA_PKCS)) {
                        _mechanisms[2] = _ccmechanism;
                    }
                    ++mechaIndex;
                }
                if (this.logger.isDebuggingEnabled()) {
                    if (_mechanisms.length > 0) {
                        this.logger.debug("Number of mechanisms found: " + _mechanisms.length);
                    } else {
                        this.logger.debug("No mechanisms have been found.");
                    }
                }
            } else {
                this.logger.debug("No mechanisms inlcuded.");
                _mechanisms = null;
            }
            return _mechanisms;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public CryptoTI_PublicKey[] listPublicKeys(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("LIST PUBLIC KEYS /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        try {
            iaik.pkcs.pkcs11.objects.Object[] publicSignatureKeys;
            GTO_CTI_Session _session = (GTO_CTI_Session)session;
            RSAPublicKey publicSignatureKeyTemplate = new RSAPublicKey();
            publicSignatureKeyTemplate.getVerify().setBooleanValue(new Boolean(false));
            _session.getSession().findObjectsInit(publicSignatureKeyTemplate);
            ArrayList<GTO_CTI_PublicKey> _publicKeys = new ArrayList<GTO_CTI_PublicKey>();
            while ((publicSignatureKeys = _session.getSession().findObjects(1)).length > 0) {
                RSAPublicKey _publicKey = (RSAPublicKey)publicSignatureKeys[0];
                _publicKeys.add(new GTO_CTI_PublicKey(_publicKey));
            }
            if (this.logger.isDebuggingEnabled()) {
                if (_publicKeys.size() > 0) {
                    this.logger.debug("Number of public keys: " + _publicKeys.size());
                } else {
                    this.logger.debug("No public keys have been found.");
                }
            }
            return _publicKeys.toArray(new GTO_CTI_PublicKey[_publicKeys.size()]);
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public CryptoTI_Session openSession() throws CryptoTI_Exception {
        this.logger.debug("OPEN SESSION /");
        try {
            Session _session = this.token.openSession(true, false, null, null);
            if (_session != null) {
                return new GTO_CTI_Session(_session, this.token, this.multipleLogin, this.checkPWDFormat, this.minPINLength, this.maxPINLength, this.sessionPINFormat);
            }
            return null;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public byte[] signFinal(CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("SIGN FINAL /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (!session.isLoggedIn()) {
            this.logger.error("Not Logged In", 143373);
            throw new CryptoTI_SessionException(143373, "Not Logged In");
        }
        GTO_CTI_Session ccSession = (GTO_CTI_Session)session;
        this.signUpdateCounter = 0;
        try {
            return ccSession.getSession().signFinal();
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            if (e.getMessage().startsWith("CKR_FUNCTION_FAILED")) {
                this.logger.error("Function failed", (Throwable)e, 131074);
                throw new CryptoTI_SessionException(131074, "Function failed");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public boolean signInit(CryptoTI_PrivateKey privateKey, CryptoTI_Session session, CryptoTI_Mechanism mechanism) throws CryptoTI_Exception {
        this.logger.debug("SIGN INIT /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (privateKey == null) {
            this.logger.error("Private Key cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Private Key cannot be null");
        }
        if (mechanism == null) {
            this.logger.error("Mechanism cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Mechanism cannot be null");
        }
        if (!this.isMechanismSupported(mechanism)) {
            this.logger.error("Mechanism not supported", 147471);
            throw new CryptoTI_Exception(147471, mechanism.getName());
        }
        GTO_CTI_Session ccSession = (GTO_CTI_Session)session;
        GTO_CTI_PrivateKey ccPrivateKey = (GTO_CTI_PrivateKey)privateKey;
        GTO_CTI_Mechanism ccMechanism = (GTO_CTI_Mechanism)mechanism;
        this.signUpdateCounter = 0;
        try {
            ccSession.getSession().signInit(ccMechanism.getMechanism(), ccPrivateKey.getPrivateKey());
            ccSession = null;
            ccPrivateKey = null;
            return true;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            if (!session.isLoggedIn()) {
                this.logger.error("Not Logged In", 143373);
                return false;
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public int signUpdate(byte[] data, CryptoTI_Session session) throws CryptoTI_Exception {
        this.logger.debug("SIGN UPDATE /");
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Session cannot be null");
        }
        if (data == null) {
            this.logger.error("Data cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Data cannot be null");
        }
        if (!session.isLoggedIn()) {
            this.logger.error("Not Logged In", 143373);
            throw new CryptoTI_SessionException(143373, "Not Logged In");
        }
        GTO_CTI_Session ccSession = (GTO_CTI_Session)session;
        try {
            ccSession.getSession().signUpdate(data);
            this.signUpdateCounter += data.length;
            return this.signUpdateCounter;
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "TokenException occurred");
        }
    }

    public void terminate() throws CryptoTI_Exception {
        this.logger.debug("TERMINATE /");
        if (this.token != null) {
            try {
                this.token.closeAllSessions();
                this.token = null;
            }
            catch (TokenException e) {
                this.logger.error((Exception)e, 131072);
                throw new CryptoTI_Exception(131072, (Throwable)e);
            }
        } else {
            throw new CryptoTI_Exception();
        }
    }

    public boolean isAvailable() throws CryptoTI_Exception {
        this.logger.debug("IS AVAILABLE /");
        try {
            return this.token.getSlot().getSlotInfo().isTokenPresent();
        }
        catch (TokenException e) {
            this.logger.warn("PKCS#11 attribute \"Is Available\" is not available", (Throwable)e, 131082);
            throw new CryptoTI_Exception(131082, "Is Available is not available");
        }
    }

    private boolean isMechanismSupported(CryptoTI_Mechanism mechanism) throws CryptoTI_Exception {
        if (mechanism == null) {
            return false;
        }
        GTO_CTI_Mechanism[] __mechanisms = (GTO_CTI_Mechanism[])this.listMechanisms();
        if (__mechanisms == null) {
            return false;
        }
        int mechaIndex = 0;
        while (mechaIndex < __mechanisms.length) {
            GTO_CTI_Mechanism _mechanism = __mechanisms[mechaIndex];
            if (_mechanism.equals(mechanism) && (_mechanism.getMechanism().equals(Mechanism.SHA1_RSA_PKCS) || _mechanism.getMechanism().equals(Mechanism.RSA_PKCS) || _mechanism.getMechanism().equals(Mechanism.SHA256_RSA_PKCS))) {
                return true;
            }
            ++mechaIndex;
        }
        return false;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._info == null ? 0 : this._info.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_Token other = (GTO_CTI_Token)obj;
        if (this._info == null ? other._info != null : !this._info.equals(other._info)) {
            return false;
        }
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        return this.token.toString();
    }
}

