/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import lu.luxtrust.cryptoti.CryptoTI_Session;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.CryptoTI_User;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Token;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_User;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.utils.TextUtils;

public class GTO_CTI_Session
implements CryptoTI_Session {
    private static final String SECURITY_OFFICER = "SO";
    private static final String USER = "User";
    private Log logger = Logger.getLogger(GTO_CTI_Session.class);
    private Session session = null;
    private GTO_CTI_User user = null;
    private boolean loggedIn = false;
    private boolean SO = false;
    private boolean multipleLogin = false;
    private Token token = null;
    private boolean checkPWDFormat = false;
    private long minPINLength = -1L;
    private long maxPINLength = -1L;
    private String sessionPINFormat = null;

    public GTO_CTI_Session(Session session, Token token, boolean multipleLogin, boolean checkPWDFormat, long minPINLength, long maxPINLength, String sessionPINFormat) throws CryptoTI_Exception {
        if (session == null) {
            this.logger.error("Session cannot be null", 131075);
            throw new CryptoTI_SessionException(131075, "Session cannot be null");
        }
        if (token == null) {
            this.logger.error("Token cannot be null", 131075);
            throw new CryptoTI_SessionException(131075, "Token cannot be null");
        }
        this.session = session;
        this.token = token;
        this.multipleLogin = multipleLogin;
        this.checkPWDFormat = checkPWDFormat;
        this.minPINLength = minPINLength;
        this.maxPINLength = maxPINLength;
        this.sessionPINFormat = sessionPINFormat;
    }

    public String getHandleID() throws CryptoTI_Exception {
        this.logger.debug("GET HANDLE ID /");
        return String.valueOf(this.session.getSessionHandle());
    }

    public CryptoTI_User getUser() throws CryptoTI_Exception {
        this.logger.debug("GET USER /");
        if (this.user == null) {
            try {
                return new GTO_CTI_User(this.session.getToken().getTokenInfo(), true);
            }
            catch (TokenException e) {
                if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                    this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                    throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                }
                this.logger.error("TokenException occurred", (Throwable)e, 131072);
                throw new CryptoTI_SessionException(131072, "TokenException occurred");
            }
        }
        return this.user;
    }

    public boolean isLoggedIn() throws CryptoTI_Exception {
        this.logger.debug("IS LOGGED IN /");
        return this.loggedIn;
    }

    public boolean isPublic() throws CryptoTI_Exception {
        block4: {
            this.logger.debug("IS PUBLIC /");
            try {
                if (!this.session.getSessionInfo().getState().equals(State.RO_PUBLIC_SESSION)) break block4;
                return true;
            }
            catch (TokenException e) {
                if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                    this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                    throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                }
                this.logger.error("TokenException occurred", (Throwable)e, 131072);
                throw new CryptoTI_SessionException(131072, "TokenException occurred");
            }
        }
        return this.session.getSessionInfo().getState().equals(State.RW_PUBLIC_SESSION);
    }

    public boolean isReadOnly() throws CryptoTI_Exception {
        this.logger.debug("IS READ ONLY /");
        try {
            return !this.session.getSessionInfo().isRwSession();
        }
        catch (TokenException e) {
            if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
            }
            this.logger.error("TokenException occurred", (Throwable)e, 131072);
            throw new CryptoTI_SessionException(131072, "TokenException occurred");
        }
    }

    public boolean isSecurityOfficer() throws CryptoTI_Exception {
        this.logger.debug("IS SECURITY OFFICER /");
        if (this.isLoggedIn()) {
            return this.SO;
        }
        this.logger.error("Not Logged In", 143373);
        throw new CryptoTI_SessionException(143373, "Not logged In");
    }

    public boolean isUserSession() throws CryptoTI_Exception {
        this.logger.debug("IS USER SESSION /");
        if (this.isLoggedIn()) {
            return !this.SO;
        }
        this.logger.error("Not Logged In", 143373);
        throw new CryptoTI_SessionException(143373, "Not logged In");
    }

    public void logOff() throws CryptoTI_Exception {
        this.logger.debug("LOGOFF /");
        if (this.session != null) {
            try {
                this.session.logout();
                this.loggedIn = false;
            }
            catch (TokenException e) {
                if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                    this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                    throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                }
                this.logger.error("TokenException occurred", (Throwable)e, 131072);
                throw new CryptoTI_SessionException(131072, "TokenException occurred");
            }
        } else {
            this.logger.error("Session cannot be null", 131072);
            throw new CryptoTI_SessionException(131072, "Session cannot be null");
        }
    }

    public CryptoTI_User login(String userName, char[] password) throws CryptoTI_Exception {
        this.logger.debug("LOGIN /");
        if (userName == null || userName.equals("")) {
            this.logger.error("UserName cannot be null", 131075);
            throw new CryptoTI_SessionException(131075, "UserName cannot be null");
        }
        if (this.loggedIn) {
            this.logger.warn("User Already logged in for this session", 131072);
            throw new CryptoTI_SessionException(131072, "User Already logged in for this session");
        }
        if (password != null && this.checkPWDFormat) {
            this.logger.debug("Password needs to checked!");
            String _password = String.valueOf(password);
            this.logger.debug("Regular Expression: " + this.sessionPINFormat);
            if (TextUtils.matchRegEx(_password, this.sessionPINFormat)) {
                this.logger.debug("Password is OK");
            } else {
                this.logger.warn("Password does not match required PWD format: " + this.sessionPINFormat, 143369);
                throw new CryptoTI_SessionException(143369, "Password does not match required PWD format");
            }
        }
        boolean userType = true;
        if (userName.equals(SECURITY_OFFICER)) {
            userType = false;
            this.SO = true;
        } else if (userName.equals(USER)) {
            userType = true;
        } else {
            this.logger.error("Invalid UserName", 131075);
            throw new CryptoTI_SessionException(131075, "Invalid UserName");
        }
        if (this.session != null) {
            if (this.multipleLogin) {
                try {
                    if (password == null) {
                        if (this.session.getToken().getTokenInfo().isProtectedAuthenticationPath()) {
                            this.session.login(userType, null);
                        }
                    } else {
                        this.session.login(userType, password);
                    }
                    this.loggedIn = true;
                    this.user = new GTO_CTI_User(this.session.getToken().getTokenInfo(), userType);
                    return this.user;
                }
                catch (TokenException e) {
                    if (e.getMessage().startsWith("CKR_PIN_INCORRECT")) {
                        this.logger.error("PIN Incorrect", (Throwable)e, 143368);
                        throw new CryptoTI_SessionException(143368, "PIN Incorrect");
                    }
                    if (e.getMessage().startsWith("CKR_PIN_LOCKED")) {
                        this.logger.error("PIN Locked", (Throwable)e, 143372);
                        throw new CryptoTI_SessionException(143372, "PIN Locked");
                    }
                    if (e.getMessage().startsWith("CKR_TOKEN_NOT_PRESENT")) {
                        this.logger.error("Token Not Present", (Throwable)e, 131078);
                        throw new CryptoTI_SessionException(131078, "Token Not Present");
                    }
                    if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                        this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                        throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                    }
                    if (e.getMessage().startsWith("CKR_USER_ALREADY_LOGGED_IN")) {
                        try {
                            this.session.logout();
                            this.loggedIn = false;
                        }
                        catch (TokenException e1) {
                            this.logger.error("Logout failed", (Throwable)e1, 131072);
                            throw new CryptoTI_SessionException(131072, (Throwable)e1);
                        }
                        try {
                            if (password == null) {
                                if (this.session.getToken().getTokenInfo().isProtectedAuthenticationPath()) {
                                    this.session.login(userType, null);
                                }
                            } else {
                                this.session.login(userType, password);
                            }
                            this.loggedIn = true;
                            this.user = new GTO_CTI_User(this.session.getToken().getTokenInfo(), userType);
                            return this.user;
                        }
                        catch (TokenException e2) {
                            if (e2.getMessage().startsWith("CKR_PIN_INCORRECT")) {
                                this.logger.error("PIN Incorrect", (Throwable)e2, 143368);
                                throw new CryptoTI_SessionException(143368, "PIN Incorrect");
                            }
                            if (e2.getMessage().startsWith("CKR_PIN_LOCKED")) {
                                this.logger.error("PIN Locked", (Throwable)e2, 143372);
                                throw new CryptoTI_SessionException(143372, "PIN Locked");
                            }
                            if (e2.getMessage().startsWith("CKR_TOKEN_NOT_PRESENT")) {
                                this.logger.error("Token Not Present", (Throwable)e2, 131078);
                                throw new CryptoTI_SessionException(131078, "Token Not Present");
                            }
                            if (e2.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                                this.logger.error("Invalid Session Handling", (Throwable)e2, 143363);
                                throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                            }
                            if (e2.getMessage().startsWith("CKR_USER_ALREADY_LOGGED_IN")) {
                                this.logger.warn("ML : User already logged in", (Throwable)e2, 131072);
                                throw new CryptoTI_SessionException(131072, "User already logged in");
                            }
                            this.logger.error("TokenException occurred", (Throwable)e2, 131072);
                            throw new CryptoTI_SessionException(131072, "TokenException occurred");
                        }
                    }
                    this.logger.error("TokenException occurred", (Throwable)e, 131072);
                    throw new CryptoTI_SessionException(131072, "TokenException occurred");
                }
            }
            try {
                if (password == null) {
                    if (this.session.getToken().getTokenInfo().isProtectedAuthenticationPath()) {
                        this.session.login(userType, null);
                    }
                } else {
                    this.session.login(userType, password);
                }
                this.loggedIn = true;
                this.user = new GTO_CTI_User(this.session.getToken().getTokenInfo(), userType);
                return this.user;
            }
            catch (TokenException e) {
                if (e.getMessage().startsWith("CKR_PIN_INCORRECT")) {
                    this.logger.error("PIN Incorrect", (Throwable)e, 143368);
                    throw new CryptoTI_SessionException(143368, "PIN Incorrect");
                }
                if (e.getMessage().startsWith("CKR_PIN_LOCKED")) {
                    this.logger.error("PIN Locked", (Throwable)e, 143372);
                    throw new CryptoTI_SessionException(143372, "PIN Locked");
                }
                if (e.getMessage().startsWith("CKR_TOKEN_NOT_PRESENT")) {
                    this.logger.error("Token Not Present", (Throwable)e, 131078);
                    throw new CryptoTI_SessionException(131078, "Token Not Present");
                }
                if (e.getMessage().startsWith("CKR_SESSION_HANDLE_INVALID")) {
                    this.logger.error("Invalid Session Handling", (Throwable)e, 143363);
                    throw new CryptoTI_SessionException(143363, "Invalid Session Handling");
                }
                if (e.getMessage().startsWith("CKR_USER_ALREADY_LOGGED_IN")) {
                    this.logger.warn("NML : User already logged in", 131072);
                    throw new CryptoTI_SessionException(131072, "User already logged in");
                }
                this.logger.error("TokenException occurred", (Throwable)e, 131072);
                throw new CryptoTI_SessionException(131072, "TokenException occurred");
            }
        }
        return null;
    }

    public CryptoTI_Token getToken() throws CryptoTI_Exception {
        this.logger.debug("GET TOKEN /");
        if (this.session != null) {
            return new GTO_CTI_Token(this.token, this.multipleLogin, this.checkPWDFormat, this.minPINLength, this.maxPINLength, this.sessionPINFormat);
        }
        return null;
    }

    public Session getSession() {
        this.logger.debug("GET SESSION /");
        return this.session;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.multipleLogin ? 1231 : 1237);
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_Session other = (GTO_CTI_Session)obj;
        if (this.multipleLogin != other.multipleLogin) {
            return false;
        }
        if (this.session == null ? other.session != null : !this.session.equals(other.session)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        return this.session.toString();
    }
}

