/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MechanismArrayAttribute;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.CryptoTI_PrivateKey;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_NotSupportedException;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Alias;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Mechanism;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_PrivateKey
implements CryptoTI_PrivateKey {
    private Log logger = Logger.getLogger(GTO_CTI_PrivateKey.class);
    private RSAPrivateKey privateKey = null;

    public GTO_CTI_PrivateKey(RSAPrivateKey privateKey) throws CryptoTI_Exception {
        if (privateKey == null) {
            this.logger.error("Private Key cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Private Key cannot be null.");
        }
        this.privateKey = privateKey;
    }

    public byte[] getKeySubject() throws CryptoTI_Exception {
        this.logger.debug("GET KEY SUBJECT /");
        ByteArrayAttribute subject = this.privateKey.getSubject();
        if (subject == null) {
            this.logger.warn("PKCS#11 attribute \"Key Subject\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Key Subject is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (KeySubject) ?  " + subject.isPresent());
            this.logger.debug("SENSITIVE (KeySubject) ? " + subject.isSensitive());
        }
        if (subject.isPresent()) {
            return subject.getByteArrayValue();
        }
        this.logger.warn("PKCS#11 attribute \"Key Subject\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key Subject is not available");
    }

    public boolean isSigningEnabled() throws CryptoTI_Exception {
        this.logger.debug("IS SIGNING ENABLED /");
        BooleanAttribute sign = this.privateKey.getSign();
        if (sign == null) {
            this.logger.warn("PKCS#11 attribute \"Signing Enabled\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Signing enabled is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Signing Enabled) ?  " + sign.isPresent());
            this.logger.debug("SENSITIVE (Signing Enabled) ? " + sign.isSensitive());
        }
        if (sign.isPresent()) {
            return sign.getBooleanValue();
        }
        this.logger.warn("PKCS#11 attribute \"Signing Enabled\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Signing Enabled is not available");
    }

    public Date getEndDate() throws CryptoTI_Exception {
        this.logger.debug("GET END DATE /");
        DateAttribute date = this.privateKey.getEndDate();
        if (date == null) {
            this.logger.warn("PKCS#11 attribute \"End date\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "End date is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (End date) ?  " + date.isPresent());
            this.logger.debug("SENSITIVE (End date) ? " + date.isSensitive());
        }
        if (date.isPresent()) {
            return date.getDateValue();
        }
        this.logger.warn("PKCS#11 attribute \"End date\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "End date is not available");
    }

    public byte[] getKeyIdentifier() throws CryptoTI_Exception {
        this.logger.debug("GET KEY IDENTIFIER /");
        ByteArrayAttribute identifier = this.privateKey.getId();
        if (identifier == null) {
            this.logger.warn("PKCS#11 attribute \"Key identifier\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Key identifier is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Key identifier) ?  " + identifier.isPresent());
            this.logger.debug("SENSITIVE (Key identifier) ? " + identifier.isSensitive());
        }
        if (identifier.isPresent()) {
            return identifier.getByteArrayValue();
        }
        this.logger.warn("PKCS#11 attribute \"Key identifier\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key identifier is not available");
    }

    public Date getStartDate() throws CryptoTI_Exception {
        this.logger.debug("GET START DATE /");
        DateAttribute date = this.privateKey.getStartDate();
        if (date == null) {
            this.logger.warn("PKCS#11 attribute \"Start date\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Start date is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Start date) ?  " + date.isPresent());
            this.logger.debug("SENSITIVE (Start date) ? " + date.isSensitive());
        }
        if (date.isPresent()) {
            return date.getDateValue();
        }
        this.logger.warn("PKCS#11 attribute \"Start date\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Start date is not available");
    }

    public String getType() throws CryptoTI_Exception {
        this.logger.debug("GET TYPE /");
        LongAttribute keyType = this.privateKey.getKeyType();
        if (keyType == null) {
            this.logger.warn("PKCS#11 attribute \"Key Type\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Key type is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Key type) ?  " + keyType.isPresent());
            this.logger.debug("SENSITIVE (Key type) ? " + keyType.isSensitive());
        }
        if (keyType.isPresent()) {
            return keyType.toString();
        }
        this.logger.warn("PKCS#11 attribute \"Key Type\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Key type is not available");
    }

    public boolean isLocal() throws CryptoTI_Exception {
        this.logger.debug("IS LOCAL /");
        BooleanAttribute local = this.privateKey.getLocal();
        if (local == null) {
            this.logger.warn("PKCS#11 attribute \"Local\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Local is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Local) ?  " + local.isPresent());
            this.logger.debug("SENSITIVE (Local) ? " + local.isSensitive());
        }
        if (local.isPresent()) {
            return local.getBooleanValue();
        }
        this.logger.warn("PKCS#11 attribute \"Local\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Local is not available");
    }

    public CryptoTI_Mechanism[] listMechanisms() throws CryptoTI_Exception {
        this.logger.debug("LIST MECHANISMS /");
        MechanismArrayAttribute mechanisms = this.privateKey.getAllowedMechanisms();
        if (mechanisms == null) {
            this.logger.warn("PKCS#11 list of allowed mechanisms is not available", 131082);
            throw new CryptoTI_Exception(131082, "List of allowed mechanisms is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Mechanism List) ?  " + mechanisms.isPresent());
            this.logger.debug("SENSITIVE (Mechanism List) ? " + mechanisms.isSensitive());
        }
        if (!mechanisms.isPresent()) {
            this.logger.warn("PKCS#11 list of allowed mechanisms is not available", 131082);
            throw new CryptoTI_Exception(131082, "List of allowed mechanisms is not available");
        }
        Mechanism[] _mechanisms = mechanisms.getMechanismAttributeArrayValue();
        ArrayList<GTO_CTI_Mechanism> __mechanisms = new ArrayList<GTO_CTI_Mechanism>();
        if (mechanisms != null) {
            this.logger.debug("Number of mechanisms: " + _mechanisms.length);
            int mechaIndex = 0;
            while (mechaIndex < _mechanisms.length) {
                GTO_CTI_Mechanism _mechanism = new GTO_CTI_Mechanism(_mechanisms[mechaIndex]);
                if (_mechanism != null) {
                    this.logger.debug(_mechanism.toString());
                    __mechanisms.add(_mechanism);
                } else {
                    this.logger.debug("Mechanism " + _mechanisms[mechaIndex].getName() + " could not be added into list.");
                }
                ++mechaIndex;
            }
            if (this.logger.isDebuggingEnabled()) {
                if (__mechanisms.size() > 0) {
                    this.logger.debug("Number of mechanisms found: " + __mechanisms.size());
                } else {
                    this.logger.debug("No mechanisms have been found.");
                }
            }
        } else {
            this.logger.debug("No mechanisms inlcuded by PKCS#11 implementation.");
        }
        return __mechanisms.toArray(new GTO_CTI_Mechanism[__mechanisms.size()]);
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        this.logger.debug("GET ALIAS /");
        CharArrayAttribute alias = this.privateKey.getLabel();
        if (alias == null) {
            this.logger.warn("PKCS#11 attribute \"Alias\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Alias is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Alias) ?  " + alias.isPresent());
            this.logger.debug("SENSITIVE (Alias) ? " + alias.isSensitive());
        }
        if (alias.isPresent()) {
            this.logger.debug("Alias = " + alias.toString());
            return new GTO_CTI_Alias(alias.toString());
        }
        this.logger.warn("PKCS#11 attribute \"Alias\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Alias is not available");
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        this.logger.debug("GET ENCODED /");
        this.logger.debug("FCT NOT SUPPORTED BY DEVICE");
        this.logger.warn("Private Key cannot be extracted", 135168);
        throw new CryptoTI_NotSupportedException(135168, "Private Key cannot be extracted.");
    }

    public RSAPrivateKey getPrivateKey() {
        this.logger.debug("GET PRIVATE KEY /");
        return this.privateKey;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_PrivateKey other = (GTO_CTI_PrivateKey)obj;
        return !(this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        try {
            return this.getAlias().toString();
        }
        catch (CryptoTI_Exception e) {
            this.logger.warn((Exception)((Object)e), 0);
            return null;
        }
    }
}

