/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CDMFSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public CDMFSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CDMF);
    }

    protected CDMFSecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.CDMF);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        CDMFSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CDMFSecretKey cDMFSecretKey = (CDMFSecretKey)super.clone();
        cDMFSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        CDMFSecretKey.putAttributesInTable(cDMFSecretKey);
        return cDMFSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof CDMFSecretKey) {
            CDMFSecretKey cDMFSecretKey = (CDMFSecretKey)object;
            bl = this == cDMFSecretKey || super.equals(cDMFSecretKey) && this.value_.equals(cDMFSecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new CDMFSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(CDMFSecretKey cDMFSecretKey) {
        if (cDMFSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        cDMFSecretKey.attributeTable_.put(Attribute.VALUE, cDMFSecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

