/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.concordion.api.Resource;
import org.concordion.api.listener.DocumentParsingListener;
import org.concordion.api.listener.SpecificationProcessingEvent;
import org.concordion.api.listener.SpecificationProcessingListener;
import org.concordion.internal.util.Check;

public class StylesheetLinker
implements DocumentParsingListener,
SpecificationProcessingListener {
    private final Resource stylesheetResource;
    private Element link;

    public StylesheetLinker(Resource stylesheetResource) {
        this.stylesheetResource = stylesheetResource;
    }

    public void beforeParsing(Document document) {
        Element html = document.getRootElement();
        Element head = html.getFirstChildElement("head");
        Check.notNull(head, "<head> section is missing from document", new Object[0]);
        this.link = new Element("link");
        this.link.addAttribute(new Attribute("type", "text/css"));
        this.link.addAttribute(new Attribute("rel", "stylesheet"));
        head.appendChild((Node)this.link);
    }

    public void beforeProcessingSpecification(SpecificationProcessingEvent event) {
        Resource resource = event.getResource();
        this.link.addAttribute(new Attribute("href", resource.getRelativePath(this.stylesheetResource)));
    }

    public void afterProcessingSpecification(SpecificationProcessingEvent event) {
    }
}

