/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.listener;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.concordion.api.Resource;
import org.concordion.api.listener.DocumentParsingListener;
import org.concordion.api.listener.SpecificationProcessingEvent;
import org.concordion.api.listener.SpecificationProcessingListener;
import org.concordion.internal.util.Check;

public class JavaScriptLinker
implements DocumentParsingListener,
SpecificationProcessingListener {
    private final Resource javaScriptResource;
    private Element script;

    public JavaScriptLinker(Resource javaScriptResource) {
        this.javaScriptResource = javaScriptResource;
    }

    public void beforeParsing(Document document) {
        Element html = document.getRootElement();
        Element head = html.getFirstChildElement("head");
        Check.notNull(head, "<head> section is missing from document", new Object[0]);
        this.script = new Element("script");
        this.script.addAttribute(new Attribute("type", "text/javascript"));
        this.script.appendChild("");
        head.appendChild((Node)this.script);
    }

    public void beforeProcessingSpecification(SpecificationProcessingEvent event) {
        Resource resource = event.getResource();
        this.script.addAttribute(new Attribute("src", resource.getRelativePath(this.javaScriptResource)));
    }

    public void afterProcessingSpecification(SpecificationProcessingEvent event) {
    }
}

