/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.concordion.api.extension.ConcordionExtension;
import org.concordion.api.extension.ConcordionExtensionFactory;
import org.concordion.api.extension.Extension;
import org.concordion.api.extension.Extensions;
import org.concordion.internal.ConcordionBuilder;
import org.concordion.internal.extension.ExtensionInitialisationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixtureExtensionLoader {
    public void addExtensions(Object fixture, ConcordionBuilder concordionBuilder) {
        for (ConcordionExtension concordionExtension : this.getExtensionsForFixture(fixture)) {
            concordionExtension.addTo(concordionBuilder);
        }
    }

    public List<ConcordionExtension> getExtensionsForFixture(Object fixture) {
        ArrayList<ConcordionExtension> extensions = new ArrayList<ConcordionExtension>();
        List<Class<?>> classes = this.getClassHierarchyParentFirst(fixture.getClass());
        for (Class<?> class1 : classes) {
            extensions.addAll(this.getExtensionsFromClassAnnotation(class1));
            extensions.addAll(this.getExtensionsFromAnnotatedFields(fixture, class1));
        }
        return extensions;
    }

    private Collection<? extends ConcordionExtension> getExtensionsFromClassAnnotation(Class<?> class1) {
        if (class1.isAnnotationPresent(Extensions.class)) {
            Class<?>[] value;
            ArrayList<ConcordionExtension> extensions = new ArrayList<ConcordionExtension>();
            Extensions extensionsAnnotation = class1.getAnnotation(Extensions.class);
            for (Class<?> class2 : value = extensionsAnnotation.value()) {
                if (ConcordionExtension.class.isAssignableFrom(class2)) {
                    ConcordionExtension extension = (ConcordionExtension)this.newInstance(class2, "extension");
                    extensions.add(extension);
                    continue;
                }
                if (ConcordionExtensionFactory.class.isAssignableFrom(class2)) {
                    ConcordionExtensionFactory factory = (ConcordionExtensionFactory)this.newInstance(class2, "extension factory");
                    extensions.add(factory.createExtension());
                    continue;
                }
                throw new ExtensionInitialisationException(String.format("Class %s specified in @Extensions annotation in class %s must implement %s or %s", class2.getCanonicalName(), class1.getCanonicalName(), ConcordionExtension.class.getCanonicalName(), ConcordionExtensionFactory.class.getCanonicalName()));
            }
            return extensions;
        }
        return Collections.emptyList();
    }

    private Object newInstance(Class<?> type, String description) {
        Object object;
        try {
            object = type.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionInitialisationException(String.format("Unable to instantiate %s of class %s", description, type.getCanonicalName()), e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionInitialisationException(String.format("Unable to access no-args constructor of %s class %s", description, type.getCanonicalName()), e);
        }
        return object;
    }

    private List<ConcordionExtension> getExtensionsFromAnnotatedFields(Object fixture, Class<?> class1) {
        Field[] declaredFields;
        ArrayList<ConcordionExtension> extensions = new ArrayList<ConcordionExtension>();
        for (Field field : declaredFields = class1.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Extension.class)) continue;
            this.validatePublic(field);
            ConcordionExtension extension = this.getExtensionField(fixture, field);
            this.validateNonNull(field, extension);
            extensions.add(extension);
        }
        return extensions;
    }

    private List<Class<?>> getClassHierarchyParentFirst(Class<?> class1) {
        ArrayList classes = new ArrayList();
        for (Class<?> current = class1; current != null && current != Object.class; current = current.getSuperclass()) {
            classes.add(current);
        }
        Collections.reverse(classes);
        return classes;
    }

    private ConcordionExtension getExtensionField(Object fixture, Field field) {
        try {
            return (ConcordionExtension)field.get(fixture);
        }
        catch (ClassCastException e) {
            throw new ExtensionInitialisationException("Extension field '" + field.getName() + "' must implement org.concordion.api.extension.ConcordionExtension");
        }
        catch (IllegalArgumentException e) {
            throw new ExtensionInitialisationException("Defect - this exception should not occur. Please report to Concordion issues list.", e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionInitialisationException("Defect - this exception should not occur. Please report to Concordion issues list.", e);
        }
    }

    private void validatePublic(Field field) {
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new ExtensionInitialisationException("Extension field '" + field.getName() + "' must be public");
        }
    }

    private void validateNonNull(Field field, ConcordionExtension extension) {
        if (extension == null) {
            throw new ExtensionInitialisationException("Extension field '" + field.getName() + "' must be non-null");
        }
    }
}

