/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import java.lang.reflect.Method;
import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.Runner;
import org.concordion.api.listener.RunFailureEvent;
import org.concordion.api.listener.RunIgnoreEvent;
import org.concordion.api.listener.RunListener;
import org.concordion.api.listener.RunSuccessEvent;
import org.concordion.api.listener.ThrowableCaughtEvent;
import org.concordion.internal.FailFastException;
import org.concordion.internal.runner.DefaultConcordionRunner;
import org.concordion.internal.util.Announcer;
import org.concordion.internal.util.Check;

public class RunCommand
extends AbstractCommand {
    private Announcer<RunListener> listeners = Announcer.to(RunListener.class);

    public void addRunListener(RunListener runListener) {
        this.listeners.addListener(runListener);
    }

    public void removeRunListener(RunListener runListener) {
        this.listeners.removeListener(runListener);
    }

    public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Check.isFalse(commandCall.hasChildCommands(), "Nesting commands inside an 'run' is not supported", new Object[0]);
        Element element = commandCall.getElement();
        String href = element.getAttributeValue("href");
        Check.notNull(href, "The 'href' attribute must be set for an element containing concordion:run", new Object[0]);
        String runnerType = commandCall.getExpression();
        String expression = element.getAttributeValue("concordion:params");
        if (expression != null) {
            evaluator.evaluate(expression);
        }
        String concordionRunner = null;
        concordionRunner = System.getProperty("concordion.runner." + runnerType);
        if (concordionRunner == null && "concordion".equals(runnerType)) {
            concordionRunner = DefaultConcordionRunner.class.getName();
        }
        if (concordionRunner == null) {
            try {
                Class.forName(runnerType);
                concordionRunner = runnerType;
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
        }
        Check.notNull(concordionRunner, "The runner '" + runnerType + "' cannot be found. " + "Choices: (1) Use 'concordion' as your runner (2) Ensure that the 'concordion.runner." + runnerType + "' System property is set to a name of an org.concordion.Runner implementation " + "(3) Specify a full class name of an org.concordion.Runner implementation", new Object[0]);
        try {
            Class<?> clazz = Class.forName(concordionRunner);
            Runner runner = (Runner)clazz.newInstance();
            for (Method method : runner.getClass().getMethods()) {
                String methodName = method.getName();
                if (!methodName.startsWith("set") || methodName.length() <= 3 || method.getParameterTypes().length != 1) continue;
                String variableName = methodName.substring(3, 4).toLowerCase() + method.getName().substring(4);
                Object variableValue = evaluator.evaluate(variableName);
                if (variableValue == null) {
                    try {
                        variableValue = evaluator.getVariable(variableName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (variableValue == null) continue;
                try {
                    method.invoke((Object)runner, variableValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                Result result = runner.execute(commandCall.getResource(), href).getResult();
                if (result == Result.SUCCESS) {
                    this.announceSuccess(element);
                } else if (result == Result.IGNORED) {
                    this.announceIgnored(element);
                } else {
                    this.announceFailure(element);
                }
                resultRecorder.record(result);
            }
            catch (FailFastException e) {
                throw e;
            }
            catch (Throwable e) {
                this.announceFailure(e, element, runnerType);
                resultRecorder.record(Result.FAILURE);
            }
        }
        catch (FailFastException e) {
            throw e;
        }
        catch (Exception e) {
            this.announceFailure(e, element, runnerType);
            resultRecorder.record(Result.FAILURE);
        }
    }

    private void announceIgnored(Element element) {
        this.listeners.announce().ignoredReported(new RunIgnoreEvent(element));
    }

    private void announceSuccess(Element element) {
        this.listeners.announce().successReported(new RunSuccessEvent(element));
    }

    private void announceFailure(Element element) {
        this.listeners.announce().failureReported(new RunFailureEvent(element));
    }

    private void announceFailure(Throwable throwable, Element element, String expression) {
        this.listeners.announce().throwableCaught(new ThrowableCaughtEvent(throwable, element, expression));
    }
}

