/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import org.concordion.api.AbstractCommandDecorator;
import org.concordion.api.Command;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.ResultRecorder;

public class LocalTextDecorator
extends AbstractCommandDecorator {
    private static final String TEXT_VARIABLE = "#TEXT";
    private static final String HREF_VARIABLE = "#HREF";

    public LocalTextDecorator(Command command) {
        super(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder, Runnable runnable) {
        Object savedTextValue = evaluator.getVariable(TEXT_VARIABLE);
        Object savedHrefValue = evaluator.getVariable(HREF_VARIABLE);
        try {
            evaluator.setVariable(TEXT_VARIABLE, commandCall.getElement().getText());
            evaluator.setVariable(HREF_VARIABLE, this.getHref(commandCall.getElement()));
            runnable.run();
        }
        finally {
            evaluator.setVariable(TEXT_VARIABLE, savedTextValue);
            evaluator.setVariable(HREF_VARIABLE, savedHrefValue);
        }
    }

    private String getHref(Element element) {
        Element a;
        String href = element.getAttributeValue("href");
        if (href == null && (a = element.getFirstChildElement("a")) != null) {
            href = a.getAttributeValue("href");
        }
        return href;
    }
}

