/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.CommandCallList;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.ExecuteEvent;
import org.concordion.api.listener.ExecuteListener;
import org.concordion.internal.Row;
import org.concordion.internal.TableSupport;
import org.concordion.internal.util.Announcer;

public class ExecuteCommand
extends AbstractCommand {
    private Announcer<ExecuteListener> listeners = Announcer.to(ExecuteListener.class);

    public void addExecuteListener(ExecuteListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeExecuteListener(ExecuteListener listener) {
        this.listeners.removeListener(listener);
    }

    public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Strategy strategy = commandCall.getElement().isNamed("table") ? new TableStrategy() : new DefaultStrategy();
        strategy.execute(commandCall, evaluator, resultRecorder);
    }

    private void announceExecuteCompleted(Element element) {
        this.listeners.announce().executeCompleted(new ExecuteEvent(element));
    }

    private class TableStrategy
    implements Strategy {
        private TableStrategy() {
        }

        public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
            Row[] detailRows;
            TableSupport tableSupport = new TableSupport(commandCall);
            for (Row detailRow : detailRows = tableSupport.getDetailRows()) {
                if (detailRow.getCells().length != tableSupport.getColumnCount()) {
                    throw new RuntimeException("The <table> 'execute' command only supports rows with an equal number of columns.");
                }
                commandCall.setElement(detailRow.getElement());
                tableSupport.copyCommandCallsTo(detailRow);
                commandCall.execute(evaluator, resultRecorder);
            }
        }
    }

    private class DefaultStrategy
    implements Strategy {
        private DefaultStrategy() {
        }

        public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
            CommandCallList childCommands = commandCall.getChildren();
            childCommands.setUp(evaluator, resultRecorder);
            evaluator.evaluate(commandCall.getExpression());
            childCommands.execute(evaluator, resultRecorder);
            ExecuteCommand.this.announceExecuteCompleted(commandCall.getElement());
            childCommands.verify(evaluator, resultRecorder);
        }
    }

    private static interface Strategy {
        public void execute(CommandCall var1, Evaluator var2, ResultRecorder var3);
    }
}

