/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.CommandCallList;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.AssertFailureEvent;
import org.concordion.api.listener.AssertListener;
import org.concordion.api.listener.AssertSuccessEvent;
import org.concordion.internal.InvalidExpressionException;
import org.concordion.internal.util.Announcer;

public abstract class BooleanCommand
extends AbstractCommand {
    private Announcer<AssertListener> listeners = Announcer.to(AssertListener.class);

    public void addAssertListener(AssertListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeAssertListener(AssertListener listener) {
        this.listeners.removeListener(listener);
    }

    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        CommandCallList childCommands = commandCall.getChildren();
        childCommands.setUp(evaluator, resultRecorder);
        childCommands.execute(evaluator, resultRecorder);
        childCommands.verify(evaluator, resultRecorder);
        String expression = commandCall.getExpression();
        Object result = evaluator.evaluate(expression);
        if (result != null && result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                this.processTrueResult(commandCall, resultRecorder);
            } else {
                this.processFalseResult(commandCall, resultRecorder);
            }
        } else {
            throw new InvalidExpressionException("Expression '" + expression + "' did not produce a boolean result (needed for assertTrue).");
        }
    }

    protected void announceSuccess(Element element) {
        this.listeners.announce().successReported(new AssertSuccessEvent(element));
    }

    protected void announceFailure(Element element, String expected, Object actual) {
        this.listeners.announce().failureReported(new AssertFailureEvent(element, expected, actual));
    }

    protected abstract void processTrueResult(CommandCall var1, ResultRecorder var2);

    protected abstract void processFalseResult(CommandCall var1, ResultRecorder var2);
}

