/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.util.ArrayList;
import org.concordion.internal.OgnlEvaluator;

public class SimpleEvaluator
extends OgnlEvaluator {
    private static String METHOD_NAME_PATTERN = "[a-z][a-zA-Z0-9_]*";
    private static String PROPERTY_NAME_PATTERN = "[a-z][a-zA-Z0-9_]*";
    private static String STRING_PATTERN = "'[^']+'";
    private static String LHS_VARIABLE_PATTERN = "#" + METHOD_NAME_PATTERN;
    private static String RHS_VARIABLE_PATTERN = "(" + LHS_VARIABLE_PATTERN + "|#TEXT|#HREF)";

    public SimpleEvaluator(Object fixture) {
        super(fixture);
    }

    public Object evaluate(String expression) {
        SimpleEvaluator.validateEvaluationExpression(expression);
        return super.evaluate(expression);
    }

    public void setVariable(String expression, Object value) {
        SimpleEvaluator.validateSetVariableExpression(expression);
        super.setVariable(expression, value);
    }

    public static void validateEvaluationExpression(String expression) {
        String METHOD_CALL_PARAMS = METHOD_NAME_PATTERN + " *\\( *" + RHS_VARIABLE_PATTERN + "(, *" + RHS_VARIABLE_PATTERN + " *)*\\)";
        String METHOD_CALL_NO_PARAMS = METHOD_NAME_PATTERN + " *\\( *\\)";
        String TERNARY_STRING_RESULT = " \\? " + STRING_PATTERN + " : " + STRING_PATTERN;
        ArrayList<String> regexs = new ArrayList<String>();
        regexs.add(PROPERTY_NAME_PATTERN);
        regexs.add(METHOD_CALL_NO_PARAMS);
        regexs.add(METHOD_CALL_PARAMS);
        regexs.add(RHS_VARIABLE_PATTERN);
        regexs.add(LHS_VARIABLE_PATTERN + "(\\." + PROPERTY_NAME_PATTERN + ")+");
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + PROPERTY_NAME_PATTERN);
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + METHOD_CALL_NO_PARAMS);
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + METHOD_CALL_PARAMS);
        regexs.add(LHS_VARIABLE_PATTERN + TERNARY_STRING_RESULT);
        regexs.add(PROPERTY_NAME_PATTERN + TERNARY_STRING_RESULT);
        regexs.add(METHOD_CALL_NO_PARAMS + TERNARY_STRING_RESULT);
        regexs.add(METHOD_CALL_PARAMS + TERNARY_STRING_RESULT);
        regexs.add(LHS_VARIABLE_PATTERN + "\\." + METHOD_CALL_NO_PARAMS);
        regexs.add(LHS_VARIABLE_PATTERN + "\\." + METHOD_CALL_PARAMS);
        expression = expression.trim();
        for (String regex : regexs) {
            if (!expression.matches(regex)) continue;
            return;
        }
        throw new RuntimeException("Invalid expression [" + expression + "]");
    }

    public static void validateSetVariableExpression(String expression) {
        ArrayList<String> regexs = new ArrayList<String>();
        regexs.add(RHS_VARIABLE_PATTERN);
        regexs.add(LHS_VARIABLE_PATTERN + "\\." + PROPERTY_NAME_PATTERN);
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + PROPERTY_NAME_PATTERN);
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + METHOD_NAME_PATTERN + " *\\( *\\)");
        regexs.add(LHS_VARIABLE_PATTERN + " *= *" + METHOD_NAME_PATTERN + " *\\( *" + RHS_VARIABLE_PATTERN + "(, *" + RHS_VARIABLE_PATTERN + " *)*\\)");
        expression = expression.trim();
        for (String regex : regexs) {
            if (!expression.matches(regex)) continue;
            return;
        }
        throw new RuntimeException("Invalid 'set' expression [" + expression + "]");
    }
}

