/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.concordion.internal.FailFastException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FixtureState {
    UNIMPLEMENTED{

        private void addToList(List<String> list, long x, String singular, String plural) {
            if (x == 1L) {
                list.add(singular);
            } else if (x > 1L) {
                list.add(plural);
            }
        }

        @Override
        public void assertIsSatisfied(long successCount, long failureCount, long exceptionCount, FailFastException ffe) {
            ArrayList<String> list = new ArrayList<String>();
            this.addToList(list, successCount, "a success", "some successes");
            this.addToList(list, failureCount, "a failure", "some failures");
            this.addToList(list, exceptionCount, "an exception", "some exceptions");
            if (list.size() > 0) {
                String s = (String)list.get(0);
                if (list.size() > 1) {
                    for (int i = 1; i < list.size() - 1; ++i) {
                        s = s + ", " + (String)list.get(i);
                    }
                    s = s + ", and " + (String)list.get(list.size() - 1);
                }
                throw new AssertionError((Object)("Specification is supposed to be unimplemented, but is reporting " + s + "."));
            }
        }

        @Override
        public void printNote(PrintStream out) {
            out.print("   <-- Note: This test has been marked as UNIMPLEMENTED");
        }
    }
    ,
    EXPECTED_TO_FAIL{

        public void assertIsSatisfied(long successCount, long failureCount, long exceptionCount, FailFastException ffe) {
            if (failureCount + exceptionCount == 0L) {
                throw new AssertionError((Object)"Specification is expected to fail but has neither failures nor exceptions.");
            }
        }

        public void printNote(PrintStream out) {
            out.print("   <-- Note: This test has been marked as EXPECTED_TO_FAIL");
        }
    }
    ,
    EXPECTED_TO_PASS{

        public void assertIsSatisfied(long successCount, long failureCount, long exceptionCount, FailFastException ffe) {
            if (ffe != null) {
                throw new AssertionError((Object)ffe);
            }
            if (failureCount > 0L) {
                throw new AssertionError((Object)"Specification has failure(s). See output HTML for details.");
            }
            if (exceptionCount > 0L) {
                throw new AssertionError((Object)"Specification has exception(s). See output HTML for details.");
            }
        }

        public void printNote(PrintStream out) {
        }
    };


    public abstract void assertIsSatisfied(long var1, long var3, long var5, FailFastException var7);

    public abstract void printNote(PrintStream var1);
}

