/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.concordion.api.Resource;
import org.concordion.api.Target;
import org.concordion.internal.FileTarget;

public class FileTargetWithSuffix
implements Target {
    private static final String PROPERTY_OUTPUT_DIR = "concordion.output.dir";
    private String suffix;
    private FileTarget target;

    public FileTargetWithSuffix(String suffix) {
        this.suffix = suffix;
        this.target = new FileTarget(this.getBaseOutputDir());
    }

    private File getBaseOutputDir() {
        String outputPath = System.getProperty(PROPERTY_OUTPUT_DIR);
        if (outputPath == null) {
            return new File(System.getProperty("java.io.tmpdir"), "concordion");
        }
        return new File(outputPath);
    }

    public void write(Resource resource, String s) throws IOException {
        this.target.write(this.rename(resource), s);
    }

    public void copyTo(Resource resource, InputStream inputStream) throws IOException {
        this.target.copyTo(this.rename(resource), inputStream);
    }

    public OutputStream getOutputStream(Resource resource) throws IOException {
        return this.target.getOutputStream(this.rename(resource));
    }

    public void delete(Resource resource) throws IOException {
        this.target.delete(this.rename(resource));
    }

    public boolean exists(Resource resource) {
        return this.target.exists(this.rename(resource));
    }

    public String resolvedPathFor(Resource resource) {
        return this.target.resolvedPathFor(this.rename(resource));
    }

    private Resource rename(Resource resource) {
        return new Resource(resource.getPath().replaceFirst("\\..*$", "\\." + this.suffix));
    }
}

