/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.concordion.api.Resource;
import org.concordion.api.Target;
import org.concordion.internal.util.Check;
import org.concordion.internal.util.IOUtil;

public class FileTarget
implements Target {
    private static final long FRESH_ENOUGH_MILLIS = 2000L;
    private final File baseDir;

    public FileTarget(File baseDir) {
        this.baseDir = baseDir;
    }

    public void copyTo(Resource resource, InputStream inputStream) throws IOException {
        Check.notNull(resource, "resource is null", new Object[0]);
        this.mkdirs(resource);
        File outputFile = this.getFile(resource);
        if (outputFile.exists() && this.isFreshEnough(outputFile)) {
            return;
        }
        IOUtil.copy(inputStream, this.createOutputStream(resource));
    }

    public void delete(Resource resource) throws IOException {
        Check.notNull(resource, "resource is null", new Object[0]);
        this.getFile(resource).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Resource resource, String s) throws IOException {
        Check.notNull(resource, "resource is null", new Object[0]);
        this.mkdirs(resource);
        BufferedWriter writer = new BufferedWriter(this.createWriter(resource, "UTF-8"));
        try {
            writer.write(s);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private OutputStreamWriter createWriter(Resource resource, String encoding) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFile(resource)), encoding);
    }

    public File getFile(Resource resource) {
        return new File(this.baseDir, resource.getPath());
    }

    public OutputStream getOutputStream(Resource resource) throws IOException {
        Check.notNull(resource, "resource is null", new Object[0]);
        this.mkdirs(resource);
        return this.createOutputStream(resource);
    }

    private OutputStream createOutputStream(Resource resource) throws FileNotFoundException {
        return new FileOutputStream(this.getFile(resource));
    }

    private void mkdirs(Resource resource) throws IOException {
        File dir = this.getFile(resource).getParentFile();
        dir.mkdirs();
    }

    private boolean isFreshEnough(File outputFile) {
        long ageInMillis = Math.abs(outputFile.lastModified() - System.currentTimeMillis());
        return ageInMillis < 2000L;
    }

    public boolean exists(Resource resource) {
        return this.getFile(resource).exists();
    }

    public String resolvedPathFor(Resource resource) {
        return this.getFile(resource).getAbsolutePath();
    }
}

