/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.concordion.Concordion;
import org.concordion.api.Command;
import org.concordion.api.EvaluatorFactory;
import org.concordion.api.FailFast;
import org.concordion.api.FullOGNL;
import org.concordion.api.Resource;
import org.concordion.api.Source;
import org.concordion.api.SpecificationLocator;
import org.concordion.api.SpecificationReader;
import org.concordion.api.Target;
import org.concordion.api.extension.ConcordionExtender;
import org.concordion.api.extension.ConcordionExtension;
import org.concordion.api.extension.ConcordionExtensionFactory;
import org.concordion.api.listener.AssertEqualsListener;
import org.concordion.api.listener.AssertFalseListener;
import org.concordion.api.listener.AssertTrueListener;
import org.concordion.api.listener.ConcordionBuildEvent;
import org.concordion.api.listener.ConcordionBuildListener;
import org.concordion.api.listener.DocumentParsingListener;
import org.concordion.api.listener.ExecuteListener;
import org.concordion.api.listener.RunListener;
import org.concordion.api.listener.SpecificationProcessingListener;
import org.concordion.api.listener.ThrowableCaughtListener;
import org.concordion.api.listener.VerifyRowsListener;
import org.concordion.internal.ClassNameBasedSpecificationLocator;
import org.concordion.internal.ClassPathSource;
import org.concordion.internal.CommandRegistry;
import org.concordion.internal.DocumentParser;
import org.concordion.internal.FileTarget;
import org.concordion.internal.OgnlEvaluatorFactory;
import org.concordion.internal.SimpleEvaluatorFactory;
import org.concordion.internal.XMLParser;
import org.concordion.internal.XMLSpecificationReader;
import org.concordion.internal.command.AssertEqualsCommand;
import org.concordion.internal.command.AssertFalseCommand;
import org.concordion.internal.command.AssertTrueCommand;
import org.concordion.internal.command.EchoCommand;
import org.concordion.internal.command.ExecuteCommand;
import org.concordion.internal.command.LocalTextDecorator;
import org.concordion.internal.command.RunCommand;
import org.concordion.internal.command.SetCommand;
import org.concordion.internal.command.SpecificationCommand;
import org.concordion.internal.command.ThrowableCatchingDecorator;
import org.concordion.internal.command.ThrowableCaughtPublisher;
import org.concordion.internal.command.VerifyRowsCommand;
import org.concordion.internal.listener.AssertResultRenderer;
import org.concordion.internal.listener.BreadcrumbRenderer;
import org.concordion.internal.listener.DocumentStructureImprover;
import org.concordion.internal.listener.JavaScriptEmbedder;
import org.concordion.internal.listener.JavaScriptLinker;
import org.concordion.internal.listener.MetadataCreator;
import org.concordion.internal.listener.PageFooterRenderer;
import org.concordion.internal.listener.RunResultRenderer;
import org.concordion.internal.listener.SpecificationExporter;
import org.concordion.internal.listener.StylesheetEmbedder;
import org.concordion.internal.listener.StylesheetLinker;
import org.concordion.internal.listener.ThrowableRenderer;
import org.concordion.internal.listener.VerifyRowsResultRenderer;
import org.concordion.internal.util.Announcer;
import org.concordion.internal.util.Check;
import org.concordion.internal.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordionBuilder
implements ConcordionExtender {
    private Announcer<ConcordionBuildListener> listeners = Announcer.to(ConcordionBuildListener.class);
    public static final String NAMESPACE_CONCORDION_2007 = "http://www.concordion.org/2007/concordion";
    private static final String PROPERTY_OUTPUT_DIR = "concordion.output.dir";
    private static final String PROPERTY_EXTENSIONS = "concordion.extensions";
    private static final String EMBEDDED_STYLESHEET_RESOURCE = "/org/concordion/internal/resource/embedded.css";
    private SpecificationLocator specificationLocator = new ClassNameBasedSpecificationLocator();
    private Source source = new ClassPathSource();
    private Target target = null;
    private CommandRegistry commandRegistry = new CommandRegistry();
    private DocumentParser documentParser = new DocumentParser(this.commandRegistry);
    private SpecificationReader specificationReader;
    private EvaluatorFactory evaluatorFactory = new SimpleEvaluatorFactory();
    private SpecificationCommand specificationCommand = new SpecificationCommand();
    private AssertEqualsCommand assertEqualsCommand = new AssertEqualsCommand();
    private AssertTrueCommand assertTrueCommand = new AssertTrueCommand();
    private AssertFalseCommand assertFalseCommand = new AssertFalseCommand();
    private ExecuteCommand executeCommand = new ExecuteCommand();
    private RunCommand runCommand = new RunCommand();
    private VerifyRowsCommand verifyRowsCommand = new VerifyRowsCommand();
    private EchoCommand echoCommand = new EchoCommand();
    private File baseOutputDir;
    private ThrowableCaughtPublisher throwableListenerPublisher = new ThrowableCaughtPublisher();
    private LinkedHashMap<String, Resource> resourceToCopyMap = new LinkedHashMap();
    private List<SpecificationProcessingListener> specificationProcessingListeners = new ArrayList<SpecificationProcessingListener>();
    private List<Class<? extends Throwable>> failFastExceptions = Collections.emptyList();
    private boolean builtAlready;

    public ConcordionBuilder() {
        this.withThrowableListener(new ThrowableRenderer());
        this.commandRegistry.register("", "specification", this.specificationCommand);
        AssertResultRenderer assertRenderer = new AssertResultRenderer();
        this.withAssertEqualsListener(assertRenderer);
        this.withAssertTrueListener(assertRenderer);
        this.withAssertFalseListener(assertRenderer);
        this.withVerifyRowsListener(new VerifyRowsResultRenderer());
        this.withRunListener(new RunResultRenderer());
        this.withDocumentParsingListener(new DocumentStructureImprover());
        this.withDocumentParsingListener(new MetadataCreator());
        String stylesheetContent = IOUtil.readResourceAsString(EMBEDDED_STYLESHEET_RESOURCE);
        this.withEmbeddedCSS(stylesheetContent);
    }

    @Override
    public ConcordionBuilder withSource(Source source) {
        this.source = source;
        return this;
    }

    @Override
    public ConcordionBuilder withTarget(Target target) {
        this.target = target;
        return this;
    }

    @Override
    public ConcordionBuilder withSpecificationLocator(SpecificationLocator specificationLocator) {
        this.specificationLocator = specificationLocator;
        return this;
    }

    public ConcordionBuilder withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
        return this;
    }

    @Override
    public ConcordionBuilder withThrowableListener(ThrowableCaughtListener throwableListener) {
        this.throwableListenerPublisher.addThrowableListener(throwableListener);
        return this;
    }

    @Override
    public ConcordionBuilder withAssertEqualsListener(AssertEqualsListener listener) {
        this.assertEqualsCommand.addAssertEqualsListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withAssertTrueListener(AssertTrueListener listener) {
        this.assertTrueCommand.addAssertListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withAssertFalseListener(AssertFalseListener listener) {
        this.assertFalseCommand.addAssertListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withVerifyRowsListener(VerifyRowsListener listener) {
        this.verifyRowsCommand.addVerifyRowsListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withRunListener(RunListener listener) {
        this.runCommand.addRunListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withExecuteListener(ExecuteListener listener) {
        this.executeCommand.addExecuteListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withDocumentParsingListener(DocumentParsingListener listener) {
        this.documentParser.addDocumentParsingListener(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withSpecificationProcessingListener(SpecificationProcessingListener listener) {
        this.specificationProcessingListeners.add(listener);
        return this;
    }

    @Override
    public ConcordionBuilder withBuildListener(ConcordionBuildListener listener) {
        this.listeners.addListener(listener);
        return this;
    }

    private ConcordionBuilder withApprovedCommand(String namespaceURI, String commandName, Command command) {
        ThrowableCatchingDecorator throwableCatchingDecorator = new ThrowableCatchingDecorator(new LocalTextDecorator(command), this.failFastExceptions);
        throwableCatchingDecorator.addThrowableListener(this.throwableListenerPublisher);
        ThrowableCatchingDecorator decoratedCommand = throwableCatchingDecorator;
        this.commandRegistry.register(namespaceURI, commandName, decoratedCommand);
        return this;
    }

    @Override
    public ConcordionBuilder withCommand(String namespaceURI, String commandName, Command command) {
        Check.notEmpty(namespaceURI, "Namespace URI is mandatory", new Object[0]);
        Check.notEmpty(commandName, "Command name is mandatory", new Object[0]);
        Check.notNull(command, "Command is null", new Object[0]);
        Check.isFalse(namespaceURI.contains("concordion.org"), "The namespace URI for user-contributed command '" + commandName + "' " + "must not contain 'concordion.org'. Use your own domain name instead.", new Object[0]);
        return this.withApprovedCommand(namespaceURI, commandName, command);
    }

    @Override
    public ConcordionBuilder withResource(String sourcePath, Resource targetResource) {
        this.resourceToCopyMap.put(sourcePath, targetResource);
        return this;
    }

    @Override
    public ConcordionBuilder withEmbeddedCSS(String css) {
        StylesheetEmbedder embedder = new StylesheetEmbedder(css);
        this.withDocumentParsingListener(embedder);
        return this;
    }

    @Override
    public ConcordionBuilder withLinkedCSS(String cssPath, Resource targetResource) {
        this.withResource(cssPath, targetResource);
        StylesheetLinker cssLinker = new StylesheetLinker(targetResource);
        this.withDocumentParsingListener(cssLinker);
        this.withSpecificationProcessingListener(cssLinker);
        return this;
    }

    @Override
    public ConcordionBuilder withEmbeddedJavaScript(String javaScript) {
        JavaScriptEmbedder embedder = new JavaScriptEmbedder(javaScript);
        this.withDocumentParsingListener(embedder);
        return this;
    }

    @Override
    public ConcordionBuilder withLinkedJavaScript(String jsPath, Resource targetResource) {
        this.withResource(jsPath, targetResource);
        JavaScriptLinker javaScriptLinker = new JavaScriptLinker(targetResource);
        this.withDocumentParsingListener(javaScriptLinker);
        this.withSpecificationProcessingListener(javaScriptLinker);
        return this;
    }

    public Concordion build() {
        Check.isFalse(this.builtAlready, "ConcordionBuilder currently does not support calling build() twice", new Object[0]);
        this.builtAlready = true;
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "run", this.runCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "execute", this.executeCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "set", new SetCommand());
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "assertEquals", this.assertEqualsCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "assertTrue", this.assertTrueCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "assertFalse", this.assertFalseCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "verifyRows", this.verifyRowsCommand);
        this.withApprovedCommand(NAMESPACE_CONCORDION_2007, "echo", this.echoCommand);
        if (this.target == null) {
            this.target = new FileTarget(this.getBaseOutputDir());
        }
        XMLParser xmlParser = new XMLParser();
        this.specificationCommand.addSpecificationListener(new BreadcrumbRenderer(this.source, xmlParser));
        this.specificationCommand.addSpecificationListener(new PageFooterRenderer(this.target));
        this.specificationReader = new XMLSpecificationReader(this.source, xmlParser, this.documentParser);
        this.addExtensions();
        this.copyResources();
        this.addSpecificationListeners();
        this.specificationCommand.addSpecificationListener(new SpecificationExporter(this.target));
        this.listeners.announce().concordionBuilt(new ConcordionBuildEvent(this.target));
        return new Concordion(this.specificationLocator, this.specificationReader, this.evaluatorFactory);
    }

    private void addSpecificationListeners() {
        for (SpecificationProcessingListener listener : this.specificationProcessingListeners) {
            this.specificationCommand.addSpecificationListener(listener);
        }
    }

    private void copyResources() {
        for (Map.Entry<String, Resource> resourceToCopy : this.resourceToCopyMap.entrySet()) {
            String sourcePath = resourceToCopy.getKey();
            Resource targetResource = resourceToCopy.getValue();
            try {
                InputStream inputStream = this.source.createInputStream(new Resource(sourcePath));
                this.target.copyTo(targetResource, inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy " + sourcePath + " to target " + targetResource, e);
            }
        }
    }

    private void addExtensions() {
        String extensionProp = System.getProperty(PROPERTY_EXTENSIONS);
        if (extensionProp != null) {
            String[] extensions;
            for (String className : extensions = extensionProp.split("\\s*,\\s*")) {
                this.addExtension(className);
            }
        }
    }

    private void addExtension(String className) {
        ConcordionExtension extension;
        Object extensionObject;
        Class<?> extensionClass;
        try {
            extensionClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find extension '" + className + "' on classpath", e);
        }
        try {
            extensionObject = extensionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate extension '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Extension '" + className + "' or constructor are inaccessible", e);
        }
        try {
            extension = (ConcordionExtension)extensionObject;
        }
        catch (ClassCastException e) {
            try {
                ConcordionExtensionFactory factory = (ConcordionExtensionFactory)extensionObject;
                extension = factory.createExtension();
            }
            catch (ClassCastException e1) {
                String message = String.format("Extension class '%s' must implement '%s' or '%s'", className, ConcordionExtension.class.getName(), ConcordionExtensionFactory.class.getName());
                throw new RuntimeException(message);
            }
        }
        extension.addTo(this);
    }

    private File getBaseOutputDir() {
        if (this.baseOutputDir != null) {
            return this.baseOutputDir;
        }
        String outputPath = System.getProperty(PROPERTY_OUTPUT_DIR);
        if (outputPath == null) {
            return new File(System.getProperty("java.io.tmpdir"), "concordion");
        }
        return new File(outputPath);
    }

    public ConcordionBuilder withFailFast(Class<? extends Throwable>[] failFastExceptions) {
        this.failFastExceptions = Arrays.asList(failFastExceptions);
        return this;
    }

    public ConcordionBuilder withFixture(Object fixture) {
        if (fixture.getClass().isAnnotationPresent(FailFast.class)) {
            FailFast failFastAnnotation = fixture.getClass().getAnnotation(FailFast.class);
            Class<? extends Throwable>[] failFastExceptions = failFastAnnotation.onExceptionType();
            this.withFailFast(failFastExceptions);
        }
        if (fixture.getClass().isAnnotationPresent(FullOGNL.class)) {
            this.withEvaluatorFactory(new OgnlEvaluatorFactory());
        }
        return this;
    }
}

