/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.integration.junit4;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.concordion.api.ResultSummary;
import org.concordion.internal.FixtureRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordionRunner
extends BlockJUnit4ClassRunner {
    private final Description fixtureDescription;
    private final FrameworkMethod fakeMethod;
    private ResultSummary result;

    public ConcordionRunner(Class<?> fixtureClass) throws InitializationError {
        super(fixtureClass);
        String testDescription = ("[Concordion Specification for '" + fixtureClass.getSimpleName()).replaceAll("Test$", "']");
        this.fixtureDescription = Description.createTestDescription(fixtureClass, (String)testDescription);
        try {
            this.fakeMethod = new FakeFrameworkMethod();
        }
        catch (Exception e) {
            throw new InitializationError("Failed to initialize ConcordionRunner");
        }
    }

    protected List<FrameworkMethod> getChildren() {
        ArrayList<FrameworkMethod> children = new ArrayList<FrameworkMethod>();
        children.addAll(super.getChildren());
        children.add(this.fakeMethod);
        return children;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (method == this.fakeMethod) {
            return this.specExecStatement(test);
        }
        return super.methodInvoker(method, test);
    }

    protected Description describeChild(FrameworkMethod method) {
        if (method == this.fakeMethod) {
            return this.fixtureDescription;
        }
        return super.describeChild(method);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
        if (this.result != null && this.result.getIgnoredCount() > 0L) {
            notifier.fireTestIgnored(this.fixtureDescription);
        }
    }

    protected Statement specExecStatement(final Object fixture) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ConcordionRunner.this.result = new FixtureRunner().run(fixture);
            }
        };
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FakeFrameworkMethod
    extends FrameworkMethod {
        public FakeFrameworkMethod() {
            super(null);
        }

        public String getName() {
            return "[Concordion Specification]";
        }

        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return null;
        }

        public int hashCode() {
            return 1;
        }
    }
}

