/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.api;

import org.concordion.internal.util.Check;

public final class Resource {
    private final String path;
    private final String[] parts;
    private final String name;
    private final boolean isPackage;

    public Resource(String path) {
        path = path.replaceAll("\\\\", "/");
        Check.isTrue(path.startsWith("/"), "Internal error: Resource path should start with a slash", new Object[0]);
        this.path = path;
        this.isPackage = this.endsWithSlash(path);
        this.parts = path.split("/");
        this.name = this.parts.length == 0 ? "" : this.parts[this.parts.length - 1];
    }

    public String getPath() {
        return this.path;
    }

    private boolean isPackage() {
        return this.isPackage;
    }

    private boolean endsWithSlash(String s) {
        return s.endsWith("/");
    }

    private Resource getPackage() {
        if (this.isPackage()) {
            return this;
        }
        return this.getParent();
    }

    public Resource getParent() {
        if (this.getPath().equals("/")) {
            return null;
        }
        String parentPath = "/";
        for (int i = 1; i < this.parts.length - 1; ++i) {
            parentPath = parentPath + this.parts[i] + "/";
        }
        return new Resource(parentPath);
    }

    public String getRelativePath(Resource resource) {
        int i;
        if (resource.getPath().equals(this.path)) {
            return this.name;
        }
        String[] therePieces = resource.getPathPieces();
        String[] herePieces = this.getPathPieces();
        int sharedPiecesCount = 0;
        for (int i2 = 0; i2 < herePieces.length && therePieces.length > i2 && therePieces[i2].equals(herePieces[i2]); ++i2) {
            ++sharedPiecesCount;
        }
        String r = "";
        for (i = sharedPiecesCount; i < herePieces.length; ++i) {
            r = r + "../";
        }
        for (i = sharedPiecesCount; i < therePieces.length; ++i) {
            r = r + therePieces[i] + "/";
        }
        if (resource.isPackage()) {
            return r;
        }
        return r + resource.getName();
    }

    private String[] getPathPieces() {
        String packagePath = this.getPackage().getPath();
        if ("/".equals(packagePath)) {
            return new String[]{""};
        }
        return packagePath.split("/");
    }

    public String getName() {
        return this.name;
    }

    public Resource getRelativeResource(String relativePath) {
        Check.isFalse(relativePath.startsWith("/"), "Relative path should not start with a slash", new Object[0]);
        String subPath = this.removeAnyLeadingDotSlashFrom(relativePath);
        Resource p = this.getPackage();
        while (subPath.startsWith("../")) {
            if ((p = p.getParent()) == null) {
                throw new RuntimeException("Path '" + relativePath + "' relative to '" + this.getPath() + "' " + "evaluates above the root package.");
            }
            subPath = subPath.replaceFirst("../", "");
        }
        Check.isFalse(subPath.contains("../"), "The ../ operator is currently only supported at the start of expressions", new Object[0]);
        return new Resource(p.getPath() + subPath);
    }

    private String removeAnyLeadingDotSlashFrom(String subPath) {
        return subPath.replaceFirst("^\\./", "");
    }

    public String toString() {
        return "[Resource: " + this.path + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

