/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.Icon;

public class SelectionIcon
implements Icon {
    private static int TOLERANCE = 56;
    private static int TOTAL_TOLERANCE = 2 * TOLERANCE;
    private static float TINT = 0.2f;
    private Icon icon;
    private Color fg;
    private Color bg;
    private Color sfg;
    private Color sbg;
    private Composite composite;

    public static void setTolerance(int tol) {
        TOLERANCE = tol;
    }

    public static int getTolerance() {
        return TOLERANCE;
    }

    public static void setTint(float tint) {
        TINT = tint;
    }

    public static float getTint() {
        return TINT;
    }

    public SelectionIcon(Icon icon, Color fg, Color bg, Color sfg, Color sbg) {
        if (fg == null) {
            throw new NullPointerException("Foreground may not be null");
        }
        if (bg == null) {
            throw new NullPointerException("Background may not be null");
        }
        if (sfg == null) {
            throw new NullPointerException("Selection foreground may not be null");
        }
        if (sbg == null) {
            throw new NullPointerException("Selection Background may not be null");
        }
        this.fg = fg;
        this.bg = bg;
        this.sfg = sfg;
        this.sbg = sbg;
        this.icon = icon;
        this.composite = new CustomComposite();
    }

    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    public String toString() {
        return this.icon.toString() + " (selection)";
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        BufferedImage image = c == null ? new BufferedImage(w, h, 2) : c.getGraphicsConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, w, h);
        if (!this.sfg.equals(this.fg)) {
            graphics.setComposite(this.composite);
        }
        graphics.translate(-x, -y);
        this.icon.paintIcon(c, graphics, x, y);
        g.drawImage(image, x, y, c);
    }

    private class CustomComposite
    implements Composite {
        private CustomComposite() {
        }

        public CompositeContext createContext(final ColorModel srcCM, ColorModel dstCM, RenderingHints hints) {
            return new CompositeContext(){

                private boolean near(Color c1, Color c2, int tol) {
                    int dr = Math.abs(c1.getRed() - c2.getRed());
                    int dg = Math.abs(c1.getGreen() - c2.getGreen());
                    int db = Math.abs(c1.getBlue() - c2.getBlue());
                    return dr < TOLERANCE && dg < TOLERANCE && db < TOLERANCE && dr + dg + db < TOTAL_TOLERANCE;
                }

                private int mix(int base, int tint, float pct) {
                    return (int)(pct * (float)base + (1.0f - pct) * (float)tint);
                }

                public void dispose() {
                }

                public void compose(Raster src, Raster dst, WritableRaster out) {
                    int[] pout = new int[4];
                    int w = Math.min(src.getWidth(), out.getWidth());
                    int h = Math.min(src.getHeight(), out.getHeight());
                    int xs = src.getMinX();
                    int ys = src.getMinY();
                    for (int x = 0; x < w; ++x) {
                        for (int y = 0; y < h; ++y) {
                            Object pixel = src.getDataElements(xs + x, ys + y, null);
                            int alpha = srcCM.getAlpha(pixel);
                            if (alpha == 0) continue;
                            pout[0] = srcCM.getRed(pixel);
                            pout[1] = srcCM.getGreen(pixel);
                            pout[2] = srcCM.getBlue(pixel);
                            pout[3] = alpha;
                            Color color = new Color(pout[0], pout[1], pout[2], pout[3]);
                            if (this.near(color, SelectionIcon.this.fg, TOLERANCE) || this.near(color, SelectionIcon.this.sbg, TOLERANCE)) {
                                pout[0] = SelectionIcon.this.sfg.getRed();
                                pout[1] = SelectionIcon.this.sfg.getGreen();
                                pout[2] = SelectionIcon.this.sfg.getBlue();
                            } else if (this.near(color, SelectionIcon.this.bg, TOLERANCE)) {
                                pout[0] = SelectionIcon.this.sbg.getRed();
                                pout[1] = SelectionIcon.this.sbg.getGreen();
                                pout[2] = SelectionIcon.this.sbg.getBlue();
                            } else {
                                pout[0] = this.mix(SelectionIcon.this.sbg.getRed(), pout[0], TINT);
                                pout[1] = this.mix(SelectionIcon.this.sbg.getGreen(), pout[1], TINT);
                                pout[2] = this.mix(SelectionIcon.this.sbg.getBlue(), pout[2], TINT);
                            }
                            out.setPixel(out.getMinX() + x, out.getMinY() + y, pout);
                        }
                    }
                }
            };
        }
    }
}

