/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class ScaledIcon
implements Icon {
    private final Icon icon;
    private int width;
    private int height;
    private boolean preserveAspect;

    public ScaledIcon(Icon icon) {
        this(icon, icon.getIconWidth(), icon.getIconHeight());
    }

    public ScaledIcon(Icon icon, int width, int height) {
        this(icon, width, height, true);
    }

    public ScaledIcon(Icon icon, int width, int height, boolean preserveAspect) {
        this.icon = icon;
        this.preserveAspect = preserveAspect;
        this.setSize(width, height);
    }

    public void setPreserveAspect(boolean p) {
        this.preserveAspect = p;
    }

    public void setSize(Dimension size) {
        this.setSize(size.width, size.height);
    }

    public void setSize(int w, int h) {
        if (this.preserveAspect) {
            double requested = (double)w / (double)h;
            double required = (double)this.icon.getIconWidth() / (double)this.icon.getIconHeight();
            if (requested < required) {
                h = Math.max(1, (int)((double)w / required));
            } else if (requested > required) {
                w = Math.max(1, (int)((double)h * required));
            }
        }
        this.width = w;
        this.height = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints oldHints = g2d.getRenderingHints();
        AffineTransform oldTransform = g2d.getTransform();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double xscale = (double)this.getIconWidth() / (double)this.icon.getIconWidth();
        double yscale = (double)this.getIconHeight() / (double)this.icon.getIconHeight();
        g2d.translate(x, y);
        g2d.scale(xscale, yscale);
        try {
            this.icon.paintIcon(c, g, 0, 0);
        }
        finally {
            g2d.setTransform(oldTransform);
            g2d.setRenderingHints(oldHints);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

