/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.AbstractComponentDecorator;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GhostedDragImage
extends AbstractComponentDecorator {
    private Icon icon;
    private Point origin;
    private Point location;
    private Point imageOffset;
    private List ghosts = new ArrayList();
    private Component dragSource;
    private float ghostAlpha = 0.5f;
    private static final int CURSOR_SIZE = 32;
    private static final int SLIDE_INTERVAL = 41;

    public GhostedDragImage(JComponent dragSource, Point screenLocation, Icon icon, Point imageOffset) {
        this(dragSource, dragSource.getRootPane().getLayeredPane(), screenLocation, icon, imageOffset, true);
    }

    protected GhostedDragImage(JComponent dragSource, JLayeredPane root, Point screenLocation, Icon icon, Point imageOffset, boolean trackFrames) {
        super(root);
        this.dragSource = dragSource;
        this.icon = icon;
        this.imageOffset = imageOffset;
        Point loc = root.getLocationOnScreen();
        this.setLocation(screenLocation.x - loc.x + imageOffset.x, screenLocation.y - loc.y + imageOffset.y);
        if (trackFrames) {
            RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, root));
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                Frame frame = frames[i];
                if (!(frame instanceof RootPaneContainer) || !frame.isShowing() || frame == rpc) continue;
                JLayeredPane p = ((RootPaneContainer)((Object)frame)).getLayeredPane();
                GhostedDragImage slave = new GhostedDragImage(dragSource, p, screenLocation, icon, imageOffset, false);
                this.ghosts.add(slave);
                slave.move(screenLocation);
            }
        }
    }

    public void setAlpha(float alpha) {
        this.ghostAlpha = alpha;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Iterator i = this.ghosts.iterator();
        while (i.hasNext()) {
            GhostedDragImage slave = (GhostedDragImage)i.next();
            slave.setCursor(cursor);
        }
    }

    public void dispose() {
        this.location = this.origin;
        super.dispose();
        Iterator i = this.ghosts.iterator();
        while (i.hasNext()) {
            GhostedDragImage slave = (GhostedDragImage)i.next();
            slave.dispose();
        }
    }

    private void setLocation(int x, int y) {
        this.location = SwingUtilities.convertPoint(this.getComponent(), x, y, this.dragSource);
        if (this.origin == null) {
            this.origin = this.location;
        }
        this.setDecorationBounds(x, y, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    protected Rectangle clipDecorationBounds(Rectangle decorated) {
        decorated.x -= 32;
        decorated.y -= 32;
        decorated.width += 64;
        decorated.height += 64;
        return super.clipDecorationBounds(decorated);
    }

    public void move(Point screen) {
        Point loc = this.getComponent().getLocationOnScreen();
        this.setLocation(screen.x - loc.x + this.imageOffset.x, screen.y - loc.y + this.imageOffset.y);
        Iterator i = this.ghosts.iterator();
        while (i.hasNext()) {
            GhostedDragImage g = (GhostedDragImage)i.next();
            g.move(screen);
        }
    }

    public void paint(Graphics graphics) {
        Rectangle r = this.getDecorationBounds();
        Graphics2D g = (Graphics2D)graphics.create();
        g.setComposite(AlphaComposite.getInstance(3, this.ghostAlpha));
        g.translate(32, 32);
        this.icon.paintIcon(this.getPainter(), g, r.x, r.y);
        g.dispose();
    }

    public void returnToOrigin() {
        this.setCursor(null);
        final Timer timer = new Timer(41, null);
        timer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int dx = (((GhostedDragImage)GhostedDragImage.this).origin.x - ((GhostedDragImage)GhostedDragImage.this).location.x) / 2;
                int dy = (((GhostedDragImage)GhostedDragImage.this).origin.y - ((GhostedDragImage)GhostedDragImage.this).location.y) / 2;
                if (dx != 0 || dy != 0) {
                    Point loc = GhostedDragImage.this.dragSource.getLocationOnScreen();
                    Point where = new Point(loc.x + ((GhostedDragImage)GhostedDragImage.this).location.x + dx - ((GhostedDragImage)GhostedDragImage.this).imageOffset.x, loc.y + ((GhostedDragImage)GhostedDragImage.this).location.y + dy - ((GhostedDragImage)GhostedDragImage.this).imageOffset.y);
                    GhostedDragImage.this.move(where);
                } else {
                    timer.stop();
                    GhostedDragImage.this.dispose();
                }
            }
        });
        timer.start();
    }
}

