/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.AbstractComponentDecorator;
import furbelow.ComponentIcon;
import furbelow.DragHandler;
import furbelow.DropHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FancyDrop {
    public static void main(String[] args) {
        JFrame dragFrame = new JFrame("Fancy Drops");
        JPanel p = (JPanel)dragFrame.getContentPane();
        final JLabel label = new JLabel("Drag Me");
        Font font = label.getFont();
        label.setForeground(Color.green.darker());
        label.setHorizontalAlignment(0);
        label.setFont(font.deriveFont(1, font.getSize() * 2));
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        new DragHandler(label, 1){

            protected Transferable getTransferable(DragGestureEvent e) {
                return new StringSelection(label.getText());
            }

            protected Icon getDragIcon(DragGestureEvent e, Point offset) {
                return new ComponentIcon(label, true);
            }
        };
        DataFlavor[] acceptableFlavors = new DataFlavor[]{DataFlavor.stringFlavor};
        final JList list = new JList();
        list.setFont(label.getFont());
        new DropHandler(list, 1, acceptableFlavors){
            private AbstractComponentDecorator dropArea;

            protected void drop(DropTargetDropEvent e, int action) throws UnsupportedFlavorException, IOException {
                final ArrayList<Object> data = new ArrayList<Object>();
                for (int i = 0; i < list.getModel().getSize(); ++i) {
                    data.add(list.getModel().getElementAt(i));
                }
                data.add(e.getTransferable().getTransferData(DataFlavor.stringFlavor));
                list.setModel(new AbstractListModel(){

                    public int getSize() {
                        return data.size();
                    }

                    public Object getElementAt(int index) {
                        return data.get(index);
                    }
                });
            }

            protected void paintDropTarget(DropTargetEvent e, int action, Point location) {
                if (action != 0 && location != null) {
                    int count;
                    if (this.dropArea == null) {
                        this.dropArea = new Marquee(list);
                    }
                    if ((count = list.getModel().getSize()) == 0) {
                        Dimension size = list.getSize();
                        this.dropArea.setDecorationBounds(new Rectangle(0, 0, size.width, size.height));
                    } else {
                        Rectangle r = list.getCellBounds(count - 1, count - 1);
                        r.y += r.height;
                        this.dropArea.setDecorationBounds(r);
                    }
                } else if (this.dropArea != null) {
                    this.dropArea.dispose();
                    this.dropArea = null;
                }
            }
        };
        final JTree tree = new JTree();
        tree.setFont(label.getFont());
        FontMetrics m = label.getFontMetrics(label.getFont());
        int h = m.getHeight();
        tree.setRowHeight(h);
        new DropHandler((Component)tree, 1, acceptableFlavors){
            final int MARGIN = 4;
            private AbstractComponentDecorator dropArea;
            {
                super(x0, x1, x2);
                this.MARGIN = 4;
            }

            private DropLocation getDropLocation(Point location) {
                TreePath path = tree.getClosestPathForLocation(location.x, location.y);
                Object o = path.getLastPathComponent();
                Rectangle bounds = tree.getPathBounds(path);
                if (Math.abs(bounds.y - location.y) < 4 || Math.abs(bounds.y + bounds.height - location.y) < 4) {
                    int row = tree.getRowForPath(path);
                    if (location.y < bounds.y + bounds.height / 2) {
                        if (row > 0) {
                            path = tree.getPathForRow(--row);
                            o = path.getLastPathComponent();
                        } else if (!tree.isRootVisible()) {
                            o = tree.getModel().getRoot();
                            return new DropLocation(new TreePath(o), 0);
                        }
                    }
                    if (tree.getModel().isLeaf(o)) {
                        TreePath parentPath = path.getParentPath();
                        Object parent = parentPath.getLastPathComponent();
                        int idx = tree.getModel().getIndexOfChild(parent, o) + 1;
                        return new DropLocation(parentPath, idx);
                    }
                    return new DropLocation(path, 0);
                }
                if (!tree.getModel().isLeaf(o)) {
                    int count = tree.getModel().getChildCount(o);
                    return new DropLocation(path, count);
                }
                return null;
            }

            private Rectangle getInsertionBounds(DropLocation loc) {
                int HEIGHT = 4;
                Rectangle r = tree.getPathBounds(loc.parent);
                if (tree.isExpanded(loc.parent)) {
                    Object parent = loc.parent.getLastPathComponent();
                    if (tree.getModel().getChildCount(parent) > loc.index) {
                        Object child = tree.getModel().getChild(parent, loc.index);
                        r = tree.getPathBounds(loc.parent.pathByAddingChild(child));
                        r.height = 0;
                    } else {
                        r.y += r.height;
                        r.height = 0;
                    }
                }
                return r;
            }

            protected boolean canDrop(DropTargetEvent e, int action, Point location) {
                DropLocation loc = this.getDropLocation(location);
                return loc != null;
            }

            protected void paintDropTarget(DropTargetEvent e, int action, Point location) {
                DropLocation loc;
                if (action != 0 && location != null && (loc = this.getDropLocation(location)) != null) {
                    if (this.dropArea == null) {
                        this.dropArea = new Marquee(tree);
                    }
                    Rectangle r = this.getInsertionBounds(loc);
                    this.dropArea.setDecorationBounds(r);
                } else if (this.dropArea != null) {
                    this.dropArea.dispose();
                    this.dropArea = null;
                }
            }

            protected void drop(DropTargetDropEvent e, int action) throws UnsupportedFlavorException, IOException {
                DropLocation loc = this.getDropLocation(e.getLocation());
                if (loc != null) {
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    String value = (String)e.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(value);
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)loc.parent.getLastPathComponent();
                    model.insertNodeInto(child, parent, loc.index);
                }
            }

            class DropLocation {
                TreePath parent;
                int index;

                DropLocation(TreePath p, int idx) {
                    this.parent = p;
                    this.index = idx;
                }
            }
        };
        p.add(label);
        JLabel label2 = new JLabel("Drag the label");
        label2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p.add((Component)label2, "South");
        dragFrame.setDefaultCloseOperation(3);
        dragFrame.pack();
        dragFrame.setSize(200, 300);
        dragFrame.setLocation(100, 100);
        dragFrame.setVisible(true);
        JFrame dropFrame = new JFrame("Drop Over Here");
        dropFrame.setDefaultCloseOperation(3);
        dropFrame.getContentPane().add(new JScrollPane(list));
        JLabel label3 = new JLabel("Onto the list");
        label3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        dropFrame.getContentPane().add((Component)label3, "South");
        dropFrame.pack();
        dropFrame.setSize(200, 300);
        dropFrame.setLocation(300, 100);
        dropFrame.setVisible(true);
        JFrame dropFrame2 = new JFrame("Drop Over Here");
        dropFrame2.setDefaultCloseOperation(3);
        dropFrame2.getContentPane().add(new JScrollPane(tree));
        JLabel label4 = new JLabel("Or onto the tree");
        label4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        dropFrame2.getContentPane().add((Component)label4, "South");
        dropFrame2.pack();
        dropFrame2.setSize(200, 300);
        dropFrame2.setLocation(500, 100);
        dropFrame2.setVisible(true);
    }

    private static class Marquee
    extends AbstractComponentDecorator
    implements ActionListener {
        private Timer timer = new Timer(41, this);
        private float phase;
        final int LINE_WIDTH = 4;
        final int INTERVAL = 41;
        final int SIZE = 8;

        public Marquee(JComponent target) {
            super(target);
            this.timer.start();
        }

        public void setDecorationBounds(int x, int y, int w, int h) {
            this.setDecorationBounds(new Rectangle(x, y, w, h));
        }

        public void setDecorationBounds(Rectangle r) {
            r.y -= 2;
            r.height += 4;
            if (r.height == 4) {
                r.height = 8;
            }
            r.x -= 2;
            r.width += 4;
            super.setDecorationBounds(r);
        }

        private void light(Graphics g, Color color, int x, int y, int size) {
            g.setColor(color.darker());
            g.fillArc(x, y, size, size, 0, 360);
            g.setColor(color);
            g.fillArc(x + size / 8, y + size / 8, size / 2, size / 2, 0, 360);
            g.setColor(color.brighter());
            g.fillArc(x + size / 8, y + size / 4, size / 4, size / 4, 0, 360);
        }

        public void paint(Graphics g) {
            Rectangle r = this.getDecorationBounds();
            g.setColor(UIManager.getColor("Tree.selectionBackground"));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = 2;
            int dw = 4 - w;
            ((Graphics2D)g).setStroke(new BasicStroke(4.0f, 0, 1, 10.0f, new float[]{10.0f, 2.0f}, this.phase));
            g.drawRect(r.x + w, r.y + w, r.width - 2 - dw, r.height - 2 - dw);
        }

        public void actionPerformed(ActionEvent e) {
            this.phase += 2.0f;
            this.getPainter().repaint();
        }

        public void dispose() {
            this.timer.stop();
            this.timer = null;
            super.dispose();
        }
    }

    private static class ZoomRect
    extends AbstractComponentDecorator
    implements ActionListener {
        private Timer timer = new Timer(83, this);
        private int alpha;
        private volatile boolean zoom;
        private Rectangle targetBounds;
        final int MPY = 4;
        final int INTERVAL = 83;
        final int SPEED = 2;

        public ZoomRect(JComponent target) {
            super(target);
            this.timer.start();
        }

        private void reset(Rectangle target) {
            this.targetBounds = target;
            this.alpha = 0;
            int x = target.x - target.width * 3 / 2;
            int y = target.y - target.height * 3 / 2;
            super.setDecorationBounds(new Rectangle(x, y, target.width * 4, target.height * 4));
        }

        public void setDecorationBounds(Rectangle targetBounds) {
            if (!targetBounds.equals(this.targetBounds)) {
                this.reset(targetBounds);
            }
        }

        private void zoom() {
            this.alpha += (255 - this.alpha) / 2;
            Rectangle r1 = this.getDecorationBounds();
            Rectangle r2 = this.targetBounds;
            int dw = (r2.width - r1.width) / 2;
            int dh = (r2.height - r1.height) / 2;
            r1.x += (r2.x - r1.x) / 2;
            r1.y += (r2.y - r1.y) / 2;
            r1.width += dw;
            r1.height += dh;
            super.setDecorationBounds(r1);
        }

        public void paint(Graphics g) {
            if (this.zoom) {
                this.zoom();
                this.zoom = false;
            }
            g = g.create();
            Color tgt = UIManager.getColor("Table.selectionBackground");
            g.setColor(new Color(tgt.getRed(), tgt.getGreen(), tgt.getBlue(), this.alpha));
            ((Graphics2D)g).setStroke(new BasicStroke(8.0f));
            Rectangle r = this.getDecorationBounds();
            g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
            g.dispose();
        }

        public void dispose() {
            super.dispose();
            this.timer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            this.zoom = true;
            this.repaint();
        }
    }
}

