/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import furbelow.Autoscroller;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class DropTargetNavigator
implements DragSourceListener,
DragSourceMotionListener {
    private static final int DEFAULT_NAVIGATION_DELAY = 500;
    private static DropTargetNavigator INSTANCE;
    private static int navigationDelay;
    private static Map navigators;
    private DragSource dragSource;
    private Map restoreMap = new HashMap();
    private Map timers = new WeakHashMap();
    private DropTrackingQueue queue;

    public static synchronized void setNavigationDelay(int ms) {
        navigationDelay = ms;
    }

    public static synchronized int getNavigationDelay() {
        return navigationDelay;
    }

    public static synchronized void register(Class cls, Navigator navigator) {
        navigators.put(cls, navigator);
    }

    public static synchronized void enableDropTargetNavigation() {
        if (INSTANCE == null) {
            INSTANCE = new DropTargetNavigator(DragSource.getDefaultDragSource());
        }
    }

    public static synchronized void disableDropTargetNavigation() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
        }
    }

    public DropTargetNavigator() {
        this(DragSource.getDefaultDragSource());
    }

    public DropTargetNavigator(DragSource src) {
        this.dragSource = src;
        src.addDragSourceListener(this);
        src.addDragSourceMotionListener(this);
        try {
            this.queue = new DropTrackingQueue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getWindows(Window root) {
        ArrayList<Window> list = new ArrayList<Window>();
        if (root == null) {
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                list.addAll(this.getWindows(frames[i]));
            }
        } else {
            list.add(root);
            Window[] subs = root.getOwnedWindows();
            for (int i = 0; i < subs.length; ++i) {
                list.addAll(this.getWindows(subs[i]));
            }
        }
        return list;
    }

    private Map getComponents(Point screen) {
        List windows = this.getWindows(null);
        HashMap<Component, Point> comps = new HashMap<Component, Point>();
        Iterator i = windows.iterator();
        while (i.hasNext()) {
            Window w = (Window)i.next();
            Point loc = new Point(screen.x - w.getX(), screen.y - w.getY());
            Component c = this.findComponentAt(w, loc.x, loc.y);
            if (c == null) continue;
            comps.put(c, SwingUtilities.convertPoint(w, loc, c));
        }
        return comps;
    }

    private JTabbedPane getTabbedPaneForTab(Component c) {
        JTabbedPane p = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, c);
        if (p != null) {
            int count = p.getTabCount();
            for (int i = 0; i < count && p.getComponentAt(i) != c; ++i) {
            }
        }
        return p;
    }

    private Component findComponentAt(Window w, int wx, int wy) {
        JTabbedPane p;
        Container root = w;
        RootPaneContainer rpc = DropTargetNavigator.findRootPaneContainer(w);
        if (rpc != null) {
            root = rpc.getContentPane();
        }
        Point where = SwingUtilities.convertPoint(w, wx, wy, root);
        Component target = SwingUtilities.getDeepestComponentAt(root, where.x, where.y);
        if (target == null) {
            target = SwingUtilities.getDeepestComponentAt(w, wx, wy);
        }
        if ((p = this.getTabbedPaneForTab(target)) != null) {
            target = p;
        }
        return target;
    }

    private void update(Point screen) {
        if (screen != null) {
            Map comps = this.getComponents(screen);
            this.restore(comps.keySet());
            Iterator i = comps.keySet().iterator();
            while (i.hasNext()) {
                Component c = (Component)i.next();
                this.update(c, (Point)comps.get(c));
            }
        }
    }

    private boolean needsAutoscroll(Component c) {
        if (c instanceof JTree || c instanceof JTable || c instanceof JList || c instanceof JTextComponent) {
            return false;
        }
        return !(c instanceof Autoscroll);
    }

    private void update(Component c, Point where) {
        Navigator navigator;
        if (this.needsAutoscroll(c) && c instanceof JComponent && c instanceof Scrollable) {
            JComponent jc = (JComponent)c;
            Rectangle visible = jc.getVisibleRect();
            Autoscroller scroller = new Autoscroller(jc);
            scroller.autoscroll(where);
            Rectangle visible2 = jc.getVisibleRect();
            if (!visible.equals(visible2)) {
                return;
            }
        }
        if ((navigator = this.getNavigator(c)) != null) {
            NavigationTimer timer = (NavigationTimer)this.timers.get(c);
            if (timer != null) {
                if (!timer.update(where)) {
                    timer = null;
                }
            } else {
                timer = new NavigationTimer(c, where);
                this.timers.put(c, timer);
                timer.start();
            }
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
        this.update(e.getLocation());
    }

    public void dragOver(DragSourceDragEvent e) {
        this.update(e.getLocation());
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
        this.update(e.getLocation());
    }

    public void dragMouseMoved(DragSourceDragEvent e) {
        this.update(e.getLocation());
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this.update(e.getLocation());
        if (e.getDropSuccess()) {
            this.restoreMap.clear();
        }
        this.restore(Collections.EMPTY_LIST);
    }

    private Navigator getNavigator(Component c) {
        for (Class<?> cls = c.getClass(); cls != null; cls = cls.getSuperclass()) {
            Navigator n = (Navigator)navigators.get(cls);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    private boolean isNavigating(Component comp, Collection active) {
        Navigator n = this.getNavigator(comp);
        if (n != null) {
            return n.isNavigating(comp, active);
        }
        return active.contains(comp);
    }

    private void restore(Collection active) {
        Iterator i = this.restoreMap.keySet().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (this.isNavigating(c, active)) continue;
            Runnable action = (Runnable)this.restoreMap.get(c);
            action.run();
            i.remove();
            NavigationTimer timer = (NavigationTimer)this.timers.get(c);
            if (timer == null) continue;
            timer.dispose();
        }
    }

    public void dispose() {
        this.dragSource.removeDragSourceListener(this);
        this.dragSource.removeDragSourceMotionListener(this);
        this.dragSource = null;
        if (this.queue != null) {
            this.queue.dispose();
            this.queue = null;
        }
    }

    public static RootPaneContainer findRootPaneContainer(Container c) {
        if (c instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)c);
        }
        Component[] kids = c.getComponents();
        for (int i = 0; i < kids.length; ++i) {
            RootPaneContainer rcp;
            if (kids[i] instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)kids[i]);
            }
            if (!(kids[i] instanceof Container) || (rcp = DropTargetNavigator.findRootPaneContainer((Container)kids[i])) == null) continue;
            return rcp;
        }
        return null;
    }

    static {
        navigationDelay = 500;
        navigators = new WeakHashMap();
        try {
            navigationDelay = Integer.getInteger("DropTargetNavigator.delay", 500);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DropTargetNavigator.register(JTabbedPane.class, new JTabbedPaneNavigator());
        DropTargetNavigator.register(JTree.class, new JTreeNavigator());
    }

    private class NavigationTimer
    extends Timer
    implements ActionListener {
        private Component component;
        private Point origin;
        private Point current;
        private Runnable undo;

        public NavigationTimer(Component c, Point where) {
            super(navigationDelay, null);
            this.component = c;
            this.origin = this.current = where;
            this.undo = (Runnable)DropTargetNavigator.this.restoreMap.get(c);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public boolean update(Point current) {
            this.current = current;
            int dx = Math.abs(current.x - this.origin.x);
            int dy = Math.abs(current.y - this.origin.y);
            if (dx > 5 || dy > 5) {
                this.dispose();
                return false;
            }
            return true;
        }

        public void dispose() {
            this.stop();
            DropTargetNavigator.this.timers.remove(this.component);
        }

        public void actionPerformed(ActionEvent e) {
            Navigator navigator = DropTargetNavigator.this.getNavigator(this.component);
            Runnable r = navigator.navigate(this.component, this.current, this.undo);
            if (r != null) {
                DropTargetNavigator.this.restoreMap.put(this.component, r);
            }
            this.dispose();
        }
    }

    private class DropTrackingQueue
    extends EventQueue {
        public DropTrackingQueue() {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
        }

        protected void dispatchEvent(AWTEvent e) {
            if (e instanceof MouseEvent && e.getClass().getName().indexOf("SunDropTargetEvent") != -1) {
                MouseEvent me = (MouseEvent)e;
                Point loc = me.getComponent().getLocationOnScreen();
                loc.translate(me.getX(), me.getY());
                DropTargetNavigator.this.update(loc);
            }
            super.dispatchEvent(e);
        }

        public void dispose() {
            try {
                this.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
    }

    private static class JTreeNavigator
    extends AbstractNavigator {
        private JTreeNavigator() {
        }

        public Runnable navigate(Component c, Point where, final Runnable prev) {
            final JTree tree = (JTree)c;
            Runnable undo = prev;
            final TreePath path = tree.getPathForLocation(where.x, where.y);
            if (path != null && !tree.isExpanded(path)) {
                undo = new Runnable(){

                    public void run() {
                        tree.collapsePath(path);
                        if (prev != null) {
                            prev.run();
                        }
                    }
                };
                tree.expandPath(path);
            }
            return undo;
        }
    }

    private static class JTabbedPaneNavigator
    extends AbstractNavigator {
        private JTabbedPaneNavigator() {
        }

        public boolean isNavigating(Component comp, Collection active) {
            Iterator i = active.iterator();
            while (i.hasNext()) {
                Component c = (Component)i.next();
                if (!SwingUtilities.isDescendingFrom(c, comp)) continue;
                return true;
            }
            return false;
        }

        public Runnable navigate(Component c, Point where, Runnable prev) {
            final JTabbedPane tab = (JTabbedPane)c;
            final int current = tab.getSelectedIndex();
            int idx = tab.indexAtLocation(where.x, where.y);
            Runnable undo = prev;
            if (idx != -1 && current != idx) {
                if (undo == null) {
                    undo = new Runnable(){

                        public void run() {
                            tab.setSelectedIndex(current);
                        }
                    };
                }
                tab.setSelectedIndex(idx);
            }
            return undo;
        }
    }

    public static abstract class AbstractNavigator
    implements Navigator {
        public boolean isNavigating(Component comp, Collection active) {
            return active.contains(comp);
        }
    }

    public static interface Navigator {
        public boolean isNavigating(Component var1, Collection var2);

        public Runnable navigate(Component var1, Point var2, Runnable var3);
    }
}

