/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;

public class DelegatingAction
extends AbstractAction
implements PropertyChangeListener {
    private Action delegate;
    private Component target;
    private String actionKey;
    private String actionKey2;

    public DelegatingAction(String name, String key, String altKey) {
        super(name);
        this.actionKey = key;
        this.actionKey2 = altKey;
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        fm.addPropertyChangeListener("permanentFocusOwner", new FocusChangeListener());
    }

    protected static String getClipboardContents() {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = clip.getContents(null);
            return (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static boolean clipboardHasContents() {
        String contents = DelegatingAction.getClipboardContents();
        return contents != null && !"".equals(contents);
    }

    private void setDelegate(Action delegate) {
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this);
        }
        this.delegate = delegate;
        if (delegate != null) {
            delegate.addPropertyChangeListener(this);
        }
        this.setEnabled(delegate != null && delegate.isEnabled());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("enabled".equals(e.getPropertyName())) {
            this.setEnabled(Boolean.TRUE.equals(e.getNewValue()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.delegate != null) {
            if (this.target != null) {
                e = new ActionEvent(this.target, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
            }
            this.delegate.actionPerformed(e);
        }
    }

    private static JList createList(boolean readOnly) {
        Object[] data = new Object[]{"Apples", "Oranges", "Bananas", "Kiwis", "Turnips", "Rutabagas"};
        final JList<Object> list = new JList<Object>(data);
        new ListSelectionDimmer(list);
        final ActionMap map = list.getActionMap();
        if (readOnly) {
            map.put("cut", new DisabledAction("cut"));
            map.put("paste", new DisabledAction("paste"));
        } else {
            map.put("cut", new AbstractAction("cut"){

                public void actionPerformed(ActionEvent e) {
                    map.get("copy").actionPerformed(e);
                    final ArrayList contents = new ArrayList();
                    ListModel model = list.getModel();
                    int[] indices = list.getSelectedIndices();
                    for (int i = 0; i < model.getSize(); ++i) {
                        if (list.isSelectedIndex(i)) continue;
                        contents.add(model.getElementAt(i));
                    }
                    list.setModel(new AbstractListModel(){

                        public int getSize() {
                            return contents.size();
                        }

                        public Object getElementAt(int index) {
                            return contents.get(index);
                        }
                    });
                    if (indices.length == 1) {
                        if (indices[0] < contents.size()) {
                            list.setSelectedIndex(indices[0]);
                        } else if (indices[0] == contents.size()) {
                            list.setSelectedIndex(contents.size() - 1);
                        }
                    }
                }
            });
            map.put("paste", new PasteAction(){

                public void actionPerformed(ActionEvent e) {
                    final ArrayList contents = new ArrayList();
                    ListModel model = list.getModel();
                    for (int i = 0; i < model.getSize(); ++i) {
                        contents.add(model.getElementAt(i));
                    }
                    int idx = list.getSelectedIndex();
                    if (idx == -1 && model.getSize() == 0) {
                        idx = 0;
                    }
                    String s = DelegatingAction.getClipboardContents();
                    if (idx != -1 && s != null) {
                        contents.add(idx, s);
                        list.setModel(new AbstractListModel(){

                            public int getSize() {
                                return contents.size();
                            }

                            public Object getElementAt(int index) {
                                return contents.get(index);
                            }
                        });
                        list.setSelectedIndex(idx);
                    }
                }
            });
        }
        return list;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Delegating Edit Menu");
        frame.setDefaultCloseOperation(3);
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("Edit");
        menu.add(new JMenuItem(new DelegatingAction("Cut", "cut", "cut-to-clipboard")));
        menu.add(new JMenuItem(new DelegatingAction("Copy", "copy", "copy-to-clipboard")));
        menu.add(new JMenuItem(new DelegatingAction("Paste", "paste", "paste-from-clipboard")));
        mb.add(menu);
        frame.setJMenuBar(mb);
        JTextField textField = new JTextField("Select this text and copy");
        final MessageFormat fmt = new MessageFormat("<html><i>Clipboard Contents:</i><br>{0}</html>");
        final JLabel label = new JLabel(fmt.format(new Object[]{"<br>"}));
        JPanel p = (JPanel)frame.getContentPane();
        JPanel split = new JPanel(new GridLayout(0, 2));
        JPanel pleft = new JPanel(new BorderLayout());
        pleft.add((Component)new JLabel("Copy only"), "North");
        pleft.add(new JScrollPane(DelegatingAction.createList(true)));
        split.add(pleft);
        JPanel pright = new JPanel(new BorderLayout());
        pright.add((Component)new JLabel("Copy, Cut, or Paste non-empty text"), "North");
        pright.add(new JScrollPane(DelegatingAction.createList(false)));
        split.add(pright);
        p.add((Component)split, "Center");
        p.add((Component)textField, "First");
        p.add((Component)label, "Last");
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = DelegatingAction.getClipboardContents();
                if (s == null) {
                    s = "{empty or not a String}";
                }
                int MAX = 200;
                if (s.length() > 200) {
                    s = s.substring(0, 197) + "...";
                }
                label.setText(fmt.format(new Object[]{s}));
            }
        });
        timer.start();
        timer.setRepeats(true);
        frame.pack();
        frame.setSize(400, 300);
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }

    public static abstract class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("paste");
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            fm.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    PasteAction.this.setEnabled(DelegatingAction.clipboardHasContents());
                }
            });
        }
    }

    private static class ListSelectionDimmer {
        public ListSelectionDimmer(final JList list) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            fm.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){
                private Color oldColor;

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getOldValue() == list) {
                        if (this.oldColor == null) {
                            this.oldColor = list.getSelectionBackground();
                            Color bg = list.getBackground();
                            bg = new Color((bg.getRed() + this.oldColor.getRed()) / 2, (bg.getGreen() + this.oldColor.getGreen()) / 2, (bg.getBlue() + this.oldColor.getBlue()) / 2);
                            list.setSelectionBackground(bg);
                        }
                    } else if (e.getNewValue() == list && this.oldColor != null) {
                        list.setSelectionBackground(this.oldColor);
                        this.oldColor = null;
                    }
                }
            });
        }
    }

    public static class DisabledAction
    extends AbstractAction {
        public DisabledAction(String name) {
            super(name);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class FocusChangeListener
    implements PropertyChangeListener {
        private FocusChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Component c = (Component)e.getNewValue();
            if (c instanceof JComponent) {
                ActionMap map = ((JComponent)c).getActionMap();
                Action a = map.get(DelegatingAction.this.actionKey);
                if (a == null) {
                    a = map.get(DelegatingAction.this.actionKey2);
                }
                DelegatingAction.this.setDelegate(a);
                DelegatingAction.this.target = c;
            } else {
                DelegatingAction.this.setDelegate(null);
                DelegatingAction.this.target = null;
            }
        }
    }
}

