/*
 * Decompiled with CFR 0.152.
 */
package furbelow;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ComponentIcon
implements Icon {
    private JComponent component;
    private boolean includeBorder;

    public ComponentIcon(JComponent c) {
        this(c, false);
    }

    public ComponentIcon(JComponent c, boolean includeBorder) {
        this.component = c;
        this.includeBorder = includeBorder;
    }

    public int getIconHeight() {
        Insets insets;
        int h = this.component.getHeight();
        if (h != 0 && !this.includeBorder && (insets = this.component.getInsets()) != null) {
            h -= insets.top + insets.bottom;
        }
        return h;
    }

    public int getIconWidth() {
        Insets insets;
        int w = this.component.getWidth();
        if (w != 0 && !this.includeBorder && (insets = this.component.getInsets()) != null) {
            w -= insets.left + insets.right;
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(Component c, Graphics graphics, int x, int y) {
        boolean db = this.component.isDoubleBuffered();
        try {
            if (!this.includeBorder) {
                Insets insets = this.component.getInsets();
                x -= insets.left;
                y -= insets.top;
            }
            Graphics2D g = (Graphics2D)graphics.create(x, y, this.getIconWidth(), this.getIconHeight());
            if (!this.component.isDisplayable()) {
                this.component.addNotify();
            }
            this.component.setDoubleBuffered(false);
            this.component.paintAll(g);
        }
        finally {
            this.component.setDoubleBuffered(db);
        }
    }
}

