/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import net.sf.jasperreports.engine.export.zip.AbstractZip;
import net.sf.jasperreports.engine.export.zip.EmptyZipEntry;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;

public abstract class OasisZip
extends AbstractZip {
    private ExportZipEntry contentEntry = null;
    private ExportZipEntry stylesEntry = null;

    public OasisZip() throws IOException {
        this(1);
    }

    public OasisZip(byte openDocumentNature) throws IOException {
        String mimetype;
        this.exportZipEntries = new ArrayList();
        this.contentEntry = this.createEntry("content.xml");
        this.exportZipEntries.add(this.contentEntry);
        this.exportZipEntries.add(new EmptyZipEntry("meta.xml"));
        this.exportZipEntries.add(new EmptyZipEntry("settings.xml"));
        this.stylesEntry = this.createEntry("styles.xml");
        this.exportZipEntries.add(this.stylesEntry);
        switch (openDocumentNature) {
            case 2: {
                mimetype = "spreadsheet";
                break;
            }
            default: {
                mimetype = "text";
            }
        }
        this.createMimeEntry(mimetype);
        this.createManifestEntry(mimetype);
    }

    public ExportZipEntry getContentEntry() {
        return this.contentEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMimeEntry(String mimetype) throws IOException {
        ExportZipEntry mimeEntry = this.createEntry("mimetype");
        Writer mimeWriter = null;
        try {
            mimeWriter = mimeEntry.getWriter();
            mimeWriter.write("application/vnd.oasis.opendocument." + mimetype);
            mimeWriter.flush();
            this.exportZipEntries.add(mimeEntry);
        }
        finally {
            if (mimeWriter != null) {
                try {
                    mimeWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManifestEntry(String mimetype) throws IOException {
        ExportZipEntry manifestEntry = this.createEntry("META-INF/manifest.xml");
        Writer manifestWriter = null;
        try {
            manifestWriter = manifestEntry.getWriter();
            manifestWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            manifestWriter.write("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\">\n");
            manifestWriter.write("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument." + mimetype + "\" manifest:full-path=\"/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"application/vnd.sun.xml.ui.configuration\" manifest:full-path=\"Configurations2/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Pictures/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"meta.xml\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/thumbnail.png\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"\" manifest:full-path=\"Thumbnails/\"/>\n");
            manifestWriter.write("  <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"settings.xml\"/>\n");
            manifestWriter.write("</manifest:manifest>\n");
            manifestWriter.flush();
            this.exportZipEntries.add(manifestEntry);
        }
        finally {
            if (manifestWriter != null) {
                try {
                    manifestWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

