/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.geom.Point2D;

public class CrossoverScalingControl
extends ScalingGraphMousePlugin
implements ScalingControl {
    protected double crossover = 1.0;

    public void setCrossover(double crossover) {
        this.crossover = crossover;
    }

    public void scale(VisualizationViewer vv, float amount, Point2D at) {
        MutableTransformer modelTransformer = vv.getLayoutTransformer();
        MutableTransformer viewTransformer = vv.getViewTransformer();
        double modelScale = modelTransformer.getScale();
        double viewScale = viewTransformer.getScale();
        double inverseModelScale = Math.sqrt(this.crossover) / modelScale;
        double inverseViewScale = Math.sqrt(this.crossover) / viewScale;
        double scale = modelScale * viewScale;
        Point2D transformedAt = vv.inverseViewTransform(at);
        if (scale * (double)amount < this.crossover) {
            viewTransformer.scale(amount, amount, at);
            modelTransformer.scale(inverseModelScale, inverseModelScale, transformedAt);
        } else {
            modelTransformer.scale(amount, amount, transformedAt);
            viewTransformer.scale(inverseViewScale, inverseViewScale, at);
        }
        vv.repaint();
    }
}

