/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.permuters;

import cern.jet.random.sampling.RandomSampler;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.random.permuters.EdgePermuter;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.MutableInteger;
import edu.uci.ics.jung.utils.Pair;
import java.util.HashMap;
import java.util.Map;

public class BernoulliEdgePermuter
implements EdgePermuter {
    Map mEdgeIndexLookupTable = new HashMap();
    private long[] mPermuteEdgeSample;
    private int mNumEdgesToPermute;

    public BernoulliEdgePermuter(int numEdgesToPermute) {
        this.mNumEdgesToPermute = numEdgesToPermute;
    }

    protected void initialize(Graph g) {
        this.mPermuteEdgeSample = new long[this.mNumEdgesToPermute];
        int numVertices = g.numVertices();
        Indexer id = Indexer.getIndexer(g);
        int edgeCtr = 0;
        for (int i = 0; i < numVertices; ++i) {
            for (int j = 0; j < numVertices; ++j) {
                if (i == j) continue;
                this.mEdgeIndexLookupTable.put(new MutableInteger(edgeCtr), new Pair(id.getVertex(i), id.getVertex(j)));
                ++edgeCtr;
            }
        }
    }

    public void permuteEdges(Graph graph) {
        this.permuteEdges(graph, 1.0);
    }

    public void permuteEdges(Graph graph, double probEdgeFlip) {
        if (probEdgeFlip < 0.0 || probEdgeFlip > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0 and 1.");
        }
        int numVertices = graph.numVertices();
        int numPossibleEdges = numVertices * numVertices - numVertices;
        if (this.mNumEdgesToPermute < 0 || this.mNumEdgesToPermute > numPossibleEdges) {
            throw new IllegalArgumentException("Number specified for number of edges to flip must be between 0 and n^2-n");
        }
        this.initialize(graph);
        RandomSampler randomSampler = new RandomSampler((long)this.mNumEdgesToPermute, (long)numPossibleEdges, 0L, null);
        randomSampler.nextBlock(this.mNumEdgesToPermute, this.mPermuteEdgeSample, 0);
        Vertex sourceVertex = null;
        Vertex destVertex = null;
        MutableInteger currentKey = new MutableInteger();
        for (int i = 0; i < this.mNumEdgesToPermute; ++i) {
            currentKey.setInteger((int)this.mPermuteEdgeSample[i]);
            Pair currentEdge = (Pair)this.mEdgeIndexLookupTable.get(currentKey);
            sourceVertex = (Vertex)currentEdge.getFirst();
            destVertex = (Vertex)currentEdge.getSecond();
            if (sourceVertex == destVertex || !(Math.random() <= probEdgeFlip)) continue;
            if (!sourceVertex.isPredecessorOf(destVertex)) {
                GraphUtils.addEdge(graph, sourceVertex, destVertex);
                continue;
            }
            Edge e = sourceVertex.findEdge(destVertex);
            graph.removeEdge(e);
        }
    }
}

