/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.random.generators.EvolvingGraphGenerator;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class BarabasiAlbertGenerator
implements EvolvingGraphGenerator {
    private Graph mGraph = null;
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected Vector vertex_index;
    protected int init_vertices;
    protected Map index_vertex;
    protected boolean directed;
    public static final Object SEED = "edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator.SEED";

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach, boolean directed, int seed) {
        if (init_vertices <= 0) {
            throw new IllegalArgumentException("Number of initial unconnected 'seed' vertices must be positive");
        }
        if (numEdgesToAttach <= 0) {
            throw new IllegalArgumentException("Number of edges to attach at each time step must be positive");
        }
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.init_vertices = init_vertices;
        this.directed = directed;
        this.initialize();
    }

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach, int seed) {
        this(init_vertices, numEdgesToAttach, false, seed);
    }

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach) {
        this(init_vertices, numEdgesToAttach, (int)System.currentTimeMillis());
    }

    private void initialize() {
        this.mGraph = this.directed ? new DirectedSparseGraph() : new UndirectedSparseGraph();
        this.mGraph.getEdgeConstraints().remove(Graph.NOT_PARALLEL_EDGE);
        this.vertex_index = new Vector(2 * this.init_vertices);
        this.index_vertex = new HashMap(2 * this.init_vertices);
        for (int i = 0; i < this.init_vertices; ++i) {
            UndirectedSparseVertex v = new UndirectedSparseVertex();
            this.mGraph.addVertex(v);
            this.vertex_index.add(v);
            this.index_vertex.put(v, new Integer(i));
            v.addUserDatum(SEED, SEED, UserData.REMOVE);
        }
        this.mElapsedTimeSteps = 0;
    }

    private Edge createRandomEdge(Set preexistingNodes, Vertex newVertex) {
        Vertex attach_point;
        double attach_prob;
        do {
            attach_point = (Vertex)this.vertex_index.elementAt(this.mRandom.nextInt(this.vertex_index.size()));
            double degree = this.directed ? (double)attach_point.inDegree() : (double)attach_point.degree();
            attach_prob = (degree + 1.0) / (double)(this.mGraph.numEdges() + this.mGraph.numVertices() - 1);
        } while (this.mRandom.nextDouble() > attach_prob);
        if (this.directed) {
            return new DirectedSparseEdge(newVertex, attach_point);
        }
        return new UndirectedSparseEdge(newVertex, attach_point);
    }

    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            this.evolveGraph();
            ++this.mElapsedTimeSteps;
        }
    }

    private void evolveGraph() {
        Set preexistingNodes = this.mGraph.getVertices();
        UndirectedSparseVertex newVertex = new UndirectedSparseVertex();
        this.mGraph.addVertex(newVertex);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        for (int i = 0; i < this.mNumEdgesToAttachPerStep; ++i) {
            edges.add(this.createRandomEdge(preexistingNodes, newVertex));
        }
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            this.mGraph.addEdge((Edge)iter.next());
        }
        this.vertex_index.add(newVertex);
        this.index_vertex.put(newVertex, new Integer(this.vertex_index.size() - 1));
    }

    public int getIndex(Vertex v) {
        return (Integer)this.index_vertex.get(v);
    }

    public int getNumElapsedTimeSteps() {
        return this.mElapsedTimeSteps;
    }

    public ArchetypeGraph generateGraph() {
        return this.mGraph;
    }

    public void reset() {
        this.initialize();
    }
}

