/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.algorithms.blockmodel.StructurallyEquivalent;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StructurallyEquivalentII
extends StructurallyEquivalent {
    public static StructurallyEquivalent getInstance() {
        if (instance == null) {
            instance = new StructurallyEquivalentII();
        }
        return instance;
    }

    public Set checkEquivalent(Graph g) {
        HashSet rv = new HashSet();
        HashSet alreadyEquivalent = new HashSet();
        HashSet<Vertex> alreadyChecked = new HashSet<Vertex>();
        ArrayList l = new ArrayList(g.getVertices());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Vertex v1 = (Vertex)iter.next();
            alreadyChecked.add(v1);
            if (alreadyEquivalent.contains(v1)) continue;
            boolean haveHitOne = false;
            HashSet neighbors = new HashSet(v1.getNeighbors());
            neighbors.removeAll(alreadyChecked);
            Iterator iterator = neighbors.iterator();
            while (iterator.hasNext()) {
                Vertex v2 = (Vertex)iterator.next();
                haveHitOne |= this.checkEquivalence(v1, v2, alreadyEquivalent, rv);
            }
            if (haveHitOne) continue;
            Set secondNeighbors = this.getSecondNeighbors(v1);
            secondNeighbors.removeAll(alreadyChecked);
            Iterator iterator2 = secondNeighbors.iterator();
            while (iterator2.hasNext()) {
                Vertex v2 = (Vertex)iterator2.next();
                this.checkEquivalence(v1, v2, alreadyEquivalent, rv);
            }
        }
        return rv;
    }

    boolean checkEquivalence(Vertex v1, Vertex v2, Set alreadyEquivalent, Set rv) {
        if (alreadyEquivalent.contains(v2)) {
            return false;
        }
        if (!this.canpossiblycompare(v1, v2)) {
            return false;
        }
        if (this.isStructurallyEquivalent(v1, v2)) {
            Pair p = new Pair(v1, v2);
            alreadyEquivalent.add(v2);
            rv.add(p);
            return true;
        }
        return false;
    }

    private Set getSecondNeighbors(Vertex v1) {
        HashSet secondNeighbors = new HashSet();
        Iterator iterator = v1.getNeighbors().iterator();
        while (iterator.hasNext()) {
            Vertex intermediate = (Vertex)iterator.next();
            secondNeighbors.addAll(intermediate.getNeighbors());
        }
        return secondNeighbors;
    }
}

