/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.tool.dcmecho;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.UserIdentity;

public class DcmEcho {
    private static final String USAGE = "dcmecho [Options] <aet>[@<host>[:<port>]]";
    private static final String DESCRIPTION = "Send DICOM Echo to the specified remote Application Entity. If <port> is not specified, DICOM default port 104 is assumed. If also no <host> is specified localhost is assumed.\nOptions:";
    private static final String EXAMPLE = "\nExample: dcmecho STORESCP@localhost:11112 \n=> Verify connection to Application Entity STORESCP, listening on local port 11112.";
    private static String[] TLS1 = new String[]{"TLSv1"};
    private static String[] SSL3 = new String[]{"SSLv3"};
    private static String[] NO_TLS1 = new String[]{"SSLv3", "SSLv2Hello"};
    private static String[] NO_SSL2 = new String[]{"TLSv1", "SSLv3"};
    private static String[] NO_SSL3 = new String[]{"TLSv1", "SSLv2Hello"};
    private static char[] SECRET = new char[]{'s', 'e', 'c', 'r', 'e', 't'};
    private static final String[] DEF_TS = new String[]{"1.2.840.10008.1.2"};
    private static final TransferCapability VERIFICATION_SCU = new TransferCapability("1.2.840.10008.1.1", DEF_TS, "SCU");
    private final Executor executor;
    private final NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private final NetworkConnection remoteConn = new NetworkConnection();
    private final Device device;
    private final NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private final NetworkConnection conn = new NetworkConnection();
    private Association assoc;
    private String keyStoreURL = "resource:tls/test_sys_1.p12";
    private char[] keyStorePassword = SECRET;
    private char[] keyPassword;
    private String trustStoreURL = "resource:tls/mesa_certs.jks";
    private char[] trustStorePassword = SECRET;

    public DcmEcho(String name) {
        this.device = new Device(name);
        this.executor = new NewThreadExecutor(name);
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(name);
        this.ae.setTransferCapability(new TransferCapability[]{VERIFICATION_SCU});
    }

    public final void setLocalHost(String hostname) {
        this.conn.setHostname(hostname);
    }

    public final void setRemoteHost(String hostname) {
        this.remoteConn.setHostname(hostname);
    }

    public final void setRemotePort(int port) {
        this.remoteConn.setPort(port);
    }

    public final void setTlsProtocol(String[] tlsProtocol) {
        this.conn.setTlsProtocol(tlsProtocol);
    }

    public final void setTlsWithoutEncyrption() {
        this.conn.setTlsWithoutEncyrption();
        this.remoteConn.setTlsWithoutEncyrption();
    }

    public final void setTls3DES_EDE_CBC() {
        this.conn.setTls3DES_EDE_CBC();
        this.remoteConn.setTls3DES_EDE_CBC();
    }

    public final void setTlsAES_128_CBC() {
        this.conn.setTlsAES_128_CBC();
        this.remoteConn.setTlsAES_128_CBC();
    }

    public final void setTlsNeedClientAuth(boolean needClientAuth) {
        this.conn.setTlsNeedClientAuth(needClientAuth);
    }

    public final void setKeyStoreURL(String url) {
        this.keyStoreURL = url;
    }

    public final void setKeyStorePassword(String pw) {
        this.keyStorePassword = pw.toCharArray();
    }

    public final void setKeyPassword(String pw) {
        this.keyPassword = pw.toCharArray();
    }

    public final void setTrustStorePassword(String pw) {
        this.trustStorePassword = pw.toCharArray();
    }

    public final void setTrustStoreURL(String url) {
        this.trustStoreURL = url;
    }

    public final void setCalledAET(String called, boolean reuse) {
        this.remoteAE.setAETitle(called);
        if (reuse) {
            this.ae.setReuseAssocationToAETitle(new String[]{called});
        }
    }

    public final void setCalling(String calling) {
        this.ae.setAETitle(calling);
    }

    public final void setUserIdentity(UserIdentity userIdentity) {
        this.ae.setUserIdentity(userIdentity);
    }

    public final void setIdleTimeout(int timeout) {
        this.ae.setIdleTimeout(timeout);
    }

    public final void setAssociationReaperPeriod(int period) {
        this.device.setAssociationReaperPeriod(period);
    }

    public final void setDimseRspTimeout(int timeout) {
        this.ae.setDimseRspTimeout(timeout);
    }

    public final void setConnectTimeout(int connectTimeout) {
        this.conn.setConnectTimeout(connectTimeout);
    }

    public final void setAcceptTimeout(int timeout) {
        this.conn.setAcceptTimeout(timeout);
    }

    public final void setReleaseTimeout(int timeout) {
        this.conn.setReleaseTimeout(timeout);
    }

    public final void setSocketCloseDelay(int timeout) {
        this.conn.setSocketCloseDelay(timeout);
    }

    private static CommandLine parse(String[] args) {
        Options opts = new Options();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set device name, use DCMECHO by default");
        opts.addOption(OptionBuilder.create((String)"device"));
        OptionBuilder.withArgName((String)"aet[@host]");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set AET and local address of local Application Entity, use device name and pick up any valid local address to bind the socket by default");
        opts.addOption(OptionBuilder.create((String)"L"));
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"enable User Identity Negotiation with specified username and  optional passcode");
        opts.addOption(OptionBuilder.create((String)"username"));
        OptionBuilder.withArgName((String)"passcode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"optional passcode for User Identity Negotiation, only effective with option -username");
        opts.addOption(OptionBuilder.create((String)"passcode"));
        opts.addOption("uidnegrsp", false, "request positive User Identity Negotation response, only effective with option -username");
        OptionBuilder.withArgName((String)"NULL|3DES|AES");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"enable TLS connection without, 3DES or AES encryption");
        opts.addOption(OptionBuilder.create((String)"tls"));
        OptionGroup tlsProtocol = new OptionGroup();
        tlsProtocol.addOption(new Option("tls1", "disable the use of SSLv3 and SSLv2 for TLS connections"));
        tlsProtocol.addOption(new Option("ssl3", "disable the use of TLSv1 and SSLv2 for TLS connections"));
        tlsProtocol.addOption(new Option("no_tls1", "disable the use of TLSv1 for TLS connections"));
        tlsProtocol.addOption(new Option("no_ssl3", "disable the use of SSLv3 for TLS connections"));
        tlsProtocol.addOption(new Option("no_ssl2", "disable the use of SSLv2 for TLS connections"));
        opts.addOptionGroup(tlsProtocol);
        opts.addOption("noclientauth", false, "disable client authentification for TLS");
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of P12 or JKS keystore, resource:tls/test_sys_1.p12 by default");
        opts.addOption(OptionBuilder.create((String)"keystore"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for keystore file, 'secret' by default");
        opts.addOption(OptionBuilder.create((String)"keystorepw"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for accessing the key in the keystore, keystore password by default");
        opts.addOption(OptionBuilder.create((String)"keypw"));
        OptionBuilder.withArgName((String)"file|url");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"file path or URL of JKS truststore, resource:tls/mesa_certs.jks by default");
        opts.addOption(OptionBuilder.create((String)"truststore"));
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for truststore file, 'secret' by default");
        opts.addOption(OptionBuilder.create((String)"truststorepw"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for TCP connect, no timeout by default");
        opts.addOption(OptionBuilder.create((String)"connectTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delay in ms for Socket close after sending A-ABORT, 50ms by default");
        opts.addOption(OptionBuilder.create((String)"soclosedelay"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"period in ms to check for outstanding DIMSE-RSP, 10s by default");
        opts.addOption(OptionBuilder.create((String)"reaper"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving DIMSE-RSP, 10s by default");
        opts.addOption(OptionBuilder.create((String)"rspTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving A-ASSOCIATE-AC, 5s by default");
        opts.addOption(OptionBuilder.create((String)"acceptTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving A-RELEASE-RP, 5s by default");
        opts.addOption(OptionBuilder.create((String)"releaseTO"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"timeout in ms for receiving DIMSE-RQ, 10s by default");
        opts.addOption(OptionBuilder.create((String)"idleTO"));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"repeat C-ECHO RQ several times");
        opts.addOption(OptionBuilder.create((String)"repeat"));
        OptionBuilder.withArgName((String)"ms");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delay in ms between repeated C-FIND RQ, immediately after C-FIND RSP by default");
        opts.addOption(OptionBuilder.create((String)"repeatdelay"));
        opts.addOption("reuseassoc", false, "Reuse association for repeated C-ECHO");
        opts.addOption("closeassoc", false, "Close association after each C-ECHO");
        opts.addOption("h", "help", false, "print this message");
        opts.addOption("V", "version", false, "print the version information and exit");
        CommandLine cl = null;
        try {
            cl = new GnuParser().parse(opts, args);
        }
        catch (ParseException e) {
            DcmEcho.exit("dcmecho: " + e.getMessage());
            throw new RuntimeException("unreachable");
        }
        if (cl.hasOption('V')) {
            Package p = DcmEcho.class.getPackage();
            System.out.println("dcmecho v" + p.getImplementationVersion());
            System.exit(0);
        }
        if (cl.hasOption('h') || cl.getArgList().size() != 1) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, DESCRIPTION, opts, EXAMPLE);
            System.exit(0);
        }
        return cl;
    }

    public static void main(String[] args) {
        CommandLine cl = DcmEcho.parse(args);
        DcmEcho dcmecho = new DcmEcho(cl.hasOption("device") ? cl.getOptionValue("device") : "DCMECHO");
        List argList = cl.getArgList();
        String remoteAE = (String)argList.get(0);
        String[] calledAETAddress = DcmEcho.split(remoteAE, '@');
        dcmecho.setCalledAET(calledAETAddress[0], cl.hasOption("reuseassoc"));
        if (calledAETAddress[1] == null) {
            dcmecho.setRemoteHost("127.0.0.1");
            dcmecho.setRemotePort(104);
        } else {
            String[] hostPort = DcmEcho.split(calledAETAddress[1], ':');
            dcmecho.setRemoteHost(hostPort[0]);
            dcmecho.setRemotePort(DcmEcho.toPort(hostPort[1]));
        }
        if (cl.hasOption("L")) {
            String localAE = cl.getOptionValue("L");
            String[] callingAETHost = DcmEcho.split(localAE, '@');
            dcmecho.setCalling(callingAETHost[0]);
            if (callingAETHost[1] != null) {
                dcmecho.setLocalHost(callingAETHost[1]);
            }
        }
        if (cl.hasOption("username")) {
            UserIdentity.Username userId;
            String username = cl.getOptionValue("username");
            if (cl.hasOption("passcode")) {
                String passcode = cl.getOptionValue("passcode");
                userId = new UserIdentity.UsernamePasscode(username, passcode.toCharArray());
            } else {
                userId = new UserIdentity.Username(username);
            }
            userId.setPositiveResponseRequested(cl.hasOption("uidnegrsp"));
            dcmecho.setUserIdentity((UserIdentity)userId);
        }
        if (cl.hasOption("connectTO")) {
            dcmecho.setConnectTimeout(DcmEcho.parseInt(cl.getOptionValue("connectTO"), "illegal argument of option -connectTO", 1, Integer.MAX_VALUE));
        }
        dcmecho.setIdleTimeout(cl.hasOption("idleTO") ? DcmEcho.parseInt(cl.getOptionValue("idleTO"), "illegal argument of option -idleTO", 1, Integer.MAX_VALUE) : 10000);
        if (cl.hasOption("reaper")) {
            dcmecho.setAssociationReaperPeriod(DcmEcho.parseInt(cl.getOptionValue("reaper"), "illegal argument of option -reaper", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("rspTO")) {
            dcmecho.setDimseRspTimeout(DcmEcho.parseInt(cl.getOptionValue("rspTO"), "illegal argument of option -rspTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("acceptTO")) {
            dcmecho.setAcceptTimeout(DcmEcho.parseInt(cl.getOptionValue("acceptTO"), "illegal argument of option -acceptTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("releaseTO")) {
            dcmecho.setReleaseTimeout(DcmEcho.parseInt(cl.getOptionValue("releaseTO"), "illegal argument of option -releaseTO", 1, Integer.MAX_VALUE));
        }
        if (cl.hasOption("soclosedelay")) {
            dcmecho.setSocketCloseDelay(DcmEcho.parseInt(cl.getOptionValue("soclosedelay"), "illegal argument of option -soclosedelay", 1, 10000));
        }
        int repeat = cl.hasOption("repeat") ? DcmEcho.parseInt(cl.getOptionValue("repeat"), "illegal argument of option -repeat", 1, Integer.MAX_VALUE) : 0;
        int interval = cl.hasOption("repeatdelay") ? DcmEcho.parseInt(cl.getOptionValue("repeatdelay"), "illegal argument of option -repeatdelay", 1, Integer.MAX_VALUE) : 0;
        boolean closeAssoc = cl.hasOption("closeassoc");
        if (cl.hasOption("tls")) {
            String cipher = cl.getOptionValue("tls");
            if ("NULL".equalsIgnoreCase(cipher)) {
                dcmecho.setTlsWithoutEncyrption();
            } else if ("3DES".equalsIgnoreCase(cipher)) {
                dcmecho.setTls3DES_EDE_CBC();
            } else if ("AES".equalsIgnoreCase(cipher)) {
                dcmecho.setTlsAES_128_CBC();
            } else {
                DcmEcho.exit("Invalid parameter for option -tls: " + cipher);
            }
            if (cl.hasOption("tls1")) {
                dcmecho.setTlsProtocol(TLS1);
            } else if (cl.hasOption("ssl3")) {
                dcmecho.setTlsProtocol(SSL3);
            } else if (cl.hasOption("no_tls1")) {
                dcmecho.setTlsProtocol(NO_TLS1);
            } else if (cl.hasOption("no_ssl3")) {
                dcmecho.setTlsProtocol(NO_SSL3);
            } else if (cl.hasOption("no_ssl2")) {
                dcmecho.setTlsProtocol(NO_SSL2);
            }
            dcmecho.setTlsNeedClientAuth(!cl.hasOption("noclientauth"));
            if (cl.hasOption("keystore")) {
                dcmecho.setKeyStoreURL(cl.getOptionValue("keystore"));
            }
            if (cl.hasOption("keystorepw")) {
                dcmecho.setKeyStorePassword(cl.getOptionValue("keystorepw"));
            }
            if (cl.hasOption("keypw")) {
                dcmecho.setKeyPassword(cl.getOptionValue("keypw"));
            }
            if (cl.hasOption("truststore")) {
                dcmecho.setTrustStoreURL(cl.getOptionValue("truststore"));
            }
            if (cl.hasOption("truststorepw")) {
                dcmecho.setTrustStorePassword(cl.getOptionValue("truststorepw"));
            }
            long t1 = System.currentTimeMillis();
            try {
                dcmecho.initTLS();
            }
            catch (Exception e) {
                System.err.println("ERROR: Failed to initialize TLS context:" + e.getMessage());
                System.exit(2);
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Initialize TLS context in " + (float)(t2 - t1) / 1000.0f + "s");
        }
        long t1 = System.currentTimeMillis();
        try {
            dcmecho.open();
        }
        catch (Exception e) {
            System.err.println("ERROR: Failed to establish association:" + e.getMessage());
            System.exit(2);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Connected to " + remoteAE + " in " + (float)(t2 - t1) / 1000.0f + "s");
        block8: while (true) {
            try {
                while (true) {
                    dcmecho.echo();
                    long t3 = System.currentTimeMillis();
                    System.out.println("Perform Verification in " + (float)(t2 - t3) / 1000.0f + "s");
                    if (repeat == 0 || closeAssoc) {
                        dcmecho.close();
                        System.out.println("Released connection to " + remoteAE);
                    }
                    if (repeat-- == 0) break block8;
                    Thread.sleep(interval);
                    long t4 = System.currentTimeMillis();
                    dcmecho.open();
                    t2 = System.currentTimeMillis();
                    System.out.println("Reconnect or reuse connection to " + remoteAE + " in " + (float)(t2 - t4) / 1000.0f + "s");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static int toPort(String port) {
        return port != null ? DcmEcho.parseInt(port, "illegal port number", 1, 65535) : 104;
    }

    private static int parseInt(String s, String errPrompt, int min, int max) {
        try {
            int i = Integer.parseInt(s);
            if (i >= min && i <= max) {
                return i;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DcmEcho.exit(errPrompt);
        throw new RuntimeException();
    }

    private static String[] split(String s, char delim) {
        String[] s2 = new String[]{s, null};
        int pos = s.indexOf(delim);
        if (pos != -1) {
            s2[0] = s.substring(0, pos);
            s2[1] = s.substring(pos + 1);
        }
        return s2;
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.err.println("Try 'dcmecho -h' for more information.");
        System.exit(1);
    }

    public void initTLS() throws GeneralSecurityException, IOException {
        KeyStore keyStore = DcmEcho.loadKeyStore(this.keyStoreURL, this.keyStorePassword);
        KeyStore trustStore = DcmEcho.loadKeyStore(this.trustStoreURL, this.trustStorePassword);
        this.device.initTLS(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword, trustStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String url, char[] password) throws GeneralSecurityException, IOException {
        KeyStore key = KeyStore.getInstance(DcmEcho.toKeyStoreType(url));
        InputStream in = DcmEcho.openFileOrURL(url);
        try {
            key.load(in, password);
        }
        finally {
            in.close();
        }
        return key;
    }

    private static InputStream openFileOrURL(String url) throws IOException {
        if (url.startsWith("resource:")) {
            return DcmEcho.class.getClassLoader().getResourceAsStream(url.substring(9));
        }
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(url);
        }
    }

    private static String toKeyStoreType(String fname) {
        return fname.endsWith(".p12") || fname.endsWith(".P12") ? "PKCS12" : "JKS";
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    public void echo() throws IOException, InterruptedException {
        this.assoc.cecho().next();
    }

    public void close() throws InterruptedException {
        this.assoc.release(true);
    }
}

