/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import uk.co.mmscomputing.concurrent.ArrayBlockingQueue;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.Mixer;

class TargetDataLine
extends DataLine
implements javax.sound.sampled.TargetDataLine {
    private ArrayBlockingQueue queue = new ArrayBlockingQueue(1);

    TargetDataLine() {
    }

    public void open() throws LineUnavailableException {
        this.open(Mixer.format);
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, this.getBufferSize());
    }

    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        super.open();
        if (!audioFormat.matches(Mixer.format)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioFormat format, int bufferSize) :\n\t." + "format does not match Mixer format");
        }
        if (n < this.getBufferSize()) {
            throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioFormat format, int bufferSize) :\n\t." + "parameter bufferSize too small [" + n + " < " + this.getBufferSize() + "]");
        }
    }

    public void drain() {
        this.flush();
    }

    public void flush() {
        this.queue.clear();
    }

    public void start() {
        this.flush();
        super.start();
    }

    public void close() {
        super.close();
        this.flush();
        this.queue.offer(new byte[0]);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (!this.isOpen()) {
            throw new IllegalStateException(this.getClass().getName() + ".read(byte[] buf, int off, int len): Line is not open.");
        }
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] buf, int off, int len): b is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] buf, int off, int len): index off or len out of bounds.");
        }
        if (n2 < this.getBufferSize()) {
            throw new IllegalArgumentException(this.getClass().getName() + ".read(byte[] buf, int off, int len) :\n\t" + "parameter len smaller then audio output buffer size [" + n2 + " < " + this.getBufferSize() + "]");
        }
        try {
            byte[] byArray2 = (byte[])this.queue.take();
            n2 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n2);
            return n2;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    boolean offer(byte[] byArray) {
        if (this.queue.isFull()) {
            return false;
        }
        return this.queue.offer(byArray);
    }
}

