/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import uk.co.mmscomputing.concurrent.ArrayBlockingQueue;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.Mixer;

class SpeakerThread
extends Thread {
    boolean isrunning = false;
    private SourceDataLine speaker = null;
    private DataLine[] sources = null;
    private ArrayBlockingQueue queue = new ArrayBlockingQueue(10);

    public SpeakerThread(DataLine[] dataLineArray) throws LineUnavailableException {
        this.sources = dataLineArray;
        AudioFormat audioFormat = dataLineArray[0].getFormat();
        int n = dataLineArray[0].getBufferSize();
        this.speaker = this.getSpeaker(audioFormat, n);
        for (int i = 0; i < dataLineArray.length; ++i) {
            dataLineArray[i].setSpeakerThread(this);
        }
    }

    private SourceDataLine getSpeaker(AudioFormat audioFormat, int n) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        for (int i = 0; i < infoArray.length; ++i) {
            javax.sound.sampled.Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            if (mixer instanceof Mixer) continue;
            try {
                SourceDataLine sourceDataLine = (SourceDataLine)mixer.getLine(info);
                sourceDataLine.open(audioFormat, n);
                return sourceDataLine;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        throw new LineUnavailableException(this.getClass().getName() + ".run() : \n\tNo microphone available.");
    }

    void flush(DataLine dataLine) {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].isActive()) continue;
            if (this.sources[i] == dataLine) {
                this.queue.offer(new byte[0]);
            }
            return;
        }
    }

    void put(DataLine dataLine, byte[] byArray) {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].isActive()) continue;
            if (this.sources[i] == dataLine) {
                try {
                    this.queue.put(byArray);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.isrunning = true;
            this.speaker.flush();
            this.speaker.start();
            while (this.isrunning) {
                byte[] byArray = (byte[])this.queue.take();
                if (byArray.length == 0) {
                    this.speaker.flush();
                    continue;
                }
                this.speaker.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.speaker.stop();
            this.speaker.flush();
            this.speaker.close();
        }
    }
}

