/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound.provider;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import uk.co.mmscomputing.sound.provider.DataLine;
import uk.co.mmscomputing.sound.provider.Mixer;

class SourceDataLine
extends DataLine
implements javax.sound.sampled.SourceDataLine {
    SourceDataLine() {
    }

    public void open() throws LineUnavailableException {
        this.open(Mixer.format);
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, this.getBufferSize());
    }

    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        super.open();
        if (!audioFormat.matches(Mixer.format)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".open(AudioFormat format, int bufferSize) :\n\t." + "format does not match Mixer format");
        }
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.speaker.flush(this);
        super.stop();
    }

    public int write(byte[] byArray, int n, int n2) {
        if (!this.isactive || byArray.length == 0) {
            return 0;
        }
        if (!this.isopen) {
            throw new IllegalStateException();
        }
        if (n2 < 0 || n2 % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".write(byte[] buf, int off, int len).");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException(this.getClass().getName() + ".write(byte[] buf, int off, int len): index off or len out of bounds.");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.speaker.put(this, byArray2);
        return n2;
    }
}

