/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;

public class WaveOutputFile
extends RandomAccessFile {
    byte[] h = new byte[58];

    public WaveOutputFile(File file, AudioFormat audioFormat) throws FileNotFoundException, IOException {
        super(file, "rw");
        this.write(this.getHeader(audioFormat));
    }

    public WaveOutputFile(String string, AudioFormat audioFormat) throws FileNotFoundException, IOException {
        super(string, "rw");
        this.write(this.getHeader(audioFormat));
    }

    private byte[] getHeader(AudioFormat audioFormat) {
        int n = 0;
        this.h[n++] = 82;
        this.h[n++] = 73;
        this.h[n++] = 70;
        this.h[n++] = 70;
        this.h[n++] = 50;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 87;
        this.h[n++] = 65;
        this.h[n++] = 86;
        this.h[n++] = 69;
        this.h[n++] = 102;
        this.h[n++] = 109;
        this.h[n++] = 116;
        this.h[n++] = 32;
        this.h[n++] = 18;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.h[n++] = 1;
            this.h[n++] = 0;
        } else {
            if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".getHeader(AudioFormat format)\n\tDo not support PCM unsigned data");
            }
            if (encoding.equals(AudioFormat.Encoding.ALAW)) {
                this.h[n++] = 6;
                this.h[n++] = 0;
            } else if (encoding.equals(AudioFormat.Encoding.ULAW)) {
                this.h[n++] = 7;
                this.h[n++] = 0;
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + ".getHeader(AudioFormat format)\n\tDo not support encoding [" + encoding + "]");
            }
        }
        int n2 = audioFormat.getChannels();
        if (n2 == 1) {
            this.h[n++] = 1;
            this.h[n++] = 0;
        } else if (n2 == 2) {
            this.h[n++] = 2;
            this.h[n++] = 0;
        } else {
            throw new IllegalArgumentException(this.getClass().getName() + ".getHeader(AudioFormat format)\n\tDo not support " + n2 + " channels");
        }
        int n3 = (int)audioFormat.getFrameRate();
        this.h[n++] = (byte)(n3 & 0xFF);
        this.h[n++] = (byte)(n3 >> 8 & 0xFF);
        this.h[n++] = (byte)(n3 >> 16 & 0xFF);
        this.h[n++] = (byte)(n3 >> 24 & 0xFF);
        int n4 = audioFormat.getFrameSize();
        int n5 = n3 * n4;
        this.h[n++] = (byte)(n5 & 0xFF);
        this.h[n++] = (byte)(n5 >> 8 & 0xFF);
        this.h[n++] = (byte)(n5 >> 16 & 0xFF);
        this.h[n++] = (byte)(n5 >> 24 & 0xFF);
        this.h[n++] = (byte)(n4 & 0xFF);
        this.h[n++] = (byte)(n4 >> 8 & 0xFF);
        int n6 = audioFormat.getSampleSizeInBits();
        this.h[n++] = (byte)(n6 & 0xFF);
        this.h[n++] = (byte)(n6 >> 8 & 0xFF);
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 102;
        this.h[n++] = 97;
        this.h[n++] = 99;
        this.h[n++] = 116;
        this.h[n++] = 4;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 100;
        this.h[n++] = 97;
        this.h[n++] = 116;
        this.h[n++] = 97;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        this.h[n++] = 0;
        return this.h;
    }

    public void close() throws IOException {
        long l = this.length();
        if (l >= Integer.MAX_VALUE) {
            throw new IOException(this.getClass().getName() + ".close()\n\tData size [" + l + "] is too big for WAV file.");
        }
        int n = 4;
        int n2 = (int)l - 8;
        this.h[n++] = (byte)(n2 & 0xFF);
        this.h[n++] = (byte)(n2 >> 8 & 0xFF);
        this.h[n++] = (byte)(n2 >> 16 & 0xFF);
        this.h[n++] = (byte)(n2 >> 24 & 0xFF);
        n = 46;
        n2 = (int)l - 58;
        this.h[n++] = (byte)(n2 & 0xFF);
        this.h[n++] = (byte)(n2 >> 8 & 0xFF);
        this.h[n++] = (byte)(n2 >> 16 & 0xFF);
        this.h[n++] = (byte)(n2 >> 24 & 0xFF);
        n = 54;
        this.h[n++] = (byte)(n2 & 0xFF);
        this.h[n++] = (byte)(n2 >> 8 & 0xFF);
        this.h[n++] = (byte)(n2 >> 16 & 0xFF);
        this.h[n++] = (byte)(n2 >> 24 & 0xFF);
        this.seek(0L);
        this.write(this.h);
        super.close();
    }
}

