/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class SoundMixer {
    static AudioFormat[] formats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 16, 2, 4, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 16, 2, 4, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 16, 1, 2, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 16, 1, 2, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 2, 2, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 2, 2, 8000.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 1, 1, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 1, 1, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.ALAW, 8000.0f, 8, 1, 1, 8000.0f, true), new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, true)};
    private final int id;
    private final Mixer mixer;
    private final Mixer.Info info;

    public SoundMixer(int n, Mixer.Info info) {
        this.id = n;
        this.info = info;
        this.mixer = AudioSystem.getMixer(info);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.mixer.getMixerInfo().getName();
    }

    public Mixer.Info getMixerInfo() {
        return this.info;
    }

    public String toString() {
        DataLine dataLine;
        int n;
        Mixer.Info info = this.mixer.getMixerInfo();
        String string = "\nMixer [" + this.id + "]";
        string = string + "\n\t Name: " + info.getName();
        string = string + "\n\t Desc: " + info.getDescription();
        string = string + "\n\t Ven : " + info.getVendor();
        string = string + "\n\t Ver : " + info.getVersion();
        string = string + "\n\t Str : " + info.toString();
        Line.Info[] infoArray = this.mixer.getSourceLineInfo();
        string = string + "\n\nSourceLine count : " + infoArray.length;
        for (n = 0; n < infoArray.length; ++n) {
            if (infoArray[n] instanceof DataLine.Info) {
                string = string + "\n\t\tData Line Source [" + n + "]";
                string = string + "\n\t\t\t Str : " + infoArray[n].toString();
                continue;
            }
            if (infoArray[n] instanceof Port.Info) {
                string = string + "\n\t\tPort Source [" + n + "]";
                string = string + "\n\t\t\t Name: " + ((Port.Info)infoArray[n]).getName();
                string = string + "\n\t\t\t is Src: " + ((Port.Info)infoArray[n]).isSource();
                string = string + "\n\t\t\t Str : " + infoArray[n].toString();
                continue;
            }
            string = string + "\n\t\tSource [" + n + "]";
            string = string + "\n\t\t\t Str : " + infoArray[n].toString();
        }
        string = string + "\n\nOUTPUT\n";
        for (n = 0; n < formats.length; ++n) {
            try {
                dataLine = this.getOutputLine(formats[n]);
                dataLine.close();
                string = string + "\n" + formats[n].toString();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        infoArray = this.mixer.getTargetLineInfo();
        string = string + "\n\nTargetLine count : " + infoArray.length;
        for (n = 0; n < infoArray.length; ++n) {
            if (infoArray[n] instanceof DataLine.Info) {
                string = string + "\n\t\tData Line Target [" + n + "]";
                string = string + "\n\t\t\t Str : " + infoArray[n].toString();
                continue;
            }
            if (infoArray[n] instanceof Port.Info) {
                string = string + "\n\t\tPort Target [" + n + "]";
                string = string + "\n\t\t\t Name: " + ((Port.Info)infoArray[n]).getName();
                string = string + "\n\t\t\t is Src: " + ((Port.Info)infoArray[n]).isSource();
                string = string + "\n\t\t\t Str : " + infoArray[n].toString();
                continue;
            }
            string = string + "\n\t\tTarget [" + n + "]";
            string = string + "\n\t\t\t Str : " + infoArray[n].toString();
        }
        string = string + "\n\nINPUT\n";
        for (n = 0; n < formats.length; ++n) {
            try {
                dataLine = this.getInputLine(formats[n]);
                dataLine.close();
                string = string + "\n" + formats[n].toString();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public TargetDataLine getInputLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = (TargetDataLine)this.mixer.getLine(info);
        targetDataLine.open(audioFormat, n);
        return targetDataLine;
    }

    public TargetDataLine getInputLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = (TargetDataLine)this.mixer.getLine(info);
        targetDataLine.open(audioFormat, targetDataLine.getBufferSize());
        return targetDataLine;
    }

    public SourceDataLine getOutputLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        SourceDataLine sourceDataLine = (SourceDataLine)this.mixer.getLine(info);
        sourceDataLine.open(audioFormat, n);
        return sourceDataLine;
    }

    public SourceDataLine getOutputLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        SourceDataLine sourceDataLine = (SourceDataLine)this.mixer.getLine(info);
        sourceDataLine.open(audioFormat, sourceDataLine.getBufferSize());
        return sourceDataLine;
    }
}

