/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sound;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;

public class EavesdropInputStream
extends FilterInputStream {
    private SourceDataLine aout = null;
    private boolean doListen = true;

    public EavesdropInputStream(InputStream inputStream, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(inputStream);
        this.aout = SoundMixerEnumerator.getOutputLine(audioFormat, n);
        this.aout.start();
    }

    public EavesdropInputStream(InputStream inputStream, AudioFormat audioFormat) throws LineUnavailableException {
        this(inputStream, audioFormat, 512);
    }

    public EavesdropInputStream(AudioInputStream audioInputStream, int n) throws LineUnavailableException {
        this(audioInputStream, audioInputStream.getFormat(), n);
    }

    public EavesdropInputStream(AudioInputStream audioInputStream) throws LineUnavailableException {
        this(audioInputStream, 512);
    }

    public void setListen(boolean bl) {
        this.doListen = bl;
    }

    public int read() throws IOException {
        throw new IOException(this.getClass().getName() + ".read() :\n\tDo not support simple 'int read()'.");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((n2 = this.in.read(byArray, n, n2)) == -1) {
            return -1;
        }
        if (this.doListen) {
            this.aout.write(byArray, n, n2);
        }
        return n2;
    }

    public void flush() {
        this.aout.flush();
    }

    public void close() throws IOException {
        this.in.close();
        this.aout.stop();
        this.aout.flush();
        this.aout.close();
    }
}

