/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMS7BitInputStream;
import uk.co.mmscomputing.sms.SMS7BitOutputStream;
import uk.co.mmscomputing.sms.SMSDataUnit;

public class SMSTransportProtocolDataUnit
extends SMSDataUnit {
    private byte[] data = new byte[0];

    public byte[] getUserData() {
        return this.data;
    }

    public void setUserData(byte[] byArray) {
        this.data = byArray;
    }

    public void readUserDataFrom(InputStream inputStream) throws IOException {
        boolean bl = this.getBoolean("TP-UDHI");
        int n = this.read(inputStream);
        if (bl) {
            int n2 = this.read(inputStream);
            byte[] byArray = new byte[n2];
            System.err.println("TP-UDHL = " + n2);
            for (int i = 0; i < n2; ++i) {
                System.err.println("[" + i + "]=0x" + Integer.toHexString(this.read(inputStream)));
            }
            n -= n2;
        }
        this.data = new byte[n];
        if (n != new SMS7BitInputStream(inputStream).read(this.data)) {
            // empty if block
        }
    }

    public void writeUserDataTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data.length);
        outputStream = new SMS7BitOutputStream(outputStream);
        outputStream.write(this.data);
        outputStream.flush();
    }

    public String toString() {
        String string = super.toString();
        if (this.data.length > 0) {
            string = string + "\ndata        = " + new String(this.data) + "\n\n";
        }
        return string;
    }
}

