/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import uk.co.mmscomputing.sms.SMSTransportProtocolParameter;

public class SMSTimeStamp
extends SMSTransportProtocolParameter {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int min;
    private int sec;
    private int zone;

    public SMSTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        this.year = calendar.get(1) % 100;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        this.sec = calendar.get(13);
        this.zone = calendar.get(15) / 3600000;
    }

    public SMSTimeStamp(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        this.year = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.month = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.day = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.hour = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.min = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.sec = SMSTimeStamp.readUnsignedNibble(inputStream);
        this.zone = SMSTimeStamp.readSignedNibble(inputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.year);
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.month);
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.day);
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.hour);
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.min);
        SMSTimeStamp.writeUnsignedNibble(outputStream, this.sec);
        SMSTimeStamp.writeSignedNibble(outputStream, this.zone);
    }

    public static int readUnsignedNibble(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = n >> 4 & 0xF;
        int n3 = (n & 0xF) * 10;
        return n3 + n2;
    }

    public static int readSignedNibble(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = n >> 4 & 0xF;
        int n3 = (n & 7) * 10;
        return (n & 8) == 0 ? n3 + n2 : -(n3 + n2);
    }

    public static void writeUnsignedNibble(OutputStream outputStream, int n) throws IOException {
        int n2 = n % 10 & 0xF;
        int n3 = n / 10 & 0xF;
        outputStream.write(n2 << 4 | n3);
    }

    public static void writeSignedNibble(OutputStream outputStream, int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = n % 10 & 0xF;
        int n3 = n / 10 & 7;
        if (bl) {
            n3 |= 8;
        }
        outputStream.write(n2 << 4 | n3);
    }

    public String toString() {
        return "" + this.year + "-" + this.month + "-" + this.day + " " + this.hour + ":" + this.min + ":" + this.sec + " GMT " + this.zone;
    }
}

