/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSDataCodingScheme;
import uk.co.mmscomputing.sms.SMSTransportProtocolDataUnit;
import uk.co.mmscomputing.sms.SMSValidityPeriod;

public class SMSSubmit
extends SMSTransportProtocolDataUnit {
    public SMSSubmit(int n, String string, String string2) {
        this.put("TP-MR", new Integer(n));
        this.put("TP-DA", new SMSAddress(string));
        this.put("TP-PID", new Integer(0));
        this.put("TP-DCS", new SMSDataCodingScheme(241));
        this.setUserData(string2.getBytes());
    }

    public SMSSubmit(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.put("TP-MTI", new Integer(n & 3));
        this.put("TP-RD", new Boolean((n >> 2 & 1) != 0));
        int n2 = n >> 3 & 3;
        this.put("TP-VPF", new Integer(n2));
        this.put("TP-SRR", new Boolean((n >> 5 & 1) != 0));
        this.put("TP-UDHI", new Boolean((n >> 6 & 1) != 0));
        this.put("TP-RP", new Boolean((n >> 7 & 1) != 0));
        this.put("TP-MR", new Integer(this.readInt(inputStream)));
        this.put("TP-DA", new SMSAddress(inputStream));
        this.put("TP-PID", new Integer(this.readOctet(inputStream)));
        this.put("TP-DCS", new SMSDataCodingScheme(this.readOctet(inputStream)));
        if (n2 != 0) {
            this.put("TP-VP", new SMSValidityPeriod(n2, inputStream));
        }
        this.readUserDataFrom(inputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(17);
        outputStream.write(1);
        outputStream.write(this.getInt("TP-MR"));
        ((SMSAddress)this.get("TP-DA")).writeTo(outputStream);
        outputStream.write(this.getOctet("TP-PID"));
        ((SMSDataCodingScheme)this.get("TP-DCS")).writeTo(outputStream);
        this.writeUserDataTo(outputStream);
        outputStream.flush();
    }
}

